/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.systems.modules.world;

import com.genyo.GenyoAddon;
import com.genyo.managers.Managers;
import com.genyo.render.animation.Animation;
import com.genyo.systems.modules.PlacerModule;
import com.genyo.systems.modules.world.GenyoAutoMine;
import com.genyo.systems.settings.FloatSetting;
import com.genyo.utils.math.GPositionUtils;
import com.genyo.utils.math.MathUtil;
import com.genyo.utils.player.Rotation;
import com.genyo.utils.world.BlastResistantBlocks;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.utils.player.FindItemResult;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.meteorclient.utils.world.BlockUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1511;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2626;
import net.minecraft.class_2664;
import net.minecraft.class_2680;
import net.minecraft.class_2824;
import net.minecraft.class_2879;
import net.minecraft.class_3726;
import net.minecraft.class_8042;

public class GenyoSurroundV2
extends PlacerModule {
    private final SettingGroup sgGeneral;
    private final Setting<Boolean> rotate;
    private final Setting<Timing> timing;
    private final Setting<Boolean> buggy;
    private final Setting<Boolean> prePlaceExplosion;
    private final Setting<Boolean> prePlaceTick;
    private final Setting<Float> placeRange;
    private final Setting<Boolean> attack;
    private final Setting<Boolean> extend;
    private final Setting<Boolean> head;
    private final Setting<Boolean> mineExtend;
    private final Setting<Boolean> support;
    private final Setting<Integer> shiftTicks;
    private final Setting<Float> shiftDelay;
    private final Setting<Boolean> jumpDisable;
    private final Setting<Boolean> render;
    private final Setting<Integer> fadeTime;
    private final Setting<SettingColor> color;
    private int blocksPlaced;
    private List<class_2338> surround;
    private List<class_2338> placements;
    private final Map<class_2338, Long> packets;
    private final Map<class_2338, Animation> fadeList;
    private double prevY;

    public GenyoSurroundV2() {
        super(GenyoAddon.WORLD, "genyo-surround-v2", "ma reggel befostam azt\u00e1n felkeltem");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.rotate = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Rotate")).description("ekwjfkljweklfjewfew")).defaultValue((Object)false)).build());
        this.timing = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("Timing")).description("Timing for replacing blocks")).defaultValue((Object)Timing.VANILLA)).build());
        this.buggy = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Buggy Placing")).description("not a bug, its a genyo feature")).defaultValue((Object)(this.timing.get() == Timing.SEQUENTIAL ? 1 : 0))).visible(() -> this.timing.get() == Timing.SEQUENTIAL)).build());
        this.prePlaceExplosion = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Pre Place Explosions")).description("Pre places before explosions")).defaultValue((Object)false)).visible(() -> this.timing.get() == Timing.SEQUENTIAL)).build());
        this.prePlaceTick = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Pre Place Tick")).description("Pre places before ticks")).defaultValue((Object)false)).visible(() -> this.timing.get() == Timing.SEQUENTIAL)).build());
        this.placeRange = this.sgGeneral.add((Setting)((FloatSetting.Builder)((Object)((FloatSetting.Builder)((Object)new FloatSetting.Builder().name("Place Range"))).description("The placement range for surround"))).defaultValue(4.0f).min(0.0f).max(6.0f).build());
        this.attack = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Attack")).description("Attacks crystals in the way of surround")).defaultValue((Object)true)).build());
        this.extend = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Extend")).description("Extends surround if the player is not in the center of a block")).defaultValue((Object)true)).build());
        this.head = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Cover Head")).description("Place a block at your head")).defaultValue((Object)false)).build());
        this.mineExtend = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Mine Extend")).description("Extends surround if the block is being mined")).defaultValue((Object)false)).build());
        this.support = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Support")).description("Creates a floor for the surround if there is none")).defaultValue((Object)false)).build());
        this.shiftTicks = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Shift Ticks")).description("The number of blocks to place per tick")).min(1).defaultValue((Object)2)).max(10).build());
        this.shiftDelay = this.sgGeneral.add((Setting)((FloatSetting.Builder)((Object)((FloatSetting.Builder)((Object)new FloatSetting.Builder().name("Shift Delay"))).description("The delay between each block placement interval"))).min(0.0f).defaultValue(1.0f).max(5.0f).build());
        this.jumpDisable = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Auto Disable")).description("Disables after moving out of the hole")).defaultValue((Object)true)).build());
        this.render = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Render")).description("Renders where scaffold is placing blocks")).defaultValue((Object)false)).build());
        this.fadeTime = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Fade Time")).description("Time to fade")).min(0).defaultValue((Object)250)).max(1000).visible(() -> false)).build());
        this.color = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("Render Color")).description("asdsadsadsadsadsa")).defaultValue(new Color(236, 243, 122, 40)).build());
        this.surround = new ArrayList<class_2338>();
        this.placements = new ArrayList<class_2338>();
        this.packets = new HashMap<class_2338, Long>();
        this.fadeList = new HashMap<class_2338, Animation>();
    }

    public void onActivate() {
        if (this.mc.field_1724 == null) {
            return;
        }
        this.prevY = this.mc.field_1724.method_23318();
    }

    public void onDeactivate() {
        this.surround.clear();
        this.placements.clear();
        this.packets.clear();
        this.fadeList.clear();
    }

    @EventHandler
    public void onTick(TickEvent.Pre event) {
        this.blocksPlaced = 0;
        if (((Boolean)this.jumpDisable.get()).booleanValue() && (this.mc.field_1724.method_23318() - this.prevY > 0.5 || this.mc.field_1724.field_6017 > 1.5f)) {
            this.sendDisableMsg("Player jumped, disabling.");
            this.toggle();
            return;
        }
        if (!((Boolean)this.multitaskConfig.get()).booleanValue() && this.checkMultitask()) {
            this.surround.clear();
            this.placements.clear();
            return;
        }
        int slot = this.getResistantBlockItem();
        if (slot == -1) {
            this.surround.clear();
            this.placements.clear();
            return;
        }
        this.surround = this.getSurround((class_1657)this.mc.field_1724);
        if (this.surround.isEmpty()) {
            return;
        }
        if (((Boolean)this.attack.get()).booleanValue()) {
            this.attackBlockingCrystals(this.surround);
        }
        this.placements = this.getPlacementsFromSurround(this.surround);
        if (this.placements.isEmpty()) {
            return;
        }
        if (((Boolean)this.support.get()).booleanValue()) {
            for (class_2338 block : new ArrayList<class_2338>(this.placements)) {
                class_2350 direction;
                if ((double)block.method_10264() > (double)this.mc.field_1724.method_31478() + 1.0 || (direction = this.mc.field_1724.method_5735()) != null) continue;
                this.placements.add(block.method_10074());
            }
        }
        this.placements.sort(Comparator.comparingInt(class_2382::method_10264));
        while (this.blocksPlaced < (Integer)this.shiftTicks.get() && this.blocksPlaced < this.placements.size()) {
            class_2338 targetPos = this.placements.get(this.blocksPlaced);
            this.placeBlock(targetPos, slot);
        }
        if (((Boolean)this.rotate.get()).booleanValue()) {
            Rotation.get().setRotationSilentSync();
        }
    }

    @EventHandler
    public void onPacketReceive(PacketEvent.Receive event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        class_2596 class_25962 = event.packet;
        if (class_25962 instanceof class_8042) {
            class_8042 packet = (class_8042)class_25962;
            for (class_2596 packet1 : packet.method_48324()) {
                this.handlePackets(packet1);
            }
        } else {
            this.handlePackets(event.packet);
        }
    }

    private void handlePackets(class_2596<?> serverPacket) {
        int slot;
        class_2626 packet;
        if (this.timing.get() != Timing.SEQUENTIAL) {
            return;
        }
        if (serverPacket instanceof class_2626) {
            packet = (class_2626)serverPacket;
            class_2680 blockState = packet.method_11308();
            class_2338 targetPos = packet.method_11309();
            if (this.surround.contains(targetPos)) {
                if (blockState.method_45474() && Objects.requireNonNull(this.mc.field_1687).method_8628(DEFAULT_OBSIDIAN_STATE, targetPos, class_3726.method_16194())) {
                    slot = this.getResistantBlockItem();
                    if (slot == -1) {
                        return;
                    }
                    this.placeBlock(targetPos, slot);
                } else if (BlastResistantBlocks.isBlastResistant(blockState)) {
                    this.packets.remove(targetPos);
                }
            }
        }
        if (this.blocksPlaced > (Integer)this.shiftTicks.get() * 2) {
            return;
        }
        if (serverPacket instanceof class_2664) {
            class_2338 pos;
            packet = (class_2664)serverPacket;
            if (((Boolean)this.prePlaceExplosion.get()).booleanValue() && this.surround.contains(pos = class_2338.method_49637((double)packet.comp_2883().method_10216(), (double)packet.comp_2883().method_10214(), (double)packet.comp_2883().method_10215()))) {
                int slot2 = this.getResistantBlockItem();
                if (slot2 == -1) {
                    return;
                }
                this.placeBlock(pos, slot2);
            }
        }
        if (serverPacket instanceof class_2604 && (packet = (class_2604)serverPacket).method_11169().equals(class_1299.field_6110) && ((Boolean)this.prePlaceTick.get()).booleanValue()) {
            for (class_2338 pos : this.surround) {
                if (!pos.equals((Object)class_2338.method_49637((double)packet.method_11175(), (double)packet.method_11174(), (double)packet.method_11176()))) continue;
                slot = this.getResistantBlockItem();
                if (slot == -1) {
                    return;
                }
                this.placeBlock(pos, slot);
                break;
            }
        }
    }

    private void placeBlock(class_2338 pos, int slot) {
        if (!((Boolean)this.buggy.get()).booleanValue()) {
            Managers.INTERACT.placeBlock(pos, slot, (boolean)((Boolean)this.strictDirectionConfig.get()), false, true, (state, angles) -> {
                if (((Boolean)this.rotate.get()).booleanValue() && state) {
                    Managers.ROTATION.setRotationSilent(angles[0], angles[1]);
                }
            });
        } else {
            if (slot == -1) {
                return;
            }
            if (InvUtils.findInHotbar((class_1792[])new class_1792[]{class_1802.field_8281}) == null) {
                return;
            }
            Managers.INVENTORY.setSlot(slot);
            BlockUtils.place((class_2338)pos, (FindItemResult)InvUtils.findInHotbar((class_1792[])new class_1792[]{class_1802.field_8281}), (boolean)((Boolean)this.rotate.get()), (int)0, (boolean)true);
        }
        this.packets.put(pos, System.currentTimeMillis());
        ++this.blocksPlaced;
    }

    public void attackBlockingCrystals(List<class_2338> posList) {
        for (class_2338 pos : posList) {
            class_1297 crystalEntity = this.mc.field_1687.method_8335(null, new class_238(pos)).stream().filter(e -> e instanceof class_1511).findFirst().orElse(null);
            if (crystalEntity == null) continue;
            this.mc.method_1562().method_52787((class_2596)class_2824.method_34206((class_1297)crystalEntity, (boolean)this.mc.field_1724.method_5715()));
            this.mc.method_1562().method_52787((class_2596)new class_2879(class_1268.field_5808));
            return;
        }
    }

    public List<class_2338> getPlacementsFromSurround(List<class_2338> surround) {
        ArrayList<class_2338> placements = new ArrayList<class_2338>();
        for (class_2338 surroundPos : surround) {
            double dist;
            Long placed = this.packets.get(surroundPos);
            if (((Float)this.shiftDelay.get()).floatValue() > 0.0f && placed != null && (float)(System.currentTimeMillis() - placed) < ((Float)this.shiftDelay.get()).floatValue() * 50.0f || !this.mc.field_1687.method_8320(surroundPos).method_45474() || (dist = this.mc.field_1724.method_5707(surroundPos.method_46558())) > (double)MathUtil.squared(((Float)this.placeRange.get()).floatValue()) || !this.mc.field_1687.method_8628(DEFAULT_OBSIDIAN_STATE, surroundPos, class_3726.method_16194())) continue;
            placements.add(surroundPos);
        }
        return placements;
    }

    public List<class_2338> getSurround(class_1657 player) {
        List<class_2338> surroundBlocks = this.getSurroundNoDown(player);
        List<class_2338> playerBlocks = this.getPlayerBlocks(player);
        for (class_2338 playerPos : playerBlocks) {
            if (playerPos.equals((Object)player.method_24515())) continue;
            surroundBlocks.add(playerPos.method_10074());
        }
        if (((Boolean)this.mineExtend.get()).booleanValue()) {
            for (class_2338 surroundPos : new ArrayList<class_2338>(surroundBlocks)) {
                if (!Managers.BLOCK.isPassed(surroundPos, 0.7f)) continue;
                for (class_2350 direction : class_2350.values()) {
                    class_2338 blockerPos;
                    if (direction == class_2350.field_11033 || playerBlocks.contains(blockerPos = surroundPos.method_10093(direction)) || ((GenyoAutoMine)Modules.get().get(GenyoAutoMine.class)).getMiningBlock() == blockerPos) continue;
                    surroundBlocks.add(blockerPos);
                }
            }
        }
        return surroundBlocks;
    }

    public List<class_2338> getSurroundNoDown(class_1657 player) {
        return this.getSurroundNoDown(player, 0.0f);
    }

    public List<class_2338> getSurroundNoDown(class_1657 player, float range) {
        ArrayList<class_2338> surroundBlocks = new ArrayList<class_2338>();
        List<class_2338> playerBlocks = this.getPlayerBlocks(player);
        for (class_2338 pos : playerBlocks) {
            if (range > 0.0f && this.mc.field_1724.method_33571().method_1025(pos.method_46558()) > (double)(range * range)) continue;
            for (class_2350 dir : class_2350.values()) {
                class_2338 pos1;
                if (!dir.method_10166().method_10179() || surroundBlocks.contains(pos1 = pos.method_10093(dir)) || playerBlocks.contains(pos1)) continue;
                surroundBlocks.add(pos1);
            }
        }
        return surroundBlocks;
    }

    public List<class_2338> getPlayerBlocks(class_1657 entity) {
        class_2338 playerPos = GPositionUtils.getRoundedBlockPos(entity.method_23317(), entity.method_23318(), entity.method_23321());
        ArrayList<class_2338> playerBlocks = new ArrayList<class_2338>();
        if (((Boolean)this.extend.get()).booleanValue()) {
            playerBlocks.addAll(GPositionUtils.getAllInBox(entity.method_5829(), playerPos));
        } else {
            playerBlocks.add(playerPos);
        }
        return playerBlocks;
    }

    @EventHandler
    public void onRender3D(Render3DEvent event) {
        if (this.mc.field_1687 == null && this.mc.field_1724 == null) {
            return;
        }
        if (((Boolean)this.render.get()).booleanValue()) {
            for (Map.Entry<class_2338, Animation> set : this.fadeList.entrySet()) {
                set.getValue().setState(false);
                int boxAlpha = (int)(40.0 * set.getValue().getFactor());
                int lineAlpha = (int)(100.0 * set.getValue().getFactor());
                Color boxColor = ((SettingColor)this.color.get()).a(boxAlpha);
                Color lineColor = ((SettingColor)this.color.get()).a(lineAlpha);
                event.renderer.box(set.getKey(), boxColor, lineColor, ShapeMode.Both, 1);
            }
            if (this.placements.isEmpty()) {
                return;
            }
            for (class_2338 pos : this.placements) {
                Animation animation = new Animation(true, ((Integer)this.fadeTime.get()).intValue());
                this.fadeList.put(pos, animation);
            }
        }
        this.fadeList.entrySet().removeIf(e -> ((Animation)e.getValue()).getFactor() == 0.0);
    }

    public boolean isPlacing() {
        return !this.placements.isEmpty();
    }

    public boolean isInPlacements(class_2338 pos) {
        return this.placements.contains(pos);
    }

    private float square(float value) {
        return value * value;
    }

    public static enum Timing {
        VANILLA,
        SEQUENTIAL;

    }
}

