/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.systems.screens;

import com.genyo.systems.settings.playerlist.ListGroupSetting;
import com.genyo.systems.settings.playerlist.ListPlayer;
import com.genyo.systems.settings.playerlist.PLGroup;
import com.genyo.utils.GenyoChatUtils;
import java.util.List;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.WindowScreen;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WHorizontalList;
import meteordevelopment.meteorclient.gui.widgets.containers.WTable;
import meteordevelopment.meteorclient.gui.widgets.input.WTextBox;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.gui.widgets.pressable.WMinus;
import meteordevelopment.meteorclient.gui.widgets.pressable.WPlus;
import meteordevelopment.meteorclient.renderer.Texture;
import meteordevelopment.meteorclient.utils.network.MeteorExecutor;
import meteordevelopment.meteorclient.utils.render.color.Color;
import net.minecraft.class_437;

public class ListGroupScreen
extends WindowScreen {
    protected final ListGroupSetting setting;
    private WTable table;
    protected final int index;
    private PLGroup currentGroup;
    protected final class_437 beforeScreen;

    public ListGroupScreen(GuiTheme theme, ListGroupSetting setting, int index, class_437 beforeScreen) {
        super(theme, "Edit " + ((PLGroup)((List)setting.get()).get(index)).getGroupName());
        this.index = index;
        this.setting = setting;
        this.currentGroup = (PLGroup)((List)setting.get()).get(index);
        this.beforeScreen = beforeScreen;
    }

    public void initWidgets() {
        this.table = (WTable)this.add((WWidget)this.theme.table()).expandX().minWidth(400.0).widget();
        this.table.add((WWidget)this.theme.label("Status"));
        this.table.add((WWidget)this.theme.label(this.currentGroup.isEnabled() ? "Enabled" : "Disabled").color(this.currentGroup.isEnabled() ? Color.GREEN : Color.RED));
        this.table.row();
        this.table.add((WWidget)this.theme.label("Name")).widget();
        WTextBox textBox = (WTextBox)this.table.add((WWidget)this.theme.textBox(this.currentGroup.getGroupName())).expandX().widget();
        textBox.action = () -> this.currentGroup.setGroupName(textBox.get());
        textBox.actionOnUnfocused = this::confirmChanges;
        this.table.row();
        this.table.add((WWidget)this.theme.label("Message")).widget();
        WTextBox messageTB = (WTextBox)this.table.add((WWidget)this.theme.textBox(this.currentGroup.getMessage())).expandX().widget();
        messageTB.action = () -> this.currentGroup.setMessage(messageTB.get());
        messageTB.actionOnUnfocused = this::confirmChanges;
        this.table.row();
        this.table.add((WWidget)this.theme.horizontalSeparator()).expandX();
        this.table.row();
        this.table.add((WWidget)this.theme.label("Players"));
        this.table.row();
        WHorizontalList list = (WHorizontalList)this.table.add((WWidget)this.theme.horizontalList()).expandX().widget();
        WTextBox nameW = (WTextBox)list.add((WWidget)this.theme.textBox("", (text, c) -> c != ' ')).expandX().widget();
        WPlus add = (WPlus)list.add((WWidget)this.theme.plus()).widget();
        add.action = () -> {
            String name = nameW.get().trim();
            if (name.equalsIgnoreCase("")) {
                return;
            }
            ListPlayer player = new ListPlayer(name);
            if (this.currentGroup.containsPlayer(player)) {
                nameW.set("");
                nameW.setFocused(true);
                GenyoChatUtils.sendError("Player '" + name + "' already exists in '" + this.currentGroup.getGroupName() + "'!");
                return;
            }
            nameW.set("");
            this.currentGroup.addPlayer(player);
            this.confirmChanges();
        };
        this.table.row();
        this.initTable(this.table);
        this.enterAction = add.action;
        this.table.row();
        this.table.add((WWidget)this.theme.horizontalSeparator()).expandX();
        this.table.row();
        WButton save = (WButton)this.table.add((WWidget)this.theme.button("Save")).expandX().widget();
        save.action = () -> {
            this.confirmChanges();
            MeteorClient.mc.method_1507(this.beforeScreen);
        };
    }

    private void initTable(WTable table) {
        if (((List)this.setting.get()).isEmpty()) {
            return;
        }
        this.currentGroup.getPlayers().forEach(player -> MeteorExecutor.execute(() -> {
            if (player == null) {
                this.currentGroup.removePlayer((ListPlayer)player);
                this.confirmChanges();
                return;
            }
            if (player.headTextureNeedsUpdate()) {
                player.updateInfo(false);
                this.reload();
            }
        }));
        for (ListPlayer player2 : this.currentGroup.getPlayers()) {
            if (player2 == null) {
                this.currentGroup.removePlayer(player2);
                this.confirmChanges();
                return;
            }
            table.add((WWidget)this.theme.texture(32.0, 32.0, player2.getHead().needsRotate() ? 90.0 : 0.0, (Texture)player2.getHead()));
            table.add((WWidget)this.theme.label(player2.getName()));
            WMinus remove = (WMinus)table.add((WWidget)this.theme.minus()).expandCellX().right().widget();
            remove.action = () -> {
                this.currentGroup.removePlayer(player2);
                this.confirmChanges();
                table.clear();
            };
            table.row();
        }
    }

    private void confirmChanges() {
        ((List)this.setting.get()).set(this.index, this.currentGroup);
        MeteorExecutor.execute(() -> ((ListGroupScreen)this).reload());
        this.setting.onChanged();
    }

    protected WWidget getValueWidget(ListPlayer value) {
        return this.theme.label(this.getValueName(value));
    }

    protected String getValueName(ListPlayer value) {
        return value.getName();
    }
}

