/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.systems.settings;

import java.util.function.Consumer;
import meteordevelopment.meteorclient.settings.IVisible;
import meteordevelopment.meteorclient.settings.Setting;
import net.minecraft.class_2487;

public class FloatSetting
extends Setting<Float> {
    public final float min;
    public final float max;
    public final float sliderMin;
    public final float sliderMax;
    public final boolean onSliderRelease;
    public final int decimalPlaces;
    public final boolean noSlider;

    private FloatSetting(String name, String description, float defaultValue, Consumer<Float> onChanged, Consumer<Setting<Float>> onModuleActivated, IVisible visible, float min, float max, float sliderMin, float sliderMax, boolean onSliderRelease, int decimalPlaces, boolean noSlider) {
        super(name, description, (Object)Float.valueOf(defaultValue), onChanged, onModuleActivated, visible);
        this.min = min;
        this.max = max;
        this.sliderMin = sliderMin;
        this.sliderMax = sliderMax;
        this.decimalPlaces = decimalPlaces;
        this.onSliderRelease = onSliderRelease;
        this.noSlider = noSlider;
    }

    protected Float parseImpl(String str) {
        try {
            return Float.valueOf(Float.parseFloat(str.trim()));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    protected boolean isValueValid(Float value) {
        return value.floatValue() >= this.min && value.floatValue() <= this.max;
    }

    protected class_2487 save(class_2487 tag) {
        tag.method_10548("value", ((Float)this.get()).floatValue());
        return tag;
    }

    public Float load(class_2487 tag) {
        this.set(Float.valueOf(tag.method_10583("value")));
        return (Float)this.get();
    }

    public static class Builder
    extends Setting.SettingBuilder<Builder, Float, FloatSetting> {
        public float min = Float.NEGATIVE_INFINITY;
        public float max = Float.POSITIVE_INFINITY;
        public float sliderMin = 0.0f;
        public float sliderMax = 10.0f;
        public boolean onSliderRelease = false;
        public int decimalPlaces = 3;
        public boolean noSlider = false;

        public Builder() {
            super((Object)Float.valueOf(0.0f));
        }

        public Builder defaultValue(float defaultValue) {
            this.defaultValue = Float.valueOf(defaultValue);
            return this;
        }

        public Builder min(float min) {
            this.min = min;
            return this;
        }

        public Builder max(float max) {
            this.max = max;
            return this;
        }

        public Builder range(float min, float max) {
            this.min = Math.min(min, max);
            this.max = Math.max(min, max);
            return this;
        }

        public Builder sliderMin(float min) {
            this.sliderMin = min;
            return this;
        }

        public Builder sliderMax(float max) {
            this.sliderMax = max;
            return this;
        }

        public Builder sliderRange(float min, float max) {
            this.sliderMin = min;
            this.sliderMax = max;
            return this;
        }

        public Builder onSliderRelease() {
            this.onSliderRelease = true;
            return this;
        }

        public Builder decimalPlaces(int decimalPlaces) {
            this.decimalPlaces = decimalPlaces;
            return this;
        }

        public Builder noSlider() {
            this.noSlider = true;
            return this;
        }

        public FloatSetting build() {
            return new FloatSetting(this.name, this.description, ((Float)this.defaultValue).floatValue(), this.onChanged, this.onModuleActivated, this.visible, this.min, this.max, Math.max(this.sliderMin, this.min), Math.min(this.sliderMax, this.max), this.onSliderRelease, this.decimalPlaces, this.noSlider);
        }
    }
}

