/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.systems.settings.playerlist;

import com.mojang.util.UndashedUuid;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import meteordevelopment.meteorclient.utils.misc.ISerializable;
import meteordevelopment.meteorclient.utils.network.Http;
import meteordevelopment.meteorclient.utils.render.PlayerHeadTexture;
import meteordevelopment.meteorclient.utils.render.PlayerHeadUtils;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class ListPlayer
implements ISerializable<ListPlayer>,
Comparable<ListPlayer> {
    private static final class_310 mc = class_310.method_1551();
    public volatile String name;
    @Nullable
    private volatile UUID id;
    @Nullable
    private volatile PlayerHeadTexture headTexture;
    private volatile boolean updating;

    public ListPlayer(String name, @Nullable UUID id) {
        this.name = name;
        this.id = id;
        this.headTexture = null;
    }

    public ListPlayer(class_1657 player) {
        this(player.method_5477().getString(), player.method_5667());
    }

    public ListPlayer(String name) {
        this(name, null);
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public PlayerHeadTexture getHead() {
        return this.headTexture != null ? this.headTexture : PlayerHeadUtils.STEVE_HEAD;
    }

    public void updateInfo(boolean updateName) {
        this.updating = true;
        APIResponse res = (APIResponse)Http.get((String)("https://api.mojang.com/users/profiles/minecraft/" + this.name)).sendJson(APIResponse.class);
        if (res == null || res.name == null || res.id == null) {
            return;
        }
        if (updateName) {
            this.name = res.name;
        }
        this.id = UndashedUuid.fromStringLenient((String)res.id);
        mc.execute(() -> {
            this.headTexture = PlayerHeadUtils.fetchHead((UUID)this.id);
        });
        this.updating = false;
    }

    public boolean headTextureNeedsUpdate() {
        return !this.updating && this.headTexture == null;
    }

    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10582("name", this.name);
        if (this.id != null) {
            tag.method_10582("id", UndashedUuid.toString((UUID)this.id));
        }
        return tag;
    }

    public ListPlayer fromTag(class_2487 tag) {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListPlayer player = (ListPlayer)o;
        return Objects.equals(this.name, player.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public int compareTo(@NotNull ListPlayer player) {
        return this.name.compareTo(player.name);
    }

    private static class APIResponse {
        String name;
        String id;

        private APIResponse() {
        }
    }
}

