/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.utils.player;

import com.genyo.managers.Managers;
import com.genyo.utils.GInvUtils;
import com.genyo.utils.player.SearchInvResult;
import com.genyo.utils.world.ExplosionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import meteordevelopment.meteorclient.MeteorClient;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2828;
import net.minecraft.class_2848;
import net.minecraft.class_2879;
import net.minecraft.class_2885;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;

public class InteractionUtil {
    private static final List<class_2248> SHIFT_BLOCKS = Arrays.asList(class_2246.field_10443, class_2246.field_10034, class_2246.field_10380, class_2246.field_9980, class_2246.field_10486, class_2246.field_40285, class_2246.field_10246, class_2246.field_42740, class_2246.field_10535, class_2246.field_10333, class_2246.field_10312, class_2246.field_10228, class_2246.field_10200, class_2246.field_10608, class_2246.field_10485, class_2246.field_10199, class_2246.field_10407, class_2246.field_10063, class_2246.field_10203, class_2246.field_10600, class_2246.field_10275, class_2246.field_10051, class_2246.field_10140, class_2246.field_10532, class_2246.field_10268, class_2246.field_10605, class_2246.field_10373, class_2246.field_10055, class_2246.field_10068, class_2246.field_10371);
    public static Map<class_2338, Long> awaiting = new HashMap<class_2338, Long>();

    public static class_243 getEyesPos(@NotNull class_1297 entity) {
        return entity.method_19538().method_1031(0.0, (double)entity.method_18381(entity.method_18376()), 0.0);
    }

    public static float @NotNull [] calculateAngle(class_243 to) {
        return InteractionUtil.calculateAngle(InteractionUtil.getEyesPos((class_1297)MeteorClient.mc.field_1724), to);
    }

    public static float squaredDistanceFromEyes(@NotNull class_243 vec) {
        double d0 = vec.field_1352 - MeteorClient.mc.field_1724.method_23317();
        double d1 = vec.field_1350 - MeteorClient.mc.field_1724.method_23321();
        double d2 = vec.field_1351 - (MeteorClient.mc.field_1724.method_23318() + (double)MeteorClient.mc.field_1724.method_18381(MeteorClient.mc.field_1724.method_18376()));
        return (float)(d0 * d0 + d1 * d1 + d2 * d2);
    }

    public static float @NotNull [] calculateAngle(@NotNull class_243 from, @NotNull class_243 to) {
        double difX = to.field_1352 - from.field_1352;
        double difY = (to.field_1351 - from.field_1351) * -1.0;
        double difZ = to.field_1350 - from.field_1350;
        double dist = class_3532.method_15355((float)((float)(difX * difX + difZ * difZ)));
        float yD = (float)class_3532.method_15338((double)(Math.toDegrees(Math.atan2(difZ, difX)) - 90.0));
        float pD = (float)class_3532.method_15350((double)class_3532.method_15338((double)Math.toDegrees(Math.atan2(difY, dist))), (double)-90.0, (double)90.0);
        return new float[]{yD, pD};
    }

    @Nullable
    public static class_3965 getPlaceResult(@NotNull class_2338 bp, Interact interact, boolean ignoreEntities) {
        if (!ignoreEntities) {
            for (class_1297 entity : new ArrayList(MeteorClient.mc.field_1687.method_18467(class_1297.class, new class_238(bp)))) {
                if (entity instanceof class_1542 || entity instanceof class_1303) continue;
                return null;
            }
        }
        if (!MeteorClient.mc.field_1687.method_8320(bp).method_45474()) {
            return null;
        }
        if (interact == Interact.AirPlace) {
            return ExplosionUtil.rayCastBlock(new class_3959(InteractionUtil.getEyesPos((class_1297)MeteorClient.mc.field_1724), bp.method_46558(), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)MeteorClient.mc.field_1724), bp);
        }
        ArrayList<BlockPosWithFacing> supports = InteractionUtil.getSupportBlocks(bp);
        for (BlockPosWithFacing support : supports) {
            if (interact != Interact.Vanilla) {
                @NotNull List<class_2350> dirs = InteractionUtil.getStrictDirections(bp);
                if (dirs.isEmpty()) {
                    return null;
                }
                if (!dirs.contains(support.facing)) continue;
            }
            class_3965 result = null;
            if (interact == Interact.Legit) {
                class_243 p = InteractionUtil.getVisibleDirectionPoint(support.facing, support.position, 0.0f, 6.0f);
                if (p != null) {
                    return new class_3965(p, support.facing, support.position, false);
                }
            } else {
                class_243 directionVec = new class_243((double)support.position.method_10263() + 0.5 + (double)support.facing.method_62675().method_10263() * 0.5, (double)support.position.method_10264() + 0.5 + (double)support.facing.method_62675().method_10264() * 0.5, (double)support.position.method_10260() + 0.5 + (double)support.facing.method_62675().method_10260() * 0.5);
                result = new class_3965(directionVec, support.facing, support.position, false);
            }
            return result;
        }
        return null;
    }

    @NotNull
    private static class_238 getDirectionBox(class_2350 dir) {
        return switch (dir) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11036 -> new class_238((double)0.15f, 1.0, (double)0.15f, (double)0.85f, 1.0, (double)0.85f);
            case class_2350.field_11033 -> new class_238((double)0.15f, 0.0, (double)0.15f, (double)0.85f, 0.0, (double)0.85f);
            case class_2350.field_11034 -> new class_238(1.0, (double)0.15f, (double)0.15f, 1.0, (double)0.85f, (double)0.85f);
            case class_2350.field_11039 -> new class_238(0.0, (double)0.15f, (double)0.15f, 0.0, (double)0.85f, (double)0.85f);
            case class_2350.field_11043 -> new class_238((double)0.15f, (double)0.15f, 0.0, (double)0.85f, (double)0.85f, 0.0);
            case class_2350.field_11035 -> new class_238((double)0.15f, (double)0.15f, 1.0, (double)0.85f, (double)0.85f, 1.0);
        };
    }

    @Nullable
    public static class_243 getVisibleDirectionPoint(@NotNull class_2350 dir, @NotNull class_2338 bp, float wallRange, float range) {
        double x;
        class_243 point;
        double z;
        class_238 brutBox = InteractionUtil.getDirectionBox(dir);
        if (brutBox.field_1320 - brutBox.field_1323 == 0.0) {
            for (double y = brutBox.field_1322; y < brutBox.field_1325; y += (double)0.1f) {
                for (z = brutBox.field_1321; z < brutBox.field_1324; z += (double)0.1f) {
                    point = new class_243((double)bp.method_10263() + brutBox.field_1323, (double)bp.method_10264() + y, (double)bp.method_10260() + z);
                    if (InteractionUtil.shouldSkipPoint(point, bp, dir, wallRange, range)) continue;
                    return point;
                }
            }
        }
        if (brutBox.field_1325 - brutBox.field_1322 == 0.0) {
            for (x = brutBox.field_1323; x < brutBox.field_1320; x += (double)0.1f) {
                for (z = brutBox.field_1321; z < brutBox.field_1324; z += (double)0.1f) {
                    point = new class_243((double)bp.method_10263() + x, (double)bp.method_10264() + brutBox.field_1322, (double)bp.method_10260() + z);
                    if (InteractionUtil.shouldSkipPoint(point, bp, dir, wallRange, range)) continue;
                    return point;
                }
            }
        }
        if (brutBox.field_1324 - brutBox.field_1321 == 0.0) {
            for (x = brutBox.field_1323; x < brutBox.field_1320; x += (double)0.1f) {
                for (double y = brutBox.field_1322; y < brutBox.field_1325; y += (double)0.1f) {
                    point = new class_243((double)bp.method_10263() + x, (double)bp.method_10264() + y, (double)bp.method_10260() + brutBox.field_1321);
                    if (InteractionUtil.shouldSkipPoint(point, bp, dir, wallRange, range)) continue;
                    return point;
                }
            }
        }
        return null;
    }

    private static boolean shouldSkipPoint(class_243 point, class_2338 bp, class_2350 dir, float wallRange, float range) {
        class_3959 context = new class_3959(InteractionUtil.getEyesPos((class_1297)MeteorClient.mc.field_1724), point, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)MeteorClient.mc.field_1724);
        class_3965 result = MeteorClient.mc.field_1687.method_17742(context);
        float dst = InteractionUtil.squaredDistanceFromEyes(point);
        if (result != null && result.method_17783() == class_239.class_240.field_1332 && !result.method_17777().equals((Object)bp) && dst > wallRange * wallRange) {
            return true;
        }
        return dst > range * range;
    }

    public static boolean isSolid(class_2338 bp) {
        return MeteorClient.mc.field_1687.method_8320(bp).method_51367() || awaiting.containsKey(bp);
    }

    @NotNull
    public static List<class_2350> getStrictDirections(@NotNull class_2338 bp) {
        ArrayList<class_2350> visibleSides = new ArrayList<class_2350>();
        class_243 positionVector = bp.method_46558();
        double westDelta = InteractionUtil.getEyesPos((class_1297)MeteorClient.mc.field_1724).field_1352 - positionVector.method_1031((double)0.5, (double)0.0, (double)0.0).field_1352;
        double eastDelta = InteractionUtil.getEyesPos((class_1297)MeteorClient.mc.field_1724).field_1352 - positionVector.method_1031((double)-0.5, (double)0.0, (double)0.0).field_1352;
        double northDelta = InteractionUtil.getEyesPos((class_1297)MeteorClient.mc.field_1724).field_1350 - positionVector.method_1031((double)0.0, (double)0.0, (double)0.5).field_1350;
        double southDelta = InteractionUtil.getEyesPos((class_1297)MeteorClient.mc.field_1724).field_1350 - positionVector.method_1031((double)0.0, (double)0.0, (double)-0.5).field_1350;
        double upDelta = InteractionUtil.getEyesPos((class_1297)MeteorClient.mc.field_1724).field_1351 - positionVector.method_1031((double)0.0, (double)0.5, (double)0.0).field_1351;
        double downDelta = InteractionUtil.getEyesPos((class_1297)MeteorClient.mc.field_1724).field_1351 - positionVector.method_1031((double)0.0, (double)-0.5, (double)0.0).field_1351;
        if (westDelta > 0.0 && InteractionUtil.isSolid(bp.method_10067())) {
            visibleSides.add(class_2350.field_11034);
        }
        if (westDelta < 0.0 && InteractionUtil.isSolid(bp.method_10078())) {
            visibleSides.add(class_2350.field_11039);
        }
        if (eastDelta < 0.0 && InteractionUtil.isSolid(bp.method_10078())) {
            visibleSides.add(class_2350.field_11039);
        }
        if (eastDelta > 0.0 && InteractionUtil.isSolid(bp.method_10067())) {
            visibleSides.add(class_2350.field_11034);
        }
        if (northDelta > 0.0 && InteractionUtil.isSolid(bp.method_10095())) {
            visibleSides.add(class_2350.field_11035);
        }
        if (northDelta < 0.0 && InteractionUtil.isSolid(bp.method_10072())) {
            visibleSides.add(class_2350.field_11043);
        }
        if (southDelta < 0.0 && InteractionUtil.isSolid(bp.method_10072())) {
            visibleSides.add(class_2350.field_11043);
        }
        if (southDelta > 0.0 && InteractionUtil.isSolid(bp.method_10095())) {
            visibleSides.add(class_2350.field_11035);
        }
        if (upDelta > 0.0 && InteractionUtil.isSolid(bp.method_10074())) {
            visibleSides.add(class_2350.field_11036);
        }
        if (upDelta < 0.0 && InteractionUtil.isSolid(bp.method_10084())) {
            visibleSides.add(class_2350.field_11033);
        }
        if (downDelta < 0.0 && InteractionUtil.isSolid(bp.method_10084())) {
            visibleSides.add(class_2350.field_11033);
        }
        if (downDelta > 0.0 && InteractionUtil.isSolid(bp.method_10074())) {
            visibleSides.add(class_2350.field_11036);
        }
        return visibleSides;
    }

    @NotNull
    public static ArrayList<BlockPosWithFacing> getSupportBlocks(@NotNull class_2338 bp) {
        ArrayList<BlockPosWithFacing> list = new ArrayList<BlockPosWithFacing>();
        if (MeteorClient.mc.field_1687.method_8320(bp.method_10069(0, -1, 0)).method_51367() || awaiting.containsKey(bp.method_10069(0, -1, 0))) {
            list.add(new BlockPosWithFacing(bp.method_10069(0, -1, 0), class_2350.field_11036));
        }
        if (MeteorClient.mc.field_1687.method_8320(bp.method_10069(0, 1, 0)).method_51367() || awaiting.containsKey(bp.method_10069(0, 1, 0))) {
            list.add(new BlockPosWithFacing(bp.method_10069(0, 1, 0), class_2350.field_11033));
        }
        if (MeteorClient.mc.field_1687.method_8320(bp.method_10069(-1, 0, 0)).method_51367() || awaiting.containsKey(bp.method_10069(-1, 0, 0))) {
            list.add(new BlockPosWithFacing(bp.method_10069(-1, 0, 0), class_2350.field_11034));
        }
        if (MeteorClient.mc.field_1687.method_8320(bp.method_10069(1, 0, 0)).method_51367() || awaiting.containsKey(bp.method_10069(1, 0, 0))) {
            list.add(new BlockPosWithFacing(bp.method_10069(1, 0, 0), class_2350.field_11039));
        }
        if (MeteorClient.mc.field_1687.method_8320(bp.method_10069(0, 0, 1)).method_51367() || awaiting.containsKey(bp.method_10069(0, 0, 1))) {
            list.add(new BlockPosWithFacing(bp.method_10069(0, 0, 1), class_2350.field_11043));
        }
        if (MeteorClient.mc.field_1687.method_8320(bp.method_10069(0, 0, -1)).method_51367() || awaiting.containsKey(bp.method_10069(0, 0, -1))) {
            list.add(new BlockPosWithFacing(bp.method_10069(0, 0, -1), class_2350.field_11035));
        }
        return list;
    }

    public static boolean canPlaceBlock(@NotNull class_2338 bp, Interact interact, boolean ignoreEntities) {
        if (awaiting.containsKey(bp)) {
            return false;
        }
        return InteractionUtil.getPlaceResult(bp, interact, ignoreEntities) != null;
    }

    public static boolean needSneak(class_2248 in) {
        return SHIFT_BLOCKS.contains(in);
    }

    public static boolean placeBlock(class_2338 bp, Rotate rotate, Interact interact, PlaceMode mode, int slot, boolean returnSlot, boolean ignoreEntities) {
        int prevItem = MeteorClient.mc.field_1724.method_31548().field_7545;
        if (slot == -1) {
            return false;
        }
        GInvUtils.switchTo(slot);
        boolean result = InteractionUtil.placeBlock(bp, rotate, interact, mode, ignoreEntities);
        if (returnSlot) {
            GInvUtils.switchTo(prevItem);
        }
        return result;
    }

    public static boolean placeBlock(class_2338 bp, Rotate rotate, Interact interact, PlaceMode mode, @NotNull SearchInvResult invResult, boolean returnSlot, boolean ignoreEntities) {
        int prevItem = MeteorClient.mc.field_1724.method_31548().field_7545;
        invResult.switchTo();
        boolean result = InteractionUtil.placeBlock(bp, rotate, interact, mode, ignoreEntities);
        if (returnSlot) {
            GInvUtils.switchTo(prevItem);
        }
        return result;
    }

    public static boolean placeBlock(class_2338 bp, Rotate rotate, Interact interact, PlaceMode mode, boolean ignoreEntities) {
        boolean sneak;
        class_3965 result = InteractionUtil.getPlaceResult(bp, interact, ignoreEntities);
        if (result == null || MeteorClient.mc.field_1687 == null || MeteorClient.mc.field_1761 == null || MeteorClient.mc.field_1724 == null) {
            return false;
        }
        boolean sprint = MeteorClient.mc.field_1724.method_5624();
        boolean bl = sneak = InteractionUtil.needSneak(MeteorClient.mc.field_1687.method_8320(result.method_17777()).method_26204()) && !MeteorClient.mc.field_1724.method_5715();
        if (sprint) {
            MeteorClient.mc.field_1724.field_3944.method_52787((class_2596)new class_2848((class_1297)MeteorClient.mc.field_1724, class_2848.class_2849.field_12985));
        }
        if (sneak) {
            MeteorClient.mc.field_1724.field_3944.method_52787((class_2596)new class_2848((class_1297)MeteorClient.mc.field_1724, class_2848.class_2849.field_12979));
        }
        float[] angle = InteractionUtil.calculateAngle(result.method_17784());
        switch (rotate.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                MeteorClient.mc.field_1724.field_3944.method_52787((class_2596)new class_2828.class_2831(angle[0], angle[1], MeteorClient.mc.field_1724.method_24828(), MeteorClient.mc.field_1724.field_5976));
                break;
            }
            case 2: {
                MeteorClient.mc.field_1724.field_3944.method_52787((class_2596)new class_2828.class_2830(MeteorClient.mc.field_1724.method_23317(), MeteorClient.mc.field_1724.method_23318(), MeteorClient.mc.field_1724.method_23321(), angle[0], angle[1], MeteorClient.mc.field_1724.method_24828(), MeteorClient.mc.field_1724.field_5976));
            }
        }
        if (mode == PlaceMode.Normal) {
            MeteorClient.mc.field_1761.method_2896(MeteorClient.mc.field_1724, class_1268.field_5808, result);
        }
        if (mode == PlaceMode.Packet) {
            Managers.NETWORK.sendSequencedPacket(id -> new class_2885(class_1268.field_5808, result, id));
        }
        awaiting.put(bp, System.currentTimeMillis());
        if (rotate == Rotate.Grim) {
            MeteorClient.mc.field_1724.field_3944.method_52787((class_2596)new class_2828.class_2830(MeteorClient.mc.field_1724.method_23317(), MeteorClient.mc.field_1724.method_23318(), MeteorClient.mc.field_1724.method_23321(), MeteorClient.mc.field_1724.method_36454(), MeteorClient.mc.field_1724.method_36455(), MeteorClient.mc.field_1724.method_24828(), MeteorClient.mc.field_1724.field_5976));
        }
        if (sneak) {
            MeteorClient.mc.field_1724.field_3944.method_52787((class_2596)new class_2848((class_1297)MeteorClient.mc.field_1724, class_2848.class_2849.field_12984));
        }
        if (sprint) {
            MeteorClient.mc.field_1724.field_3944.method_52787((class_2596)new class_2848((class_1297)MeteorClient.mc.field_1724, class_2848.class_2849.field_12981));
        }
        MeteorClient.mc.field_1724.field_3944.method_52787((class_2596)new class_2879(class_1268.field_5808));
        return true;
    }

    public static enum Interact {
        Vanilla,
        Strict,
        Legit,
        AirPlace;

    }

    public record BlockPosWithFacing(class_2338 position, class_2350 facing) {
    }

    public static enum Rotate {
        None,
        Default,
        Grim;

    }

    public static enum PlaceMode {
        Packet,
        Normal;

    }
}

