/*
 * Decompiled with CFR 0.152.
 */
package com.genyo.utils.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;

public class HoleUtility {
    public static int calcOffset(double dec) {
        return dec >= 0.7 ? 1 : (dec <= 0.3 ? -1 : 0);
    }

    @NotNull
    private static class_2338 getPos(@NotNull class_243 from) {
        return class_2338.method_49637((double)from.method_10216(), (double)(from.method_10214() - Math.floor(from.method_10214()) > 0.8 ? Math.floor(from.method_10214()) + 1.0 : Math.floor(from.method_10214())), (double)from.method_10215());
    }

    @NotNull
    public static List<class_2338> getHolePoses(@NotNull class_243 from) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        double decimalX = from.method_10216() - Math.floor(from.method_10216());
        double decimalZ = from.method_10215() - Math.floor(from.method_10215());
        int offX = HoleUtility.calcOffset(decimalX);
        int offZ = HoleUtility.calcOffset(decimalZ);
        positions.add(HoleUtility.getPos(from));
        for (int x = 0; x <= Math.abs(offX); ++x) {
            for (int z = 0; z <= Math.abs(offZ); ++z) {
                int properX = x * offX;
                int properZ = z * offZ;
                positions.add(Objects.requireNonNull(HoleUtility.getPos(from)).method_10069(properX, 0, properZ));
            }
        }
        return positions;
    }

    public static int calcLength(double decimal, boolean negative) {
        if (negative) {
            return decimal <= 0.3 ? 1 : 0;
        }
        return decimal >= 0.7 ? 1 : 0;
    }

    public static class_2338 addToPlayer(@NotNull class_2338 playerPos, double x, double y, double z) {
        if (playerPos.method_10263() < 0) {
            x = -x;
        }
        if (playerPos.method_10264() < 0) {
            y = -y;
        }
        if (playerPos.method_10260() < 0) {
            z = -z;
        }
        return playerPos.method_10081((class_2382)class_2338.method_49637((double)x, (double)y, (double)z));
    }

    @NotNull
    public static List<class_2338> getSurroundPoses(@NotNull class_243 from) {
        int z;
        int x;
        class_2338 fromPos = class_2338.method_49638((class_2374)from);
        ArrayList<class_2338> tempOffsets = new ArrayList<class_2338>();
        double decimalX = Math.abs(from.method_10216()) - Math.floor(Math.abs(from.method_10216()));
        double decimalZ = Math.abs(from.method_10215()) - Math.floor(Math.abs(from.method_10215()));
        int lengthXPos = HoleUtility.calcLength(decimalX, false);
        int lengthXNeg = HoleUtility.calcLength(decimalX, true);
        int lengthZPos = HoleUtility.calcLength(decimalZ, false);
        int lengthZNeg = HoleUtility.calcLength(decimalZ, true);
        for (x = 1; x < lengthXPos + 1; ++x) {
            tempOffsets.add(HoleUtility.addToPlayer(fromPos, x, 0.0, 1 + lengthZPos));
            tempOffsets.add(HoleUtility.addToPlayer(fromPos, x, 0.0, -(1 + lengthZNeg)));
        }
        for (x = 0; x <= lengthXNeg; ++x) {
            tempOffsets.add(HoleUtility.addToPlayer(fromPos, -x, 0.0, 1 + lengthZPos));
            tempOffsets.add(HoleUtility.addToPlayer(fromPos, -x, 0.0, -(1 + lengthZNeg)));
        }
        for (z = 1; z < lengthZPos + 1; ++z) {
            tempOffsets.add(HoleUtility.addToPlayer(fromPos, 1 + lengthXPos, 0.0, z));
            tempOffsets.add(HoleUtility.addToPlayer(fromPos, -(1 + lengthXNeg), 0.0, z));
        }
        for (z = 0; z <= lengthZNeg; ++z) {
            tempOffsets.add(HoleUtility.addToPlayer(fromPos, 1 + lengthXPos, 0.0, -z));
            tempOffsets.add(HoleUtility.addToPlayer(fromPos, -(1 + lengthXNeg), 0.0, -z));
        }
        return tempOffsets;
    }
}

