/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import meteordevelopment.meteorclient.commands.Command;
import meteordevelopment.meteorclient.commands.arguments.PlayerArgumentType;
import net.minecraft.class_1297;
import net.minecraft.class_2172;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7225;

public class DataCommand
extends Command {
    public DataCommand() {
        super("data", "Gets NBT data of entities or blocks.", new String[]{"target-nbt"});
    }

    public void build(LiteralArgumentBuilder<class_2172> builder) {
        builder.executes(context -> this.getDataOrStates(false));
        this.buildCommand(builder, "get", false);
        this.buildCommand(builder, "copy", true);
    }

    private void buildCommand(LiteralArgumentBuilder<class_2172> builder, String commandName, boolean copy) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)DataCommand.literal((String)commandName).executes(context -> this.getDataOrStates(copy))).then(((LiteralArgumentBuilder)DataCommand.literal((String)"player").executes(context -> this.getEntityData((class_1297)DataCommand.mc.field_1724, copy))).then(DataCommand.argument((String)"player", (ArgumentType)PlayerArgumentType.create()).executes(context -> this.getEntityData((class_1297)PlayerArgumentType.get((CommandContext)context), copy))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)DataCommand.literal((String)"target").executes(context -> this.getDataOrStates(copy))).then(DataCommand.literal((String)"data").executes(context -> this.getFullData(copy)))).then(DataCommand.literal((String)"states").executes(context -> this.getFullStates(copy)))));
    }

    public int getEntityData(class_1297 entity, boolean copy) {
        class_2487 nbt = entity.method_5647(new class_2487());
        if (copy) {
            DataCommand.mc.field_1774.method_1455(nbt.method_10714());
            this.info("Entity data was copied to your clipboard", new Object[0]);
        } else {
            this.info((class_2561)class_2561.method_43470((String)"Entity data: ").method_10852(class_2512.method_32270((class_2520)nbt)));
        }
        return 1;
    }

    public int getDataOrStates(boolean copy) {
        if (this.getData(copy) != WarningType.NO_WARNING && this.getStates(copy) != WarningType.NO_WARNING) {
            this.warningMessage(WarningType.NO_TARGET);
        }
        return 1;
    }

    public int getFullData(boolean copy) {
        this.warningMessage(this.getData(copy));
        return 1;
    }

    public int getFullStates(boolean copy) {
        this.warningMessage(this.getStates(copy));
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WarningType getData(boolean copy) {
        if (DataCommand.mc.field_1765.method_17783() == class_239.class_240.field_1331) {
            this.getEntityData(((class_3966)DataCommand.mc.field_1765).method_17782(), copy);
            return WarningType.NO_WARNING;
        } else {
            if (DataCommand.mc.field_1765.method_17783() != class_239.class_240.field_1332) return WarningType.NO_TARGET;
            class_2338 blockPos = ((class_3965)DataCommand.mc.field_1765).method_17777();
            class_2586 blockEntity = DataCommand.mc.field_1687.method_8321(blockPos);
            if (blockEntity == null) return WarningType.NOT_A_BLOCK_ENTITY;
            class_2487 nbt = blockEntity.method_38242((class_7225.class_7874)DataCommand.mc.field_1687.method_30349());
            if (copy) {
                DataCommand.mc.field_1774.method_1455(nbt.method_10714());
                this.info("Block data was copied to your clipboard", new Object[0]);
                return WarningType.NO_WARNING;
            } else {
                this.info((class_2561)class_2561.method_43470((String)"Block data: ").method_10852(class_2512.method_32270((class_2520)nbt)));
            }
        }
        return WarningType.NO_WARNING;
    }

    public WarningType getStates(boolean copy) {
        if (DataCommand.mc.field_1765.method_17783() == class_239.class_240.field_1332) {
            class_2338 blockPos = ((class_3965)DataCommand.mc.field_1765).method_17777();
            class_2680 blockState = DataCommand.mc.field_1687.method_8320(blockPos);
            class_2487 nbt = class_2512.method_10686((class_2680)blockState);
            if (copy) {
                DataCommand.mc.field_1774.method_1455(nbt.method_10714());
                this.info("Block states were copied to your clipboard", new Object[0]);
            } else {
                this.info((class_2561)class_2561.method_43470((String)"Block states: ").method_10852(class_2512.method_32270((class_2520)nbt)));
            }
        } else {
            if (DataCommand.mc.field_1765.method_17783() == class_239.class_240.field_1331) {
                return WarningType.NOT_A_BLOCK;
            }
            return WarningType.NO_TARGET;
        }
        return WarningType.NO_WARNING;
    }

    private void warningMessage(WarningType warning) {
        switch (warning.ordinal()) {
            case 1: {
                this.warning("Target block is not a block entity", new Object[0]);
                break;
            }
            case 2: {
                this.warning("Target is not a block", new Object[0]);
                break;
            }
            case 3: {
                this.warning("There is no target for your cursor", new Object[0]);
                break;
            }
        }
    }

    public static enum WarningType {
        NO_WARNING,
        NOT_A_BLOCK_ENTITY,
        NOT_A_BLOCK,
        NO_TARGET;

    }
}

