/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.commands.Command;
import meteordevelopment.meteorclient.events.game.GameJoinedEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2172;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import zgoly.meteorist.commands.arguments.InstructionArgumentType;
import zgoly.meteorist.modules.instructions.InstructionFactory;
import zgoly.meteorist.modules.instructions.Instructions;
import zgoly.meteorist.modules.instructions.instructions.BaseInstruction;
import zgoly.meteorist.utils.InstructionUtils;
import zgoly.meteorist.utils.MeteoristUtils;

public class InstructionsCommand
extends Command {
    public Instructions instructionsModule = (Instructions)Modules.get().get(Instructions.class);
    public Map<Integer, List<String>> map = new HashMap<Integer, List<String>>();

    public InstructionsCommand() {
        super("instructions", "Runs saved instructions from the \"Instructions\" module.", new String[0]);
        MeteorClient.EVENT_BUS.subscribe((Object)this);
    }

    public void build(LiteralArgumentBuilder<class_2172> builder) {
        builder.then(InstructionsCommand.literal((String)"run").then(((RequiredArgumentBuilder)InstructionsCommand.argument((String)"instruction", (ArgumentType)InstructionArgumentType.instruction()).then(InstructionsCommand.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            String instructionName = (String)context.getArgument("instruction", String.class);
            File instructionFile = InstructionArgumentType.instruction().getInstructionFile(instructionName);
            int count = IntegerArgumentType.getInteger((CommandContext)context, (String)"count");
            return this.handleInstruction(instructionFile, count);
        }))).executes(context -> {
            String instructionName = (String)context.getArgument("instruction", String.class);
            File instructionFile = InstructionArgumentType.instruction().getInstructionFile(instructionName);
            return this.handleInstruction(instructionFile, 1);
        })));
        builder.then(InstructionsCommand.literal((String)"debug").executes(context -> {
            boolean value = (Boolean)this.instructionsModule.printDebugInfo.get();
            this.instructionsModule.printDebugInfo.set((Object)(!value ? 1 : 0));
            this.info("Debug Info was (highlight)%s", new Object[]{value ? "disabled" : "enabled"});
            return 1;
        }));
        builder.then(InstructionsCommand.literal((String)"stop").executes(context -> {
            if (!this.map.isEmpty()) {
                this.info("Stopping (highlight)%d(default) instructions", new Object[]{this.map.size()});
                this.map.clear();
            } else {
                this.error("Nothing to stop", new Object[0]);
            }
            return 1;
        }));
    }

    public int handleInstruction(File file, int runs) {
        InstructionFactory factory = new InstructionFactory();
        try {
            int worldTime;
            List<BaseInstruction> instructions;
            try (FileInputStream inputStream = new FileInputStream(file);){
                class_2487 tag = class_2507.method_10629((InputStream)inputStream, (class_2505)class_2505.method_53898());
                instructions = InstructionUtils.readInstructionsFromTag(tag, factory);
            }
            int tick = worldTime = (int)InstructionsCommand.mc.field_1687.method_8510() + 1;
            for (int r = 0; r < runs; ++r) {
                int lastTick = InstructionUtils.processInstructions(instructions, this.map, tick);
                if (((Boolean)this.instructionsModule.printDebugInfo.get()).booleanValue()) {
                    this.info("Iteration (highlight)%d(default) will run from (highlight)%d(default) to (highlight)%d(default) ticks", new Object[]{r + 1, tick, lastTick});
                }
                tick = lastTick;
            }
            Object runsMessage = runs > 1 ? " for (highlight)" + runs + "(default) runs" : "";
            this.info("Loaded (highlight)%d(default) instructions from (highlight)%s(default)%s", new Object[]{instructions.size(), file.getName(), runsMessage});
            int totalTicks = tick - worldTime;
            this.info("Total ticks to run: (highlight)%d(default) (approximately %s)", new Object[]{totalTicks, MeteoristUtils.ticksToTime(totalTicks)});
        }
        catch (Exception e) {
            this.error("Error loading instructions: (highlight)%d(default)", new Object[]{e.getMessage()});
        }
        return 1;
    }

    @EventHandler
    public void onTick(TickEvent.Post event) {
        if (InstructionsCommand.mc.field_1687 == null) {
            return;
        }
        int worldTime = (int)InstructionsCommand.mc.field_1687.method_8510();
        if (((Boolean)this.instructionsModule.printDebugInfo.get()).booleanValue() && !this.map.isEmpty()) {
            this.info("Running (highlight)%d(default) instructions", new Object[]{this.map.size()});
        }
        this.map.entrySet().removeIf(entry -> (Integer)entry.getKey() < worldTime);
        InstructionUtils.executeCommands(this.map, worldTime);
    }

    @EventHandler
    private void onGameJoined(GameJoinedEvent event) {
        this.map.clear();
    }
}

