/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import meteordevelopment.meteorclient.commands.Command;
import net.minecraft.class_2172;
import net.minecraft.class_640;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import zgoly.meteorist.commands.arguments.PlayerPropertiesArgumentType;

public class PlayersInfoCommand
extends Command {
    public PlayersInfoCommand() {
        super("playersinfo", "Saves in file / copies to clipboard info about players on current server.", new String[0]);
    }

    public void build(LiteralArgumentBuilder<class_2172> builder) {
        builder.then(((LiteralArgumentBuilder)PlayersInfoCommand.literal((String)"copy").executes(this::copyPlayersInfo)).then(PlayersInfoCommand.argument((String)"properties", (ArgumentType)PlayerPropertiesArgumentType.create()).executes(this::copyPlayersInfo)));
        builder.then(((LiteralArgumentBuilder)PlayersInfoCommand.literal((String)"save").executes(this::savePlayersInfo)).then(PlayersInfoCommand.argument((String)"properties", (ArgumentType)PlayerPropertiesArgumentType.create()).executes(this::savePlayersInfo)));
    }

    private int savePlayersInfo(CommandContext<class_2172> context) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer filterBuffer = stack.mallocPointer(1);
            filterBuffer.put(stack.UTF8((CharSequence)"*.csv"));
            filterBuffer.flip();
            String result = TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)"Save Players Info", (CharSequence)"players_info.csv", (PointerBuffer)filterBuffer, (CharSequence)"CSV File (*.csv)");
            if (result != null) {
                try {
                    FileOutputStream outputStream = new FileOutputStream(result);
                    outputStream.write(this.getPlayersInfo(context).getBytes());
                    outputStream.close();
                    this.info("Players info was saved to (highlight)%s(default)", new Object[]{result});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return 1;
    }

    private int copyPlayersInfo(CommandContext<class_2172> context) {
        PlayersInfoCommand.mc.field_1774.method_1455(this.getPlayersInfo(context));
        this.info("Players info was copied to clipboard", new Object[0]);
        return 1;
    }

    private String getPlayersInfo(CommandContext<class_2172> context) {
        List<String> properties;
        try {
            properties = PlayerPropertiesArgumentType.get(context);
        }
        catch (Exception e) {
            properties = PlayerPropertiesArgumentType.PROPERTIES;
        }
        StringBuilder info = new StringBuilder();
        info.append(String.join((CharSequence)",", properties.isEmpty() ? PlayerPropertiesArgumentType.PROPERTIES : properties)).append("\n");
        if (mc.method_1562() != null) {
            List sortedPlayerList = mc.method_1562().method_2880().stream().sorted((p1, p2) -> p1.method_2966().getName().compareToIgnoreCase(p2.method_2966().getName())).toList();
            for (class_640 player : sortedPlayerList) {
                info.append(String.join((CharSequence)",", this.getProperties(player, properties))).append("\n");
            }
        }
        return info.toString();
    }

    private List<String> getProperties(class_640 player, List<String> properties) {
        ArrayList<String> finalString = new ArrayList<String>();
        for (String property : properties) {
            switch (property.toLowerCase()) {
                case "player": {
                    finalString.add(player.method_2966().getName());
                    break;
                }
                case "uuid": {
                    finalString.add(String.valueOf(player.method_2966().getId()));
                    break;
                }
                case "gamemode": {
                    finalString.add(String.valueOf(player.method_2958()));
                    break;
                }
                case "skin_url": {
                    finalString.add(player.method_52810().comp_1911());
                    break;
                }
                case "latency": {
                    finalString.add(String.valueOf(player.method_2959()));
                }
            }
        }
        return finalString;
    }
}

