/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2561;
import zgoly.meteorist.modules.instructions.Instructions;
import zgoly.meteorist.utils.config.MeteoristConfigManager;

public class InstructionArgumentType
implements ArgumentType<String> {
    private static final DynamicCommandExceptionType UNKNOWN_INSTRUCTION_EXCEPTION = new DynamicCommandExceptionType(name -> class_2561.method_30163((String)("Instruction \"" + String.valueOf(name) + "\" is not found")));

    public static InstructionArgumentType instruction() {
        return new InstructionArgumentType();
    }

    private List<String> listInstructionNames() {
        ArrayList<String> instructionNames = new ArrayList<String>();
        File folderPath = MeteoristConfigManager.getFolderPath(new Instructions());
        File[] files = folderPath.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                String name = file.getName();
                instructionNames.add(name.substring(0, name.lastIndexOf(".")));
            }
        }
        return instructionNames;
    }

    private File findInstructionFileByName(String name) {
        File folderPath = MeteoristConfigManager.getFolderPath(new Instructions());
        File[] files = folderPath.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().startsWith(name)) continue;
                return file;
            }
        }
        return null;
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        String result = reader.readQuotedString();
        if (this.findInstructionFileByName(result) == null) {
            throw UNKNOWN_INSTRUCTION_EXCEPTION.create((Object)result);
        }
        return result;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        for (String key : this.listInstructionNames()) {
            builder.suggest("\"" + key + "\"");
        }
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        return this.listInstructionNames();
    }

    public File getInstructionFile(String name) throws CommandSyntaxException {
        File file = this.findInstructionFileByName(name);
        if (file == null) {
            throw UNKNOWN_INSTRUCTION_EXCEPTION.create((Object)name);
        }
        return file;
    }
}

