/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.modules;

import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1799;
import zgoly.meteorist.Meteorist;

public class AutoFix
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<String> fixCommand;
    private final Setting<Mode> mode;
    private final Setting<Integer> minDurability;
    private final Setting<Integer> minDurabilityPercentage;
    private final Setting<Integer> delay;
    private int timer;

    public AutoFix() {
        super(Meteorist.CATEGORY, "auto-fix", "Writes command in chat when item close to break.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.fixCommand = this.sgGeneral.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("fix-command")).description("Command to fix item.")).defaultValue((Object)"/fix all")).build());
        this.mode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("mode")).description("Percentage - calculate item durability in percentage, Default - calculate item durability in numbers.")).defaultValue((Object)Mode.Default)).build());
        this.minDurability = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("min-durability")).description("The durability number to send the command.")).defaultValue((Object)10)).min(1).sliderRange(1, 1000).visible(() -> this.mode.get() == Mode.Default)).build());
        this.minDurabilityPercentage = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("min-durability")).description("The durability percentage to send the command.")).defaultValue((Object)10)).min(1).sliderRange(1, 100).visible(() -> this.mode.get() == Mode.Percentage)).build());
        this.delay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("delay")).description("Delay after sending a command in ticks (20 ticks = 1 sec).")).defaultValue((Object)20)).min(1).sliderRange(1, 40).build());
    }

    public void onActivate() {
        this.timer = 0;
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        boolean work = false;
        if (this.timer >= (Integer)this.delay.get()) {
            for (class_1799 item : this.mc.field_1724.method_5661()) {
                if (item.method_7919() <= 0 || item.method_7936() <= 0 || (this.mode.get() != Mode.Default || item.method_7936() - item.method_7919() < (Integer)this.minDurability.get()) && (this.mode.get() != Mode.Percentage || (item.method_7936() - item.method_7919()) * 100 / item.method_7936() < (Integer)this.minDurabilityPercentage.get())) continue;
                work = true;
            }
            if (work) {
                ChatUtils.sendPlayerMsg((String)((String)this.fixCommand.get()));
                this.timer = 0;
            }
        } else {
            ++this.timer;
        }
    }

    public static enum Mode {
        Default,
        Percentage;

    }
}

