/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.modules;

import java.util.Objects;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.world.BlockUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_2244;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2588;
import net.minecraft.class_2596;
import net.minecraft.class_2848;
import net.minecraft.class_3965;
import net.minecraft.class_7417;
import net.minecraft.class_7439;
import zgoly.meteorist.Meteorist;

public class AutoSleep
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Integer> bedSearchRadius;
    private final Setting<SleepMode> sleepMode;
    private final Setting<Integer> sleepDelay;
    private final Setting<Boolean> atNight;
    private final Setting<Boolean> atThunderstorm;
    private final Setting<Boolean> useMaxSleepTime;
    private final Setting<Integer> maxSleepTime;
    private final Setting<Boolean> dimensionRestrict;
    private int sleepDelayTimer;
    private int sleepTimer;

    public AutoSleep() {
        super(Meteorist.CATEGORY, "auto-sleep", "Gets into bed automatically for you.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.bedSearchRadius = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("bed-search-radius")).description("Radius to search for beds.")).defaultValue((Object)3)).min(1).sliderRange(1, 4).build());
        this.sleepMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("sleep-mode")).description("'Default' - sleep every amount of ticks; 'WhenPlayerLiesOnBed' - sleep when other player lies down on bed.")).defaultValue((Object)SleepMode.Default)).build());
        this.sleepDelay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("sleep-delay")).description("Delay between tries to sleep in ticks (20 ticks = 1 sec).")).defaultValue((Object)200)).min(1).sliderRange(1, 1200).visible(() -> this.sleepMode.get() == SleepMode.Default)).build());
        this.atNight = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("at-night")).description("Sleep only at night.")).defaultValue((Object)true)).visible(() -> this.sleepMode.get() == SleepMode.Default)).build());
        this.atThunderstorm = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("at-thunderstorm")).description("Sleep only at thunderstorm.")).defaultValue((Object)true)).visible(() -> this.sleepMode.get() == SleepMode.Default)).build());
        this.useMaxSleepTime = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("use-max-sleep-time")).description("Use maximum sleep time.")).defaultValue((Object)true)).build());
        this.maxSleepTime = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("max-sleep-time")).description("Maximum time to sleep in ticks (20 ticks = 1 sec).")).defaultValue((Object)200)).min(1).sliderRange(1, 1200).visible(() -> this.useMaxSleepTime.get())).build());
        this.dimensionRestrict = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("dimension-restrict")).description("Don't go to bed if you're in a dimension like nether/end.")).defaultValue((Object)true)).build());
    }

    public void onActivate() {
        this.sleepDelayTimer = (Integer)this.sleepDelay.get();
        this.sleepTimer = 0;
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (this.mc.field_1687 == null) {
            return;
        }
        if (((Boolean)this.dimensionRestrict.get()).booleanValue() && !this.mc.field_1687.method_8597().comp_645()) {
            return;
        }
        if (this.mc.field_1724.method_6113()) {
            if (((Boolean)this.useMaxSleepTime.get()).booleanValue()) {
                ++this.sleepTimer;
                if (this.sleepTimer >= (Integer)this.maxSleepTime.get()) {
                    this.sleepTimer = 0;
                    this.mc.method_1562().method_52787((class_2596)new class_2848((class_1297)this.mc.field_1724, class_2848.class_2849.field_12986));
                }
            }
        } else if (this.sleepMode.get() == SleepMode.Default) {
            ++this.sleepDelayTimer;
            if (this.sleepDelayTimer < (Integer)this.sleepDelay.get()) {
                return;
            }
            this.sleepDelayTimer = (Integer)this.sleepDelay.get();
            if ((Boolean)this.atNight.get() != false && (Boolean)this.atThunderstorm.get() != false ? this.isDay() && !this.mc.field_1687.method_8546() : ((Boolean)this.atNight.get() != false ? this.isDay() : (Boolean)this.atThunderstorm.get() != false && !this.mc.field_1687.method_8546())) {
                return;
            }
            if (this.sleepInNearestBed((Integer)this.bedSearchRadius.get())) {
                this.sleepDelayTimer = 0;
            }
        }
    }

    private boolean isDay() {
        if (this.mc.field_1687 == null) {
            return true;
        }
        float time = this.mc.field_1687.method_8532() % 24000L;
        return this.mc.field_1687.method_8419() ? !(time > 12010.0f) || !(time < 23991.0f) : !(time > 12542.0f) || !(time < 23459.0f);
    }

    private boolean sleepInNearestBed(int radius) {
        for (class_2338 blockPos : class_2338.method_25996((class_2338)this.mc.field_1724.method_24515(), (int)radius, (int)radius, (int)radius)) {
            if (!(this.mc.field_1687.method_8320(blockPos).method_26204() instanceof class_2244)) continue;
            this.sleepTimer = 0;
            BlockUtils.interact((class_3965)new class_3965(class_243.method_24953((class_2382)blockPos), class_2350.field_11036, blockPos, true), (class_1268)class_1268.field_5808, (boolean)false);
            return true;
        }
        return false;
    }

    @EventHandler
    public void onReceiveMessage(PacketEvent.Receive event) {
        class_2588 translatableText;
        class_7439 packet;
        class_7417 class_74172;
        class_2596 class_25962;
        if (this.sleepMode.get() == SleepMode.WhenPlayerLiesOnBed && (class_25962 = event.packet) instanceof class_7439 && (class_74172 = (packet = (class_7439)class_25962).comp_763().method_10851()) instanceof class_2588 && Objects.equals((translatableText = (class_2588)class_74172).method_11022(), "sleep.players_sleeping")) {
            this.sleepInNearestBed((Integer)this.bedSearchRadius.get());
        }
    }

    public static enum SleepMode {
        Default,
        WhenPlayerLiesOnBed;

    }
}

