/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.modules;

import java.util.List;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BlockListSetting;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import zgoly.meteorist.Meteorist;

public class AutoSneak
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgFilter;
    private final SettingGroup sgRender;
    private final Setting<Double> width;
    private final Setting<Double> height;
    private final Setting<Double> playerPosPrediction;
    private final Setting<SneakBlocksMode> sneakBlocksMode;
    private final Setting<List<class_2248>> sneakBlocksWhitelist;
    private final Setting<List<class_2248>> sneakBlocksBlacklist;
    private final Setting<IgnoreBlocksMode> ignoreBlocksMode;
    private final Setting<List<class_2248>> ignoreBlocksWhitelist;
    private final Setting<List<class_2248>> ignoreBlocksBlacklist;
    private final Setting<Boolean> showBox;
    private final Setting<SettingColor> sideColorOff;
    private final Setting<SettingColor> lineColorOff;
    private final Setting<SettingColor> sideColorOn;
    private final Setting<SettingColor> lineColorOn;
    boolean sneaking;

    public AutoSneak() {
        super(Meteorist.CATEGORY, "auto-sneak", "Automatically sneaks at block edge (idea by kokqi).");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgFilter = this.settings.createGroup("Filter");
        this.sgRender = this.settings.createGroup("Render");
        this.width = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("width")).description("Width of the box.")).defaultValue(0.25).range(0.05, 1.0).sliderRange(0.05, 1.0).build());
        this.height = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("height")).description("Height of the box.")).defaultValue(0.6).range(0.05, 1.0).sliderRange(0.05, 1.0).build());
        this.playerPosPrediction = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("player-pos-prediction")).description("Predict player position based on velocity to move box to it.")).defaultValue(1.0).sliderRange(0.0, 5.0).build());
        this.sneakBlocksMode = this.sgFilter.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("sneak-blocks-mode")).description("Sneak blocks mode.")).defaultValue((Object)SneakBlocksMode.Whitelist)).build());
        this.sneakBlocksWhitelist = this.sgFilter.add((Setting)((BlockListSetting.Builder)((BlockListSetting.Builder)((BlockListSetting.Builder)new BlockListSetting.Builder().name("sneak-blocks-whitelist")).description("Sneak on blocks from list, but not others.")).visible(() -> this.sneakBlocksMode.get() == SneakBlocksMode.Whitelist)).build());
        this.sneakBlocksBlacklist = this.sgFilter.add((Setting)((BlockListSetting.Builder)((BlockListSetting.Builder)((BlockListSetting.Builder)new BlockListSetting.Builder().name("sneak-blocks-blacklist")).description("Sneak on other blocks, but not from list.")).visible(() -> this.sneakBlocksMode.get() == SneakBlocksMode.Blacklist)).build());
        this.ignoreBlocksMode = this.sgFilter.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("ignore-blocks-mode")).description("Ignore blocks mode.")).defaultValue((Object)IgnoreBlocksMode.Whitelist)).build());
        this.ignoreBlocksWhitelist = this.sgFilter.add((Setting)((BlockListSetting.Builder)((BlockListSetting.Builder)((BlockListSetting.Builder)new BlockListSetting.Builder().name("ignore-blocks-whitelist")).description("Ignore blocks from list, but not others.")).visible(() -> this.ignoreBlocksMode.get() == IgnoreBlocksMode.Whitelist)).build());
        this.ignoreBlocksBlacklist = this.sgFilter.add((Setting)((BlockListSetting.Builder)((BlockListSetting.Builder)((BlockListSetting.Builder)new BlockListSetting.Builder().name("ignore-blocks-blacklist")).description("Ignore other blocks, but not from list.")).visible(() -> this.ignoreBlocksMode.get() == IgnoreBlocksMode.Blacklist)).build());
        this.showBox = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("show-box")).description("Show box.")).defaultValue((Object)true)).build());
        this.sideColorOff = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("side-color-off")).description("The color of the sides of box when not sneaking.")).defaultValue(new SettingColor(255, 0, 0, 40)).visible(() -> this.showBox.get())).build());
        this.lineColorOff = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("line-color-off")).description("The color of the lines of box when not sneaking.")).defaultValue(new SettingColor(255, 0, 0, 100)).visible(() -> this.showBox.get())).build());
        this.sideColorOn = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("side-color-on")).description("The color of the sides of box when sneaking.")).defaultValue(new SettingColor(0, 255, 0, 40)).visible(() -> this.showBox.get())).build());
        this.lineColorOn = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("line-color-on")).description("The color of the lines of box when sneaking.")).defaultValue(new SettingColor(0, 255, 0, 100)).visible(() -> this.showBox.get())).build());
        this.sneaking = false;
    }

    private class_238 calcBox() {
        class_243 pos = this.mc.field_1724.method_19538().method_1019(this.mc.field_1724.method_18798().method_1021(((Double)this.playerPosPrediction.get()).doubleValue()));
        pos = new class_243(pos.field_1352, this.mc.field_1724.method_19538().field_1351, pos.field_1350);
        return new class_238(pos.method_10216() + (Double)this.width.get() / 2.0, pos.method_10214(), pos.method_10215() + (Double)this.width.get() / 2.0, pos.method_10216() - (Double)this.width.get() / 2.0, pos.method_10214() - (Double)this.height.get(), pos.method_10215() - (Double)this.width.get() / 2.0);
    }

    public void onDeactivate() {
        this.sneaking = false;
        if (this.mc.field_1724 != null) {
            this.mc.field_1724.method_5660(false);
        }
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if ((this.mc.field_1724.method_31549().field_7479 || this.mc.field_1724.field_6017 > 0.0f) && this.sneaking) {
            this.mc.field_1690.field_1832.method_23481(false);
            this.sneaking = false;
        }
        if (this.mc.field_1724.method_24828()) {
            boolean shouldIgnore;
            boolean shouldSneak;
            class_238 box = this.calcBox();
            Iterable iterable = this.mc.field_1687.method_20812((class_1297)this.mc.field_1724, box);
            if (iterable.iterator().hasNext()) {
                iterable.forEach(blockBox -> {
                    class_2338 blockPos = class_2338.method_49637((double)blockBox.method_1091(class_2350.class_2351.field_11048), (double)blockBox.method_1091(class_2350.class_2351.field_11052), (double)blockBox.method_1091(class_2350.class_2351.field_11051));
                    if (this.mc.field_1687.method_8320(blockPos) == this.mc.field_1724.method_25936()) {
                        if (this.sneaking) {
                            this.mc.field_1690.field_1832.method_23481(false);
                            this.sneaking = false;
                        }
                    } else if (this.mc.field_1687.method_8320(blockPos).method_45474()) {
                        this.mc.field_1690.field_1832.method_23481(true);
                        this.sneaking = true;
                    }
                });
            } else {
                this.mc.field_1690.field_1832.method_23481(true);
                this.sneaking = true;
            }
            class_2248 steppingBlock = this.mc.field_1724.method_25936().method_26204();
            boolean bl = this.sneakBlocksMode.get() == SneakBlocksMode.Whitelist ? ((List)this.sneakBlocksWhitelist.get()).contains(steppingBlock) : (shouldSneak = !((List)this.sneakBlocksBlacklist.get()).contains(steppingBlock));
            boolean bl2 = this.ignoreBlocksMode.get() == IgnoreBlocksMode.Whitelist ? ((List)this.ignoreBlocksWhitelist.get()).contains(steppingBlock) : (shouldIgnore = !((List)this.ignoreBlocksBlacklist.get()).contains(steppingBlock));
            if (shouldSneak) {
                this.mc.field_1690.field_1832.method_23481(true);
                this.sneaking = true;
            }
            if (shouldIgnore) {
                this.mc.field_1690.field_1832.method_23481(false);
                this.sneaking = false;
            }
        }
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        if (((Boolean)this.showBox.get()).booleanValue()) {
            if (this.mc.field_1724 == null) {
                return;
            }
            event.renderer.box(this.calcBox(), this.sneaking ? (Color)this.sideColorOn.get() : (Color)this.sideColorOff.get(), this.sneaking ? (Color)this.lineColorOn.get() : (Color)this.lineColorOff.get(), ShapeMode.Both, 0);
        }
    }

    public static enum SneakBlocksMode {
        Whitelist,
        Blacklist;

    }

    public static enum IgnoreBlocksMode {
        Whitelist,
        Blacklist;

    }
}

