/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.Vector3dSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2553;
import net.minecraft.class_304;
import net.minecraft.class_3532;
import org.joml.Vector3d;
import zgoly.meteorist.Meteorist;

public class BoatControl
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgRender;
    private final Setting<Boolean> autoForward;
    private final Setting<Boolean> stopWhenTurning;
    private final Setting<Boolean> smartTurning;
    private final Setting<Boolean> turnToYaw;
    private final Setting<Double> yaw;
    private final Setting<Boolean> autoYaw;
    private final Setting<Double> accuracy;
    private final Setting<Vector3d> leftCollisionSize;
    private final Setting<Vector3d> leftCollisionOffset;
    private final Setting<Vector3d> rightCollisionSize;
    private final Setting<Vector3d> rightCollisionOffset;
    private final Setting<State> leftCollisionAction;
    private final Setting<State> rightCollisionAction;
    private final Setting<State> bothCollisionAction;
    private final Setting<Boolean> renderSideColor1;
    private final Setting<SettingColor> sideColor1;
    private final Setting<SettingColor> lineColor1;
    private final Setting<Boolean> renderSideColor2;
    private final Setting<SettingColor> sideColor2;
    private final Setting<SettingColor> lineColor2;
    private final List<class_304> toRelease;
    private State currentState;
    private boolean wasInBoat;

    public BoatControl() {
        super(Meteorist.CATEGORY, "boat-control", "Automatically controls the boat for you.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgRender = this.settings.createGroup("Render");
        this.autoForward = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("auto-forward")).description("Automatically moves forward when you get into the boat.")).defaultValue((Object)true)).build());
        this.stopWhenTurning = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("stop-when-turning")).description("Do not move forward when turning.")).defaultValue((Object)false)).visible(() -> this.autoForward.get())).build());
        this.smartTurning = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("smart-turning")).description("Automatically turns the boat.")).defaultValue((Object)true)).build());
        this.turnToYaw = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("turn-to-yaw")).description("Always try (if possible) to turn the boat back to the yaw axis. Not effective but may be useful in some cases.")).defaultValue((Object)false)).visible(() -> this.smartTurning.get())).build());
        this.yaw = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("yaw")).description("The yaw to turn to.")).defaultValue(0.0).min(-180.0).max(180.0).visible(() -> (Boolean)this.smartTurning.get() != false && (Boolean)this.turnToYaw.get() != false)).build());
        this.autoYaw = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("auto-yaw")).description("Automatically capture boat's yaw upon boarding.")).defaultValue((Object)false)).visible(() -> (Boolean)this.smartTurning.get() != false && (Boolean)this.turnToYaw.get() != false)).build());
        this.accuracy = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("accuracy")).description("Accuracy of turning to yaw. The higher the value, the lower the accuracy.")).defaultValue(10.0).min(0.0).visible(() -> (Boolean)this.smartTurning.get() != false && (Boolean)this.turnToYaw.get() != false)).build());
        this.leftCollisionSize = this.sgGeneral.add((Setting)((Vector3dSetting.Builder)((Vector3dSetting.Builder)((Vector3dSetting.Builder)new Vector3dSetting.Builder().name("left-collision-size")).description("The size of the left collision.")).defaultValue(new Vector3d(1.0, 1.0, 1.0)).visible(() -> this.smartTurning.get())).build());
        this.leftCollisionOffset = this.sgGeneral.add((Setting)((Vector3dSetting.Builder)((Vector3dSetting.Builder)((Vector3dSetting.Builder)new Vector3dSetting.Builder().name("left-collision-offset")).description("The offset of the left collision.")).defaultValue(new Vector3d(1.0, 0.0, -1.0)).visible(() -> this.smartTurning.get())).build());
        this.rightCollisionSize = this.sgGeneral.add((Setting)((Vector3dSetting.Builder)((Vector3dSetting.Builder)((Vector3dSetting.Builder)new Vector3dSetting.Builder().name("right-collision-size")).description("The size of the right collision.")).defaultValue(new Vector3d(1.0, 1.0, 1.0)).visible(() -> this.smartTurning.get())).build());
        this.rightCollisionOffset = this.sgGeneral.add((Setting)((Vector3dSetting.Builder)((Vector3dSetting.Builder)((Vector3dSetting.Builder)new Vector3dSetting.Builder().name("right-collision-offset")).description("The offset of the right collision.")).defaultValue(new Vector3d(1.0, 0.0, 1.0)).visible(() -> this.smartTurning.get())).build());
        this.leftCollisionAction = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("left-collision-action")).description("The action to do when left collision is detected.")).defaultValue((Object)State.TURNING_RIGHT)).build());
        this.rightCollisionAction = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("right-collision-action")).description("The action to do when right collision is detected.")).defaultValue((Object)State.TURNING_LEFT)).build());
        this.bothCollisionAction = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("both-collision-action")).description("The action to do when both left and right collisions are detected.")).defaultValue((Object)State.TURNING_LEFT)).build());
        this.renderSideColor1 = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("render-left-collision")).description("Renders the left collision.")).defaultValue((Object)true)).build());
        this.sideColor1 = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("left-collision-side-color")).description("The color of the sides of the collision being rendered.")).defaultValue(new SettingColor(0, 0, 255, 40)).visible(() -> this.renderSideColor1.get())).build());
        this.lineColor1 = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("left-collision-line-color")).description("The color of the lines of the collision being rendered.")).defaultValue(new SettingColor(0, 0, 255, 100)).visible(() -> this.renderSideColor1.get())).build());
        this.renderSideColor2 = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("render-right-collision")).description("Renders the right collision.")).defaultValue((Object)true)).build());
        this.sideColor2 = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("right-collision-side-color")).description("The color of the sides of the collision being rendered.")).defaultValue(new SettingColor(255, 0, 0, 40)).visible(() -> this.renderSideColor2.get())).build());
        this.lineColor2 = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("right-collision-line-color")).description("The color of the lines of the collision being rendered.")).defaultValue(new SettingColor(255, 0, 0, 100)).visible(() -> this.renderSideColor2.get())).build());
        this.toRelease = new ArrayList<class_304>();
        this.currentState = State.NOTHING;
        this.wasInBoat = false;
    }

    public String getInfoString() {
        return this.currentState.toString();
    }

    public void onDeactivate() {
        this.wasInBoat = false;
        this.toRelease.clear();
        this.mc.field_1690.field_1894.method_23481(false);
        this.mc.field_1690.field_1913.method_23481(false);
        this.mc.field_1690.field_1849.method_23481(false);
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        this.currentState = State.NOTHING;
        class_1690 boat = (class_1690)this.mc.field_1724.method_5854();
        if (boat == null || !boat.method_52535() || boat.method_5642() != this.mc.field_1724) {
            this.wasInBoat = false;
            return;
        }
        if (!this.wasInBoat && ((Boolean)this.turnToYaw.get()).booleanValue() && ((Boolean)this.autoYaw.get()).booleanValue()) {
            this.yaw.set((Object)class_3532.method_15393((float)boat.method_36454()));
            this.wasInBoat = true;
        }
        if (((Boolean)this.autoForward.get()).booleanValue()) {
            this.currentState = State.MOVING_FORWARD;
            this.hold(this.mc.field_1690.field_1894);
        }
        if (!((Boolean)this.smartTurning.get()).booleanValue()) {
            return;
        }
        Map<State, class_304> stateToKeyBinding = Map.of(State.TURNING_LEFT, this.mc.field_1690.field_1913, State.TURNING_RIGHT, this.mc.field_1690.field_1849);
        State leftAction = (State)((Object)this.leftCollisionAction.get());
        State rightAction = (State)((Object)this.rightCollisionAction.get());
        List<class_2338> leftList = this.getBlockPos(this.getBox(boat, (Vector3d)this.leftCollisionOffset.get(), (Vector3d)this.leftCollisionSize.get()));
        List<class_2338> rightList = this.getBlockPos(this.getBox(boat, (Vector3d)this.rightCollisionOffset.get(), (Vector3d)this.rightCollisionSize.get()));
        if (!leftList.isEmpty()) {
            this.currentState = leftAction;
            this.hold(stateToKeyBinding.get((Object)leftAction));
        } else if (!rightList.isEmpty()) {
            this.currentState = rightAction;
            this.hold(stateToKeyBinding.get((Object)rightAction));
        }
        if (!leftList.isEmpty() && !rightList.isEmpty()) {
            this.currentState = (State)((Object)this.bothCollisionAction.get());
        }
        double yawDifference = class_3532.method_15338((double)((Double)this.yaw.get() - (double)boat.method_36454()));
        if ((this.currentState == State.MOVING_FORWARD || this.currentState == State.NOTHING) && ((Boolean)this.turnToYaw.get()).booleanValue() && Math.abs(yawDifference) > (Double)this.accuracy.get()) {
            this.currentState = yawDifference < 0.0 ? State.TURNING_LEFT : State.TURNING_RIGHT;
            this.hold(stateToKeyBinding.get((Object)this.currentState));
        }
        if ((this.currentState == State.TURNING_LEFT || this.currentState == State.TURNING_RIGHT) && ((Boolean)this.autoForward.get()).booleanValue() && ((Boolean)this.stopWhenTurning.get()).booleanValue()) {
            this.mc.field_1690.field_1894.method_23481(false);
        }
    }

    private void hold(class_304 keyBinding) {
        this.toRelease.add(keyBinding);
        keyBinding.method_23481(true);
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (!this.toRelease.isEmpty()) {
            this.toRelease.forEach(keyBinding -> keyBinding.method_23481(false));
            this.toRelease.clear();
        }
    }

    private class_243 vectorToVec(Vector3d vector3d) {
        return new class_243(vector3d.x, vector3d.y, vector3d.z);
    }

    private class_238 getBox(class_1690 boat, Vector3d collisionOffset, Vector3d collisionSize) {
        class_243 offsetPos = boat.method_19538().method_1019(this.vectorToVec(collisionOffset).method_1024((float)(-Math.toRadians(boat.method_36454() + 90.0f))));
        class_243 size = this.vectorToVec(collisionSize);
        return class_238.method_30048((class_243)offsetPos, (double)size.field_1352, (double)size.field_1351, (double)size.field_1350);
    }

    private List<class_2338> getBlockPos(class_238 box) {
        return class_2338.method_29715((class_238)box).map(class_2338::new).filter(blockPos -> !this.mc.field_1687.method_8320(blockPos).method_26220((class_1922)this.mc.field_1687, blockPos).method_1110()).filter(blockPos -> !(this.mc.field_1687.method_8320(blockPos).method_26204() instanceof class_2553)).toList();
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        class_1690 boat;
        class_1297 class_12972 = this.mc.field_1724.method_5854();
        if (class_12972 instanceof class_1690 && (boat = (class_1690)class_12972).method_52535() && boat.method_5642() == this.mc.field_1724) {
            if (((Boolean)this.renderSideColor1.get()).booleanValue()) {
                event.renderer.box(this.getBox(boat, (Vector3d)this.leftCollisionOffset.get(), (Vector3d)this.leftCollisionSize.get()), (Color)this.sideColor1.get(), (Color)this.lineColor1.get(), ShapeMode.Both, 0);
            }
            if (((Boolean)this.renderSideColor2.get()).booleanValue()) {
                event.renderer.box(this.getBox(boat, (Vector3d)this.rightCollisionOffset.get(), (Vector3d)this.rightCollisionSize.get()), (Color)this.sideColor2.get(), (Color)this.lineColor2.get(), ShapeMode.Both, 0);
            }
        }
    }

    private static enum State {
        NOTHING,
        MOVING_FORWARD,
        TURNING_LEFT,
        TURNING_RIGHT;

    }
}

