/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.modules;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import meteordevelopment.meteorclient.events.game.GameLeftEvent;
import meteordevelopment.meteorclient.events.game.OpenScreenEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringListSetting;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_419;
import org.apache.commons.lang3.RandomStringUtils;
import zgoly.meteorist.Meteorist;

public class DmSpam
extends Module {
    private final SettingGroup sgCommand;
    private final SettingGroup sgSelection;
    private final SettingGroup sgDelay;
    private final SettingGroup sgDisableSettings;
    private final SettingGroup sgSpecialCases;
    private final SettingGroup sgDebug;
    private final Setting<String> messageCommand;
    private final Setting<List<String>> spamMessages;
    private final Setting<Mode> messageMode;
    private final Setting<Mode> playerMode;
    private final Setting<Integer> delayBetweenMessages;
    private final Setting<Integer> delayBetweenPlayers;
    private final Setting<DisableTrigger> disableTrigger;
    private final Setting<Boolean> disableOnExit;
    private final Setting<Boolean> disableOnDisconnect;
    private final Setting<Boolean> excludeSelf;
    private final Setting<Boolean> antiSpamBypass;
    private final Setting<Integer> bypassTextLength;
    private final Setting<Boolean> printDebugInfo;
    private final List<UUID> usedPlayerUUIDs;
    private final List<Integer> usedMessageIds;
    private long currentTick;

    public DmSpam() {
        super(Meteorist.CATEGORY, "dm-spam", "Spams messages in players direct messages.");
        this.sgCommand = this.settings.createGroup("Command");
        this.sgSelection = this.settings.createGroup("Selection");
        this.sgDelay = this.settings.createGroup("Delay");
        this.sgDisableSettings = this.settings.createGroup("Disable Settings");
        this.sgSpecialCases = this.settings.createGroup("Special Cases");
        this.sgDebug = this.settings.createGroup("Debug");
        this.messageCommand = this.sgCommand.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("message-command")).description("Specified command to direct message a player.")).defaultValue((Object)"/msg {player} {message}")).build());
        this.spamMessages = this.sgSelection.add((Setting)((StringListSetting.Builder)((StringListSetting.Builder)((StringListSetting.Builder)new StringListSetting.Builder().name("spam-messages")).description("List of messages that can be sent to the players.")).defaultValue(List.of("Meteorist :handshake: Meteor"))).build());
        this.messageMode = this.sgSelection.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("message-mode")).description("'Sequential' - send messages in the order they appear in the list; 'Random' - pick a random message from the list.")).defaultValue((Object)Mode.Sequential)).build());
        this.playerMode = this.sgSelection.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("player-mode")).description("'Sequential' - select players in the order they appear; 'Random' - pick a random player.")).defaultValue((Object)Mode.Sequential)).build());
        this.delayBetweenMessages = this.sgDelay.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("delay-between-messages")).description("Time delay in ticks between the sending of individual messages.")).defaultValue((Object)20)).min(1).sliderMax(1200).build());
        this.delayBetweenPlayers = this.sgDelay.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("delay-between-players")).description("Time delay in ticks after all messages have been sent to all players.")).defaultValue((Object)100)).min(1).sliderMax(1200).build());
        this.disableTrigger = this.sgDisableSettings.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("disable-trigger")).description("'None' - never; 'NoMoreMessages' - no more messages to send; 'NoMorePlayers' - no more players to send messages to.")).defaultValue((Object)DisableTrigger.None)).build());
        this.disableOnExit = this.sgDisableSettings.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("disable-on-exit")).description("Stops the spam message flow when you leave a server.")).defaultValue((Object)true)).build());
        this.disableOnDisconnect = this.sgDisableSettings.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("disable-on-disconnect")).description("Stops the spam message flow if you are disconnected from the server (eg. kicked).")).defaultValue((Object)true)).build());
        this.excludeSelf = this.sgSpecialCases.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("exclude-self")).description("If set to 'true', the system will not send messages to yourself.")).defaultValue((Object)true)).build());
        this.antiSpamBypass = this.sgSpecialCases.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("anti-spam-bypass")).description("Adds random text at the end of each message to avoid spam detection.")).defaultValue((Object)false)).build());
        this.bypassTextLength = this.sgSpecialCases.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("bypass-text-length")).description("Defines the number of characters used to bypass spam detection.")).visible(() -> this.antiSpamBypass.get())).defaultValue((Object)16)).sliderRange(1, 256).build());
        this.printDebugInfo = this.sgDebug.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("print-debug-info")).description("Logs debug information in the chat.")).defaultValue((Object)false)).build());
        this.usedPlayerUUIDs = new ArrayList<UUID>();
        this.usedMessageIds = new ArrayList<Integer>();
    }

    @EventHandler
    private void onScreenOpen(OpenScreenEvent event) {
        if (((Boolean)this.disableOnDisconnect.get()).booleanValue() && event.screen instanceof class_419) {
            this.toggle();
        }
    }

    @EventHandler
    private void onGameLeft(GameLeftEvent event) {
        if (((Boolean)this.disableOnExit.get()).booleanValue()) {
            this.toggle();
        }
    }

    public void onActivate() {
        this.currentTick = this.mc.field_1687.method_8510();
    }

    @EventHandler
    public void onDeactivate() {
        this.usedPlayerUUIDs.clear();
        this.usedMessageIds.clear();
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        ArrayList allPlayerUUIDs = new ArrayList(this.mc.method_1562().method_31363());
        if (allPlayerUUIDs.isEmpty() || ((String)this.messageCommand.get()).isEmpty()) {
            return;
        }
        ArrayList unusedPlayerUUIDs = new ArrayList(allPlayerUUIDs);
        unusedPlayerUUIDs.removeAll(this.usedPlayerUUIDs);
        if (((Boolean)this.excludeSelf.get()).booleanValue()) {
            unusedPlayerUUIDs.remove(this.mc.field_1724.method_5667());
        }
        long currentWorldTime = this.mc.field_1687.method_8510();
        if (!unusedPlayerUUIDs.isEmpty() && this.currentTick <= currentWorldTime) {
            UUID selectedPlayerUUID = this.playerMode.get() == Mode.Sequential ? (UUID)unusedPlayerUUIDs.getFirst() : (UUID)unusedPlayerUUIDs.get(new Random().nextInt(unusedPlayerUUIDs.size()));
            List allMessageIds = IntStream.rangeClosed(0, ((List)this.spamMessages.get()).size() - 1).boxed().collect(Collectors.toCollection(LinkedList::new));
            allMessageIds.removeAll(this.usedMessageIds);
            if (allMessageIds.isEmpty()) {
                if (this.disableTrigger.get() == DisableTrigger.NoMoreMessages) {
                    this.toggle();
                    return;
                }
                this.usedMessageIds.clear();
                allMessageIds = IntStream.rangeClosed(0, ((List)this.spamMessages.get()).size() - 1).boxed().collect(Collectors.toCollection(LinkedList::new));
            }
            String playerName = this.mc.method_1562().method_2880().stream().filter(player -> player.method_2966().getId().equals(selectedPlayerUUID)).map(player -> player.method_2966().getName()).findFirst().orElse("");
            int selectedMessageId = this.messageMode.get() == Mode.Sequential ? (Integer)allMessageIds.getFirst() : (Integer)allMessageIds.get(new Random().nextInt(allMessageIds.size()));
            Object selectedMessage = (String)((List)this.spamMessages.get()).get(selectedMessageId);
            if (((Boolean)this.antiSpamBypass.get()).booleanValue()) {
                selectedMessage = (String)selectedMessage + " " + RandomStringUtils.randomAlphabetic((int)((Integer)this.bypassTextLength.get())).toLowerCase();
            }
            ChatUtils.sendPlayerMsg((String)((String)this.messageCommand.get()).replace("{player}", playerName).replace("{message}", (CharSequence)selectedMessage));
            if (((Boolean)this.printDebugInfo.get()).booleanValue()) {
                this.info("Sent '" + (String)selectedMessage + "' to '" + playerName + "'. Handling a delay of " + String.valueOf(this.delayBetweenMessages.get()) + " ticks.", new Object[0]);
            }
            this.usedMessageIds.add(selectedMessageId);
            this.usedPlayerUUIDs.add(selectedPlayerUUID);
            this.currentTick = currentWorldTime + (long)((Integer)this.delayBetweenMessages.get()).intValue();
        } else if (unusedPlayerUUIDs.isEmpty() && this.disableTrigger.get() == DisableTrigger.NoMorePlayers) {
            this.toggle();
        } else if (this.currentTick <= currentWorldTime) {
            this.currentTick = currentWorldTime + (long)((Integer)this.delayBetweenPlayers.get()).intValue();
            if (((Boolean)this.printDebugInfo.get()).booleanValue()) {
                this.info("The players ended, handling a delay of " + String.valueOf(this.delayBetweenPlayers.get()) + " ticks.", new Object[0]);
            }
            this.usedPlayerUUIDs.clear();
        }
    }

    public static enum Mode {
        Sequential,
        Random;

    }

    public static enum DisableTrigger {
        None,
        NoMoreMessages,
        NoMorePlayers;

    }
}

