/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.modules;

import java.util.ArrayList;
import java.util.List;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BlockListSetting;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.FindItemResult;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.meteorclient.utils.world.BlockUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2902;
import zgoly.meteorist.Meteorist;

public class Grid
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgRange;
    private final SettingGroup sgGrid;
    private final SettingGroup sgRender;
    private final Setting<FilterMode> filterMode;
    private final Setting<List<class_2248>> blocks;
    private final Setting<Boolean> place;
    private final Setting<Boolean> rotate;
    private final Setting<Boolean> dynamicHeight;
    private final Setting<Integer> gridSize;
    private final Setting<Integer> gridGap;
    private final Setting<Integer> switchRange;
    private final Setting<Integer> placeRange;
    private final Setting<Boolean> show;
    private final Setting<SettingColor> sideColor1;
    private final Setting<SettingColor> lineColor1;
    private final Setting<SettingColor> sideColor2;
    private final Setting<SettingColor> lineColor2;
    class_2338 centerPos;
    List<class_2338> placements;

    public Grid() {
        super(Meteorist.CATEGORY, "grid", "Allows you to place blocks on a grid.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgRange = this.settings.createGroup("Range");
        this.sgGrid = this.settings.createGroup("Grid");
        this.sgRender = this.settings.createGroup("Render");
        this.filterMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("filter-mode")).description("Filter placements based on mode.")).defaultValue((Object)FilterMode.StaggeredOdd)).build());
        this.blocks = this.sgGeneral.add((Setting)((BlockListSetting.Builder)((BlockListSetting.Builder)new BlockListSetting.Builder().name("blocks")).description("Blocks to use for placements.")).defaultValue(new class_2248[]{class_2246.field_10336, class_2246.field_10099}).build());
        this.place = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("place")).description("Place blocks.")).defaultValue((Object)true)).build());
        this.rotate = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("rotate")).description("Rotate head when placing a block.")).defaultValue((Object)true)).visible(() -> this.place.get())).build());
        this.dynamicHeight = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("dynamic-height")).description("Attaches placements to the surface.")).defaultValue((Object)true)).build());
        this.gridSize = this.sgGrid.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("grid-size")).description("Grid size.")).defaultValue((Object)2)).min(1).build());
        this.gridGap = this.sgGrid.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("grid-gap")).description("Gap between placements.")).defaultValue((Object)13)).min(1).build());
        this.switchRange = this.sgRange.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("switch-range")).description("Range to switch to the nearest placement of grid.")).defaultValue((Object)3)).min(1).build());
        this.placeRange = this.sgRange.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("place-range")).description("Range to place blocks.")).defaultValue((Object)3)).min(1).build());
        this.show = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("show")).description("Show placements.")).defaultValue((Object)true)).build());
        this.sideColor1 = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("main-placement-side-color")).description("The color of the sides of the blocks being rendered.")).defaultValue(new SettingColor(0, 255, 0, 40)).build());
        this.lineColor1 = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("main-placement-line-color")).description("The color of the lines of the blocks being rendered.")).defaultValue(new SettingColor(0, 255, 0, 100)).build());
        this.sideColor2 = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("placement-side-color")).description("The color of the sides of the blocks being rendered.")).defaultValue(new SettingColor(255, 255, 0, 40)).build());
        this.lineColor2 = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("placement-line-color")).description("The color of the lines of the blocks being rendered.")).defaultValue(new SettingColor(255, 255, 0, 100)).build());
        this.centerPos = null;
        this.placements = new ArrayList<class_2338>();
    }

    public void onDeactivate() {
        this.centerPos = null;
        this.placements.clear();
    }

    private class_2338 findNearest() {
        Iterable blockPosIterable = class_2338.method_25996((class_2338)this.mc.field_1724.method_24515(), (int)((Integer)this.switchRange.get()), (int)((Integer)this.switchRange.get()), (int)((Integer)this.switchRange.get()));
        for (class_2338 blockPos : blockPosIterable) {
            if (!((List)this.blocks.get()).contains(this.mc.field_1687.method_8320(blockPos).method_26204())) continue;
            return blockPos;
        }
        return null;
    }

    private class_2338 getHeight(class_2338 blockPos) {
        while (!this.mc.field_1687.method_8320(blockPos).method_45474() && blockPos.method_10264() < this.mc.field_1687.method_8624(class_2902.class_2903.field_13202, blockPos.method_10263(), blockPos.method_10260())) {
            blockPos = blockPos.method_10086(1);
        }
        while (this.mc.field_1687.method_8320(blockPos.method_10087(1)).method_45474() && blockPos.method_10264() > this.mc.field_1687.method_31607()) {
            blockPos = blockPos.method_10087(1);
        }
        return blockPos;
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        class_2338 nearPos = this.findNearest();
        if (nearPos != null) {
            this.centerPos = nearPos;
        }
        if (this.centerPos == null) {
            return;
        }
        this.placements.clear();
        for (int x = -((Integer)this.gridSize.get()).intValue(); x <= (Integer)this.gridSize.get(); ++x) {
            for (int z = -((Integer)this.gridSize.get()).intValue(); z <= (Integer)this.gridSize.get(); ++z) {
                if (x == 0 && z == 0 || this.filterMode.get() == FilterMode.StaggeredEven && (x & 1) == (z & 1) || this.filterMode.get() == FilterMode.StaggeredOdd && (x & 1) != (z & 1)) continue;
                class_2338 finalBlockPos = this.centerPos.method_10069(x * (Integer)this.gridGap.get(), 0, z * (Integer)this.gridGap.get());
                if (((Boolean)this.dynamicHeight.get()).booleanValue()) {
                    finalBlockPos = this.getHeight(finalBlockPos);
                }
                this.placements.add(finalBlockPos);
            }
        }
        for (class_2338 finalBlockPos : this.placements) {
            if (!((Boolean)this.place.get()).booleanValue() || !this.mc.field_1687.method_8320(finalBlockPos).method_45474() || !finalBlockPos.method_19771((class_2382)this.mc.field_1724.method_24515(), (double)((Integer)this.placeRange.get()).intValue())) continue;
            for (class_2248 block : (List)this.blocks.get()) {
                FindItemResult item = InvUtils.findInHotbar((class_1792[])new class_1792[]{block.method_8389()});
                BlockUtils.place((class_2338)finalBlockPos, (FindItemResult)item, (boolean)((Boolean)this.rotate.get()), (int)0);
            }
        }
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        if (this.centerPos != null && ((Boolean)this.show.get()).booleanValue()) {
            event.renderer.box(this.centerPos, (Color)this.sideColor1.get(), (Color)this.lineColor1.get(), ShapeMode.Both, 0);
            for (class_2338 placement : this.placements) {
                event.renderer.box(placement, (Color)this.sideColor2.get(), (Color)this.lineColor2.get(), ShapeMode.Both, 0);
            }
        }
    }

    public static enum FilterMode {
        None,
        StaggeredEven,
        StaggeredOdd;

    }
}

