/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.StreamSupport;
import meteordevelopment.meteorclient.events.entity.player.PlayerMoveEvent;
import meteordevelopment.meteorclient.events.game.GameJoinedEvent;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.mixininterface.IVec3d;
import meteordevelopment.meteorclient.pathing.BaritoneUtils;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.ItemListSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.entity.SortPriority;
import meteordevelopment.meteorclient.utils.entity.TargetUtils;
import meteordevelopment.meteorclient.utils.player.PlayerUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.meteorclient.utils.render.prompts.OkPrompt;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_265;
import net.minecraft.class_2775;
import zgoly.meteorist.Meteorist;
import zgoly.meteorist.utils.baritone.MeteoristBaritoneUtils;

public class ItemSucker
extends Module {
    private final SettingGroup sgFilter;
    private final SettingGroup sgGeneral;
    private final SettingGroup sgRender;
    private final Setting<Boolean> onlyPickupable;
    private final Setting<OperationMode> itemFilteringMode;
    private final Setting<List<class_1792>> itemWhitelist;
    private final Setting<List<class_1792>> itemBlacklist;
    private final Setting<Double> suckingRange;
    private final Setting<Boolean> onlyOnGround;
    private final Setting<MoveMode> moveMode;
    private final Setting<Boolean> checkCollisions;
    private final Setting<Integer> itemRange;
    private final Setting<Boolean> tpToOrigin;
    private final Setting<Integer> waitTime;
    private final Setting<Boolean> resetTimeAfterTp;
    private final Setting<Boolean> returnToOrigin;
    private final Setting<Integer> returnRange;
    private final Setting<Boolean> modifySpeed;
    private final Setting<Double> moveSpeed;
    private final Setting<Boolean> disableOnItemCount;
    private final Setting<ItemCountMode> itemCountMode;
    private final Setting<Integer> maxItemCount;
    private final Setting<Integer> maxItemsAtOnce;
    private final Setting<Boolean> showTeleportBox;
    private final Setting<SettingColor> sideColor;
    private final Setting<SettingColor> lineColor;
    int timer;
    class_243 startPos;
    int pickedUpStacksCount;
    int pickedUpItemsCount;
    MeteoristBaritoneUtils baritoneUtils;

    public ItemSucker() {
        super(Meteorist.CATEGORY, "item-sucker", "Automatically picks up dropped items.");
        this.sgFilter = this.settings.createGroup("Filter");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgRender = this.settings.createGroup("Render");
        this.onlyPickupable = this.sgFilter.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("only-pickupable")).description("Only pickup items that can be picked up.")).defaultValue((Object)true)).build());
        this.itemFilteringMode = this.sgFilter.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("item-filtering-mode")).description("Defines how items will be filtered when using the item sucker.")).defaultValue((Object)OperationMode.Blacklist)).build());
        this.itemWhitelist = this.sgFilter.add((Setting)((ItemListSetting.Builder)((ItemListSetting.Builder)((ItemListSetting.Builder)new ItemListSetting.Builder().name("item-whitelist")).description("Items to be exclusively picked up by the item sucker.")).defaultValue(new class_1792[]{class_1802.field_8477}).visible(() -> this.itemFilteringMode.get() == OperationMode.Whitelist)).build());
        this.itemBlacklist = this.sgFilter.add((Setting)((ItemListSetting.Builder)((ItemListSetting.Builder)((ItemListSetting.Builder)new ItemListSetting.Builder().name("item-blacklist")).description("Items which the item sucker should ignore.")).defaultValue(new class_1792[]{class_1802.field_8635}).visible(() -> this.itemFilteringMode.get() == OperationMode.Blacklist)).build());
        this.suckingRange = this.sgFilter.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("sucking-range")).description("Range within which the Baritone can pick up items.")).defaultValue(5.0).min(1.0).sliderRange(1.0, 25.0).build());
        this.onlyOnGround = this.sgFilter.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("only-on-ground")).description("Only pick up items that are on the floor.")).defaultValue((Object)true)).build());
        this.moveMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("move-mode")).description("Set the move mode of the item sucker.")).defaultValue((Object)MoveMode.Teleport)).build());
        this.checkCollisions = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("check-collisions")).description("Check if player can teleport to an item and not collide with blocks.")).defaultValue((Object)true)).visible(() -> this.moveMode.get() == MoveMode.Teleport)).build());
        this.itemRange = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("item-range")).description("The radius within which Baritone will attempt to pick up items (relative to the item's position).")).defaultValue((Object)0)).min(0).visible(() -> this.moveMode.get() == MoveMode.Baritone)).build());
        this.tpToOrigin = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("tp-to-origin")).description("Automatically teleport player to initial position once all items have been picked up.")).defaultValue((Object)true)).visible(() -> this.moveMode.get() == MoveMode.Teleport)).build());
        this.waitTime = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("wait-time")).description("Time to wait after teleport (in ticks).")).min(1).defaultValue((Object)10)).visible(() -> this.moveMode.get() == MoveMode.Teleport && (Boolean)this.tpToOrigin.get() != false)).build());
        this.resetTimeAfterTp = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("reset-time-after-tp")).description("Resets wait time after teleport.")).defaultValue((Object)true)).visible(() -> this.moveMode.get() == MoveMode.Teleport && (Boolean)this.tpToOrigin.get() != false)).build());
        this.returnToOrigin = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("return-to-origin")).description("Automatically return player to initial position once all items have been picked up.")).defaultValue((Object)true)).visible(() -> this.moveMode.get() == MoveMode.Baritone)).build());
        this.returnRange = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("return-range")).description("The radius within which Baritone will return to its initial position (relative to the initial position).")).defaultValue((Object)0)).min(0).visible(() -> this.moveMode.get() == MoveMode.Baritone && (Boolean)this.returnToOrigin.get() != false)).build());
        this.modifySpeed = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("modify-speed")).description("Whether or not the speed of the player should be altered when using Baritone.")).defaultValue((Object)true)).visible(() -> this.moveMode.get() == MoveMode.Baritone)).build());
        this.moveSpeed = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("move-speed")).description("Modifies the player's movement speed when 'Modify Speed' is enabled.")).defaultValue(10.0).min(1.0).sliderRange(1.0, 30.0).visible(() -> this.moveMode.get() == MoveMode.Baritone && (Boolean)this.modifySpeed.get() != false)).build());
        this.disableOnItemCount = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("disable-on-item-count")).description("Disables the module when a certain number of items are picked up.")).defaultValue((Object)false)).build());
        this.itemCountMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("item-count-mode")).description("Defines how the maximum number of items to pick up is calculated.")).defaultValue((Object)ItemCountMode.Stacks)).visible(() -> this.disableOnItemCount.get())).build());
        this.maxItemCount = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("max-item-count")).description("Maximum number of items to pick up.")).defaultValue((Object)10)).min(1).sliderRange(1, 10).visible(() -> this.disableOnItemCount.get())).build());
        this.maxItemsAtOnce = this.sgRender.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("max-item-at-once")).description("Maximum number of hitboxes to render at once.")).defaultValue((Object)10)).min(1).sliderRange(1, 10).build());
        this.showTeleportBox = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("show-teleport-box")).description("Displays player hitbox at items position when using \"Teleport\" move mode.")).defaultValue((Object)true)).build());
        this.sideColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("side-color")).description("The color of the sides of box.")).defaultValue(new SettingColor(0, 0, 255, 40)).visible(() -> this.showTeleportBox.get())).build());
        this.lineColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("line-color")).description("The color of the lines of box.")).defaultValue(new SettingColor(0, 0, 255, 100)).visible(() -> this.showTeleportBox.get())).build());
        this.timer = 0;
        this.startPos = null;
        this.pickedUpStacksCount = 0;
        this.pickedUpItemsCount = 0;
        this.baritoneUtils = new MeteoristBaritoneUtils();
    }

    public void onActivate() {
        this.timer = 0;
        this.startPos = null;
        this.pickedUpStacksCount = 0;
        this.pickedUpItemsCount = 0;
        this.baritoneUtils.cancelEverything();
    }

    public void onDeactivate() {
        this.baritoneUtils.cancelEverything();
    }

    public class_238 getBoundingBoxAtPosition(class_243 pos) {
        class_243 offset = pos.method_1020(this.mc.field_1724.method_5829().method_64033());
        return this.mc.field_1724.method_5829().method_989(offset.method_10216(), offset.method_10214(), offset.method_10215());
    }

    public boolean canTeleportToItem(class_243 pos) {
        class_238 box = this.getBoundingBoxAtPosition(pos);
        Iterable collisions = this.mc.field_1687.method_20812((class_1297)this.mc.field_1724, box);
        List<class_265> collisionsList = StreamSupport.stream(collisions.spliterator(), false).filter((? super T voxelShape) -> !voxelShape.method_1110()).toList();
        return collisionsList.isEmpty();
    }

    private boolean filter(class_1297 entity) {
        if (entity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entity;
            boolean isPickupable = true;
            if (((Boolean)this.onlyPickupable.get()).booleanValue()) {
                isPickupable = !itemEntity.method_6977();
            }
            boolean isWithinRange = PlayerUtils.isWithin((class_1297)entity, (double)((Double)this.suckingRange.get()));
            boolean isOnGround = true;
            if (((Boolean)this.onlyOnGround.get()).booleanValue()) {
                isOnGround = entity.method_24828();
            }
            boolean isItemAllowed = this.itemFilteringMode.get() == OperationMode.Blacklist && !((List)this.itemBlacklist.get()).contains(itemEntity.method_6983().method_7909()) || this.itemFilteringMode.get() == OperationMode.Whitelist && ((List)this.itemWhitelist.get()).contains(itemEntity.method_6983().method_7909());
            boolean canTeleport = true;
            if (this.moveMode.get() == MoveMode.Teleport) {
                canTeleport = (Boolean)this.checkCollisions.get() != false && this.canTeleportToItem(itemEntity.method_19538());
            }
            return isPickupable && isWithinRange && isOnGround && isItemAllowed && canTeleport;
        }
        return false;
    }

    @EventHandler
    private void onGameJoined(GameJoinedEvent event) {
        this.timer = 0;
        this.startPos = null;
        this.pickedUpStacksCount = 0;
        this.pickedUpItemsCount = 0;
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        if (((Boolean)this.modifySpeed.get()).booleanValue() && this.baritoneUtils.isPathing()) {
            class_243 vel = PlayerUtils.getHorizontalVelocity((double)((Double)this.moveSpeed.get()));
            ((IVec3d)event.movement).meteor$set(vel.method_10216(), event.movement.field_1351, vel.method_10215());
        }
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (((Boolean)this.disableOnItemCount.get()).booleanValue()) {
            int currentItemCount;
            int n = currentItemCount = this.itemCountMode.get() == ItemCountMode.Stacks ? this.pickedUpStacksCount : this.pickedUpItemsCount;
            if (currentItemCount > (Integer)this.maxItemCount.get()) {
                this.toggle();
            }
        }
        if (this.moveMode.get() == MoveMode.Teleport) {
            class_1297 target = TargetUtils.get(this::filter, (SortPriority)SortPriority.LowestDistance);
            if (this.timer > 0) {
                --this.timer;
            }
            if (target != null) {
                if (((Boolean)this.tpToOrigin.get()).booleanValue()) {
                    if (((Boolean)this.resetTimeAfterTp.get()).booleanValue()) {
                        this.timer = (Integer)this.waitTime.get();
                    }
                    if (this.startPos == null) {
                        this.startPos = this.mc.field_1724.method_19538();
                    }
                }
                this.mc.field_1724.method_5814(target.method_23317(), target.method_23318(), target.method_23321());
            }
            if (this.timer <= 0 && ((Boolean)this.tpToOrigin.get()).booleanValue() && this.startPos != null) {
                this.mc.field_1724.method_5814(this.startPos.method_10216(), this.startPos.method_10214(), this.startPos.method_10215());
                this.startPos = null;
                this.timer = (Integer)this.waitTime.get();
            }
        } else if (BaritoneUtils.IS_AVAILABLE) {
            ArrayList<class_1297> targets = new ArrayList<class_1297>();
            TargetUtils.getList(targets, this::filter, (SortPriority)SortPriority.LowestDistance, (int)((Integer)this.maxItemsAtOnce.get()));
            if (!targets.isEmpty()) {
                this.baritoneUtils.setGoalNear(targets, (int)((Integer)this.itemRange.get()));
                if (((Boolean)this.returnToOrigin.get()).booleanValue() && this.startPos == null) {
                    this.startPos = this.mc.field_1724.method_24515().method_46558();
                }
            } else if (((Boolean)this.returnToOrigin.get()).booleanValue() && this.startPos != null) {
                this.baritoneUtils.setGoalNear(class_2338.method_49638((class_2374)this.startPos), (int)((Integer)this.returnRange.get()));
                this.startPos = null;
            }
        } else {
            ((OkPrompt)((OkPrompt)((OkPrompt)OkPrompt.create().title("Baritone is not available")).message("Looks like Baritone is not installed. Install Baritone to use this move mode.")).dontShowAgainCheckboxVisible(false)).show();
            this.moveMode.set((Object)MoveMode.Teleport);
        }
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        if (this.moveMode.get() == MoveMode.Teleport) {
            ArrayList entities = new ArrayList();
            TargetUtils.getList(entities, this::filter, (SortPriority)SortPriority.LowestDistance, (int)((Integer)this.maxItemsAtOnce.get()));
            entities.forEach(entity -> event.renderer.box(this.getBoundingBoxAtPosition(entity.method_19538()), (Color)this.sideColor.get(), (Color)this.lineColor.get(), ShapeMode.Both, 0));
        }
    }

    @EventHandler
    public void onItemPickup(PacketEvent.Receive event) {
        class_2596 class_25962 = event.packet;
        if (class_25962 instanceof class_2775) {
            class_2775 packet = (class_2775)class_25962;
            ++this.pickedUpStacksCount;
            this.pickedUpItemsCount += packet.method_11913();
        }
    }

    public static enum OperationMode {
        Whitelist,
        Blacklist;

    }

    public static enum MoveMode {
        Teleport,
        Baritone;

    }

    public static enum ItemCountMode {
        Stacks,
        Items;

    }
}

