/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.modules;

import java.util.Set;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EntityTypeListSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.friends.Friends;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1493;
import net.minecraft.class_1560;
import net.minecraft.class_1590;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_3966;
import net.minecraft.class_6025;
import zgoly.meteorist.Meteorist;
import zgoly.meteorist.utils.MeteoristUtils;

public class ZKillaura
extends Module {
    private final SettingGroup sgFilter;
    private final SettingGroup sgAttack;
    private final SettingGroup sgVisual;
    private final Setting<Set<class_1299<?>>> entities;
    private final Setting<Double> range;
    private final Setting<Boolean> ignoreBabies;
    private final Setting<Boolean> ignoreNamed;
    private final Setting<Boolean> ignorePassive;
    private final Setting<Boolean> ignoreTamed;
    private final Setting<Boolean> ignoreFriends;
    private final Setting<Boolean> ignoreWalls;
    private final Setting<OnFallMode> onFallMode;
    private final Setting<Double> onFallValue;
    private final Setting<Double> onFallMinRandomValue;
    private final Setting<Double> onFallMaxRandomValue;
    private final Setting<HitSpeedMode> hitSpeedMode;
    private final Setting<Double> hitSpeedValue;
    private final Setting<Double> hitSpeedMinRandomValue;
    private final Setting<Double> hitSpeedMaxRandomValue;
    private final Setting<Boolean> swingHand;
    float randomOnFallFloat;
    float randomHitSpeedFloat;

    public ZKillaura() {
        super(Meteorist.CATEGORY, "z-kill-aura", "Killaura which only attacks target if you aim at it.");
        this.sgFilter = this.settings.createGroup("Filter");
        this.sgAttack = this.settings.createGroup("Attack");
        this.sgVisual = this.settings.createGroup("Visual");
        this.entities = this.sgFilter.add((Setting)((EntityTypeListSetting.Builder)((EntityTypeListSetting.Builder)new EntityTypeListSetting.Builder().name("entities")).description("Specifies the entity types to target for attack.")).onlyAttackable().defaultValue(new class_1299[]{class_1299.field_6097}).build());
        this.range = this.sgFilter.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("range")).description("Defines the maximum range for attacking a target entity.")).defaultValue(4.5).min(0.0).sliderMax(6.0).build());
        this.ignoreBabies = this.sgFilter.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ignore-babies")).description("Prevents attacking baby variants of mobs.")).defaultValue((Object)true)).build());
        this.ignoreNamed = this.sgFilter.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ignore-named")).description("Prevents attacking named mobs.")).defaultValue((Object)false)).build());
        this.ignorePassive = this.sgFilter.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ignore-passive")).description("Allows attacking passive mobs only if they target you.")).defaultValue((Object)true)).build());
        this.ignoreTamed = this.sgFilter.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ignore-tamed")).description("Prevents attacking tamed mobs.")).defaultValue((Object)false)).build());
        this.ignoreFriends = this.sgFilter.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ignore-friends")).description("Prevents attacking players on your friends list.")).defaultValue((Object)true)).build());
        this.ignoreWalls = this.sgFilter.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ignore-walls")).description("Allows attacking through walls.")).defaultValue((Object)false)).build());
        this.onFallMode = this.sgAttack.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("on-fall-mode")).description("Chooses an attack strategy when falling to maximize critical damage.")).defaultValue((Object)OnFallMode.Value)).build());
        this.onFallValue = this.sgAttack.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("on-fall-value")).description("Defines a specific value for attacking while falling.")).min(0.0).defaultValue(0.25).sliderMax(1.0).visible(() -> this.onFallMode.get() == OnFallMode.Value)).build());
        this.onFallMinRandomValue = this.sgAttack.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("on-fall-min-random-value")).description("Specifies the minimum randomized value for attacking while falling.")).min(0.0).defaultValue(0.2).sliderMax(1.0).visible(() -> this.onFallMode.get() == OnFallMode.RandomValue)).build());
        this.onFallMaxRandomValue = this.sgAttack.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("on-fall-max-random-value")).description("Specifies the maximum randomized value for attacking while falling.")).min(0.0).defaultValue(0.4).sliderMax(1.0).visible(() -> this.onFallMode.get() == OnFallMode.RandomValue)).build());
        this.hitSpeedMode = this.sgAttack.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("hit-speed-mode")).description("Selects a hit speed mode for attacking.")).defaultValue((Object)HitSpeedMode.Value)).build());
        this.hitSpeedValue = this.sgAttack.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("hit-speed-value")).description("Defines a specific hit speed value for attacking.")).defaultValue(0.0).sliderRange(-10.0, 10.0).visible(() -> this.hitSpeedMode.get() == HitSpeedMode.Value)).build());
        this.hitSpeedMinRandomValue = this.sgAttack.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("hit-speed-min-random-value")).description("Specifies the minimum randomized hit speed value.")).defaultValue(0.0).sliderRange(-10.0, 10.0).visible(() -> this.hitSpeedMode.get() == HitSpeedMode.RandomValue)).build());
        this.hitSpeedMaxRandomValue = this.sgAttack.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("hit-speed-max-random-value")).description("Specifies the maximum randomized hit speed value.")).defaultValue(0.0).sliderRange(-10.0, 10.0).visible(() -> this.hitSpeedMode.get() == HitSpeedMode.RandomValue)).build());
        this.swingHand = this.sgVisual.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("swing-hand")).description("Makes hand swing visible client-side.")).defaultValue((Object)true)).build());
        this.randomOnFallFloat = 0.0f;
        this.randomHitSpeedFloat = 0.0f;
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        HitSpeedMode currHitSpeedMode;
        float hitSpeed;
        if (this.mc.field_1724.method_29504() || this.mc.field_1687 == null) {
            return;
        }
        OnFallMode currOnFallMode = (OnFallMode)((Object)this.onFallMode.get());
        if (currOnFallMode != OnFallMode.None) {
            float onFall;
            float f = onFall = currOnFallMode == OnFallMode.Value ? ((Double)this.onFallValue.get()).floatValue() : this.randomOnFallFloat;
            if (!(this.mc.field_1724.field_6017 > onFall)) {
                return;
            }
        }
        float f = hitSpeed = (currHitSpeedMode = (HitSpeedMode)((Object)this.hitSpeedMode.get())) == HitSpeedMode.Value ? ((Double)this.hitSpeedValue.get()).floatValue() : this.randomHitSpeedFloat;
        if (currHitSpeedMode != HitSpeedMode.None && this.mc.field_1724.method_7261(hitSpeed) * 17.0f < 16.0f) {
            return;
        }
        class_239 hitResult = MeteoristUtils.getCrosshairTarget((class_1297)this.mc.field_1724, (Double)this.range.get(), (Boolean)this.ignoreWalls.get(), e -> {
            class_6025 tameable;
            if (e.method_7325()) return false;
            if (!e.method_5863()) return false;
            if (!((Set)this.entities.get()).contains(e.method_5864())) return false;
            if (((Boolean)this.ignoreBabies.get()).booleanValue() && e instanceof class_1429) {
                if (((class_1429)e).method_6109()) return false;
            }
            if (((Boolean)this.ignoreNamed.get()).booleanValue()) {
                if (e.method_16914()) return false;
            }
            if (((Boolean)this.ignorePassive.get()).booleanValue()) {
                if (e instanceof class_1560) {
                    class_1560 enderman = (class_1560)e;
                    if (!enderman.method_7028()) return false;
                }
                if (e instanceof class_1590) {
                    class_1590 piglin = (class_1590)e;
                    if (!piglin.method_6510()) return false;
                }
                if (e instanceof class_1493) {
                    class_1493 wolf = (class_1493)e;
                    if (!wolf.method_6510()) return false;
                }
            }
            if (((Boolean)this.ignoreTamed.get()).booleanValue() && e instanceof class_6025 && (tameable = (class_6025)e).method_6139() != null) {
                if (tameable.method_6139().equals(this.mc.field_1724.method_5667())) return false;
            }
            if ((Boolean)this.ignoreFriends.get() == false) return true;
            if (!(e instanceof class_1657)) return true;
            class_1657 player = (class_1657)e;
            if (!Friends.get().shouldAttack(player)) return false;
            return true;
        });
        if (hitResult == null || hitResult.method_17783() != class_239.class_240.field_1331) {
            return;
        }
        class_1297 entity = ((class_3966)hitResult).method_17782();
        class_1309 livingEntity = (class_1309)entity;
        if (livingEntity.method_6032() > 0.0f) {
            float max;
            float min;
            this.mc.field_1761.method_2918((class_1657)this.mc.field_1724, (class_1297)livingEntity);
            if (((Boolean)this.swingHand.get()).booleanValue()) {
                this.mc.field_1724.method_6104(class_1268.field_5808);
            }
            if (currOnFallMode == OnFallMode.RandomValue) {
                min = Math.min(((Double)this.onFallMinRandomValue.get()).floatValue(), ((Double)this.onFallMaxRandomValue.get()).floatValue());
                max = Math.max(((Double)this.onFallMinRandomValue.get()).floatValue(), ((Double)this.onFallMaxRandomValue.get()).floatValue());
                this.randomOnFallFloat = min + this.mc.field_1687.field_9229.method_43057() * (max - min);
            }
            if (currHitSpeedMode == HitSpeedMode.RandomValue) {
                min = Math.min(((Double)this.hitSpeedMinRandomValue.get()).floatValue(), ((Double)this.hitSpeedMaxRandomValue.get()).floatValue());
                max = Math.max(((Double)this.hitSpeedMinRandomValue.get()).floatValue(), ((Double)this.hitSpeedMaxRandomValue.get()).floatValue());
                this.randomHitSpeedFloat = min + this.mc.field_1687.field_9229.method_43057() * (max - min);
            }
        }
    }

    public static enum OnFallMode {
        None,
        Value,
        RandomValue;

    }

    public static enum HitSpeedMode {
        None,
        Value,
        RandomValue;

    }
}

