/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.modules;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.List;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.meteor.MouseScrollEvent;
import meteordevelopment.meteorclient.events.render.GetFovEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.SoundEventListSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import zgoly.meteorist.Meteorist;
import zgoly.meteorist.events.HandRenderEvent;
import zgoly.meteorist.events.MouseSensitivityEvent;
import zgoly.meteorist.events.SmoothCameraEnabledEvent;
import zgoly.meteorist.events.TweenEndEvent;
import zgoly.meteorist.events.UpdateCameraSmoothingEvent;
import zgoly.meteorist.utils.misc.TweenHandler;

public class ZoomPlus
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgZoomIn;
    private final SettingGroup sgZoomOut;
    private final SettingGroup sgScrollIn;
    private final SettingGroup sgScrollOut;
    private final Setting<Double> zoomFactor;
    private final Setting<Double> scrollStep;
    private final Setting<Boolean> saveScrollStep;
    private final Setting<Boolean> cinematic;
    private final Setting<Double> cinematicFactor;
    private final Setting<Boolean> normalizeCinematic;
    private final Setting<Boolean> normalizeSensitivity;
    private final Setting<Double> sensitivityNormalizationFactor;
    private final Setting<Boolean> normalizeZoom;
    private final Setting<Double> zoomNormalizationFactor;
    private final Setting<Boolean> hideHud;
    private final Setting<Boolean> renderHands;
    private final Setting<Boolean> scroll;
    private final Setting<Boolean> instantZoomIn;
    private final Setting<TweenHandler.EasingStyle> zoomInEasingStyle;
    private final Setting<TweenHandler.EasingDirection> zoomInEasingDirection;
    private final Setting<Double> zoomInEasingDuration;
    private final Setting<Boolean> zoomInPlaySound;
    private final Setting<List<class_3414>> zoomInSound;
    private final Setting<Double> zoomInSoundPitch;
    private final Setting<Double> zoomInSoundVolume;
    private final Setting<Boolean> instantZoomOut;
    private final Setting<TweenHandler.EasingStyle> zoomOutEasingStyle;
    private final Setting<TweenHandler.EasingDirection> zoomOutEasingDirection;
    private final Setting<Double> zoomOutEasingDuration;
    private final Setting<Boolean> zoomOutPlaySound;
    private final Setting<List<class_3414>> zoomOutSound;
    private final Setting<Double> zoomOutSoundPitch;
    private final Setting<Double> zoomOutSoundVolume;
    private final Setting<Boolean> instantScrollIn;
    private final Setting<TweenHandler.EasingStyle> scrollInEasingStyle;
    private final Setting<TweenHandler.EasingDirection> scrollInEasingDirection;
    private final Setting<Double> scrollInEasingDuration;
    private final Setting<Boolean> scrollInPlaySound;
    private final Setting<List<class_3414>> scrollInSound;
    private final Setting<Double> scrollInSoundPitch;
    private final Setting<Double> scrollInSoundVolume;
    private final Setting<Boolean> instantScrollOut;
    private final Setting<TweenHandler.EasingStyle> scrollOutEasingStyle;
    private final Setting<TweenHandler.EasingDirection> scrollOutEasingDirection;
    private final Setting<Double> scrollOutEasingDuration;
    private final Setting<Boolean> scrollOutPlaySound;
    private final Setting<List<class_3414>> scrollOutSound;
    private final Setting<Double> scrollOutSoundPitch;
    private final Setting<Double> scrollOutSoundVolume;
    private final TweenHandler tweenHandler;
    private final AtomicDouble currentZoomFactor;
    private final AtomicDouble currentScrollStep;
    private double targetScrollStep;
    private boolean isSubscribed;
    private boolean deactivated;

    public ZoomPlus() {
        super(Meteorist.CATEGORY, "zoom-plus", "Advanced Zoom module with more customizable settings.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgZoomIn = this.settings.createGroup("Zoom In");
        this.sgZoomOut = this.settings.createGroup("Zoom Out");
        this.sgScrollIn = this.settings.createGroup("Scroll In");
        this.sgScrollOut = this.settings.createGroup("Scroll Out");
        this.zoomFactor = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("zoom-factor")).description("The factor by which to zoom.")).defaultValue(6.0).min(2.0).build());
        this.scrollStep = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("scroll-step")).description("The step size for scrolling.")).defaultValue(1.0).min(0.0).build());
        this.saveScrollStep = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("save-scroll-step")).description("Whether to save the scroll step value between sessions.")).defaultValue((Object)false)).build());
        this.cinematic = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("cinematic")).description("Enables cinematic mode when zooming.")).defaultValue((Object)true)).build());
        this.cinematicFactor = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("cinematic-factor")).description("The factor for cinematic mode.")).defaultValue(1.0).min(0.1).visible(() -> this.cinematic.get())).build());
        this.normalizeCinematic = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("normalize-cinematic")).description("Whether to normalize cinematic mode.")).defaultValue((Object)true)).visible(() -> this.cinematic.get())).build());
        this.normalizeSensitivity = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("normalize-sensitivity")).description("Whether to normalize sensitivity.")).defaultValue((Object)true)).build());
        this.sensitivityNormalizationFactor = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("sensitivity-normalization-factor")).description("The factor for normalized sensitivity.")).defaultValue(0.5).min(0.0).visible(() -> this.normalizeSensitivity.get())).build());
        this.normalizeZoom = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("normalize-zoom")).description("Whether to normalize zoom.")).defaultValue((Object)true)).build());
        this.zoomNormalizationFactor = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("zoom-normalization-factor")).description("The factor for normalized zoom.")).defaultValue(0.25).min(0.0).visible(() -> this.normalizeZoom.get())).build());
        this.hideHud = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("hide-HUD")).description("Whether to hide the HUD.")).defaultValue((Object)false)).build());
        this.renderHands = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("render-hands")).description("Whether to render hands.")).defaultValue((Object)true)).visible(() -> (Boolean)this.hideHud.get() == false)).build());
        this.scroll = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("allow-scroll")).description("Whether to allow zoom scrolling.")).defaultValue((Object)true)).build());
        this.instantZoomIn = this.sgZoomIn.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("instant-zoom-in")).description("Whether to zoom in instantly.")).defaultValue((Object)false)).build());
        this.zoomInEasingStyle = this.sgZoomIn.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("easing-style")).description("The easing style for zooming in.")).defaultValue((Object)TweenHandler.EasingStyle.Quint)).visible(() -> (Boolean)this.instantZoomIn.get() == false)).build());
        this.zoomInEasingDirection = this.sgZoomIn.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("easing-direction")).description("The direction of the easing for zooming in.")).defaultValue((Object)TweenHandler.EasingDirection.Out)).visible(() -> (Boolean)this.instantZoomIn.get() == false)).build());
        this.zoomInEasingDuration = this.sgZoomIn.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("easing-duration")).description("The duration of the easing for zooming in.")).defaultValue(1.0).min(0.1).visible(() -> (Boolean)this.instantZoomIn.get() == false)).build());
        this.zoomInPlaySound = this.sgZoomIn.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("play-sound")).description("Whether to play a sound when zooming in.")).defaultValue((Object)true)).build());
        this.zoomInSound = this.sgZoomIn.add((Setting)((SoundEventListSetting.Builder)((SoundEventListSetting.Builder)((SoundEventListSetting.Builder)((SoundEventListSetting.Builder)new SoundEventListSetting.Builder().name("sound")).description("Sound to play.")).defaultValue(List.of(class_3417.field_14561))).visible(() -> this.zoomInPlaySound.get())).build());
        this.zoomInSoundPitch = this.sgZoomIn.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("sound-pitch")).description("Pitch of the sound.")).defaultValue(1.0).min(0.0).sliderRange(0.5, 2.0).visible(() -> this.zoomInPlaySound.get())).build());
        this.zoomInSoundVolume = this.sgZoomIn.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("sound-volume")).description("Volume of the sound.")).defaultValue(0.25).min(0.0).sliderRange(0.0, 1.0).visible(() -> this.zoomInPlaySound.get())).build());
        this.instantZoomOut = this.sgZoomOut.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("instant-zoom-out")).description("Whether to zoom out instantly.")).defaultValue((Object)false)).build());
        this.zoomOutEasingStyle = this.sgZoomOut.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("easing-style")).description("The easing style for zooming out.")).defaultValue((Object)TweenHandler.EasingStyle.Quint)).visible(() -> (Boolean)this.instantZoomOut.get() == false)).build());
        this.zoomOutEasingDirection = this.sgZoomOut.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("easing-direction")).description("The direction of the easing for zooming out.")).defaultValue((Object)TweenHandler.EasingDirection.Out)).visible(() -> (Boolean)this.instantZoomOut.get() == false)).build());
        this.zoomOutEasingDuration = this.sgZoomOut.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("easing-duration")).description("The duration of the easing for zooming out.")).defaultValue(1.0).min(0.1).visible(() -> (Boolean)this.instantZoomOut.get() == false)).build());
        this.zoomOutPlaySound = this.sgZoomOut.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("play-sound")).description("Whether to play a sound when zooming out.")).defaultValue((Object)true)).build());
        this.zoomOutSound = this.sgZoomOut.add((Setting)((SoundEventListSetting.Builder)((SoundEventListSetting.Builder)((SoundEventListSetting.Builder)((SoundEventListSetting.Builder)new SoundEventListSetting.Builder().name("sound")).description("Sound to play.")).defaultValue(List.of(class_3417.field_14641))).visible(() -> this.zoomOutPlaySound.get())).build());
        this.zoomOutSoundPitch = this.sgZoomOut.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("sound-pitch")).description("Pitch of the sound.")).defaultValue(1.0).min(0.0).sliderRange(0.5, 2.0).visible(() -> this.zoomOutPlaySound.get())).build());
        this.zoomOutSoundVolume = this.sgZoomOut.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("sound-volume")).description("Volume of the sound.")).defaultValue(0.25).min(0.0).sliderRange(0.0, 1.0).visible(() -> this.zoomOutPlaySound.get())).build());
        this.instantScrollIn = this.sgScrollIn.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("instant-scroll-in")).description("Whether to scroll in instantly.")).defaultValue((Object)false)).build());
        this.scrollInEasingStyle = this.sgScrollIn.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("easing-style")).description("The easing style for scrolling in.")).defaultValue((Object)TweenHandler.EasingStyle.Quint)).visible(() -> (Boolean)this.instantScrollIn.get() == false)).build());
        this.scrollInEasingDirection = this.sgScrollIn.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("easing-direction")).description("The direction of the easing for scrolling in.")).defaultValue((Object)TweenHandler.EasingDirection.Out)).visible(() -> (Boolean)this.instantScrollIn.get() == false)).build());
        this.scrollInEasingDuration = this.sgScrollIn.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("easing-duration")).description("The duration of the easing for scrolling in.")).defaultValue(0.5).min(0.1).visible(() -> (Boolean)this.instantScrollIn.get() == false)).build());
        this.scrollInPlaySound = this.sgScrollIn.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("play-sound")).description("Whether to play a sound when scrolling in.")).defaultValue((Object)true)).build());
        this.scrollInSound = this.sgScrollIn.add((Setting)((SoundEventListSetting.Builder)((SoundEventListSetting.Builder)((SoundEventListSetting.Builder)((SoundEventListSetting.Builder)new SoundEventListSetting.Builder().name("sound")).description("Sound to play.")).defaultValue(List.of(class_3417.field_26972))).visible(() -> this.scrollInPlaySound.get())).build());
        this.scrollInSoundPitch = this.sgScrollIn.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("sound-pitch")).description("Pitch of the sound.")).defaultValue(1.0).min(0.0).sliderRange(0.5, 2.0).visible(() -> this.scrollInPlaySound.get())).build());
        this.scrollInSoundVolume = this.sgScrollIn.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("sound-volume")).description("Volume of the sound.")).defaultValue(0.5).min(0.0).sliderRange(0.0, 1.0).visible(() -> this.scrollInPlaySound.get())).build());
        this.instantScrollOut = this.sgScrollOut.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("instant-scroll-out")).description("Whether to scroll out instantly.")).defaultValue((Object)false)).build());
        this.scrollOutEasingStyle = this.sgScrollOut.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("easing-style")).description("The easing style for scrolling out.")).defaultValue((Object)TweenHandler.EasingStyle.Quint)).visible(() -> (Boolean)this.instantScrollOut.get() == false)).build());
        this.scrollOutEasingDirection = this.sgScrollOut.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("easing-direction")).description("The direction of the easing for scrolling out.")).defaultValue((Object)TweenHandler.EasingDirection.Out)).visible(() -> (Boolean)this.instantScrollOut.get() == false)).build());
        this.scrollOutEasingDuration = this.sgScrollOut.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("easing-duration")).description("The duration of the easing for scrolling out.")).defaultValue(0.5).min(0.1).visible(() -> (Boolean)this.instantScrollOut.get() == false)).build());
        this.scrollOutPlaySound = this.sgScrollOut.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("play-sound")).description("Whether to play a sound when scrolling out.")).defaultValue((Object)true)).build());
        this.scrollOutSound = this.sgScrollOut.add((Setting)((SoundEventListSetting.Builder)((SoundEventListSetting.Builder)((SoundEventListSetting.Builder)((SoundEventListSetting.Builder)new SoundEventListSetting.Builder().name("sound")).description("Sound to play.")).defaultValue(List.of(class_3417.field_26973))).visible(() -> this.scrollOutPlaySound.get())).build());
        this.scrollOutSoundPitch = this.sgScrollOut.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("sound-pitch")).description("Pitch of the sound.")).defaultValue(1.0).min(0.0).sliderRange(0.5, 2.0).visible(() -> this.scrollOutPlaySound.get())).build());
        this.scrollOutSoundVolume = this.sgScrollOut.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("sound-volume")).description("Volume of the sound.")).defaultValue(0.5).min(0.0).sliderRange(0.0, 1.0).visible(() -> this.scrollOutPlaySound.get())).build());
        this.tweenHandler = new TweenHandler();
        this.currentZoomFactor = new AtomicDouble(1.0);
        this.currentScrollStep = new AtomicDouble(0.0);
        this.targetScrollStep = 0.0;
        this.isSubscribed = false;
        this.deactivated = false;
        this.autoSubscribe = false;
    }

    @EventHandler
    public void onActivate() {
        this.deactivated = false;
        if (!this.isSubscribed) {
            if (((Boolean)this.hideHud.get()).booleanValue()) {
                this.mc.field_1690.field_1842 = true;
            }
            MeteorClient.EVENT_BUS.subscribe((Object)this);
            MeteorClient.EVENT_BUS.subscribe((Object)this.tweenHandler);
            this.isSubscribed = true;
        }
        if (((Boolean)this.zoomInPlaySound.get()).booleanValue()) {
            this.mc.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)((List)this.zoomInSound.get()).getFirst()), (float)((Double)this.zoomInSoundPitch.get()).floatValue(), (float)((Double)this.zoomInSoundVolume.get()).floatValue()));
        }
        this.tweenHandler.play((Boolean)this.instantZoomIn.get(), this.currentZoomFactor, (Double)this.zoomFactor.get(), (Double)this.zoomInEasingDuration.get(), (TweenHandler.EasingStyle)((Object)this.zoomInEasingStyle.get()), (TweenHandler.EasingDirection)((Object)this.zoomInEasingDirection.get()));
        if (((Boolean)this.scroll.get()).booleanValue()) {
            if (((Boolean)this.saveScrollStep.get()).booleanValue()) {
                this.tweenHandler.play((Boolean)this.instantZoomIn.get(), this.currentScrollStep, this.targetScrollStep, (Double)this.zoomInEasingDuration.get(), (TweenHandler.EasingStyle)((Object)this.zoomInEasingStyle.get()), (TweenHandler.EasingDirection)((Object)this.zoomInEasingDirection.get()));
            } else {
                this.targetScrollStep = 0.0;
            }
        }
    }

    @EventHandler
    public void onDeactivate() {
        this.deactivated = true;
        if (((Boolean)this.zoomOutPlaySound.get()).booleanValue()) {
            this.mc.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)((List)this.zoomOutSound.get()).getFirst()), (float)((Double)this.zoomOutSoundPitch.get()).floatValue(), (float)((Double)this.zoomOutSoundVolume.get()).floatValue()));
        }
        this.tweenHandler.play((Boolean)this.instantZoomOut.get(), this.currentZoomFactor, 1.0, (Double)this.zoomOutEasingDuration.get(), (TweenHandler.EasingStyle)((Object)this.zoomOutEasingStyle.get()), (TweenHandler.EasingDirection)((Object)this.zoomOutEasingDirection.get()));
        this.tweenHandler.play((Boolean)this.instantZoomOut.get(), this.currentScrollStep, 0.0, (Double)this.zoomOutEasingDuration.get(), (TweenHandler.EasingStyle)((Object)this.zoomOutEasingStyle.get()), (TweenHandler.EasingDirection)((Object)this.zoomOutEasingDirection.get()));
    }

    @EventHandler
    private void onMouseScroll(MouseScrollEvent event) {
        if (this.deactivated || !((Boolean)this.scroll.get()).booleanValue()) {
            return;
        }
        this.targetScrollStep = Math.max(0.0, event.value * (Double)this.scrollStep.get() + this.targetScrollStep);
        boolean scrollIn = event.value > 0.0;
        boolean playSound = scrollIn ? (Boolean)this.scrollInPlaySound.get() : (Boolean)this.scrollOutPlaySound.get();
        if (playSound) {
            class_3414 sound = scrollIn ? (class_3414)((List)this.scrollInSound.get()).getFirst() : (class_3414)((List)this.scrollOutSound.get()).getFirst();
            float soundPitch = scrollIn ? ((Double)this.scrollInSoundPitch.get()).floatValue() : ((Double)this.scrollOutSoundPitch.get()).floatValue();
            float soundVolume = scrollIn ? ((Double)this.scrollInSoundVolume.get()).floatValue() : ((Double)this.scrollOutSoundVolume.get()).floatValue();
            this.mc.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)sound, (float)soundPitch, (float)soundVolume));
        }
        boolean instantScroll = scrollIn ? (Boolean)this.instantScrollIn.get() : (Boolean)this.instantScrollOut.get();
        double scrollEasingDuration = scrollIn ? (Double)this.scrollInEasingDuration.get() : (Double)this.scrollOutEasingDuration.get();
        TweenHandler.EasingStyle scrollEasingStyle = scrollIn ? (TweenHandler.EasingStyle)((Object)this.scrollInEasingStyle.get()) : (TweenHandler.EasingStyle)((Object)this.scrollOutEasingStyle.get());
        TweenHandler.EasingDirection scrollEasingDirection = scrollIn ? (TweenHandler.EasingDirection)((Object)this.scrollInEasingDirection.get()) : (TweenHandler.EasingDirection)((Object)this.scrollOutEasingDirection.get());
        this.tweenHandler.play(instantScroll, this.currentScrollStep, this.targetScrollStep, scrollEasingDuration, scrollEasingStyle, scrollEasingDirection);
        event.cancel();
    }

    @EventHandler
    private void onGetFov(GetFovEvent event) {
        event.fov /= (float)this.getScaling();
    }

    @EventHandler
    private void onHandRender(HandRenderEvent event) {
        if (!((Boolean)this.renderHands.get()).booleanValue()) {
            event.renderHand = false;
        }
    }

    @EventHandler
    private void onGetMouseSensitivity(MouseSensitivityEvent event) {
        if (((Boolean)this.normalizeSensitivity.get()).booleanValue()) {
            event.sensitivity /= 1.0 + (this.getScaling() - 1.0) * (Double)this.sensitivityNormalizationFactor.get();
        }
    }

    @EventHandler
    private void onUpdateCameraSmoothing(UpdateCameraSmoothingEvent event) {
        if (((Boolean)this.cinematic.get()).booleanValue()) {
            double normalizedCinematic = (Boolean)this.normalizeCinematic.get() != false ? this.getScaling() : 1.0;
            event.timeDelta *= (Double)this.cinematicFactor.get() * normalizedCinematic;
        }
    }

    @EventHandler
    public void onTweenEnd(TweenEndEvent event) {
        if (this.currentZoomFactor.get() == 1.0) {
            if (((Boolean)this.hideHud.get()).booleanValue()) {
                this.mc.field_1690.field_1842 = false;
            }
            MeteorClient.EVENT_BUS.unsubscribe((Object)this);
            MeteorClient.EVENT_BUS.unsubscribe((Object)this.tweenHandler);
            this.isSubscribed = false;
        }
    }

    @EventHandler
    public void onSmoothCameraEnabled(SmoothCameraEnabledEvent event) {
        if (this.deactivated) {
            return;
        }
        event.enabled = (Boolean)this.cinematic.get();
    }

    private double getScaling() {
        double finalZoomFactor = this.currentZoomFactor.get() + this.currentScrollStep.get();
        if (((Boolean)this.normalizeZoom.get()).booleanValue()) {
            return Math.exp((Double)this.zoomNormalizationFactor.get() * (finalZoomFactor - 1.0));
        }
        return finalZoomFactor;
    }
}

