/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.modules.autocrafter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import meteordevelopment.meteorclient.events.game.GameJoinedEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.widgets.WItem;
import meteordevelopment.meteorclient.gui.widgets.WLabel;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WContainer;
import meteordevelopment.meteorclient.gui.widgets.containers.WHorizontalList;
import meteordevelopment.meteorclient.gui.widgets.containers.WTable;
import meteordevelopment.meteorclient.gui.widgets.containers.WVerticalList;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.gui.widgets.pressable.WCheckbox;
import meteordevelopment.meteorclient.gui.widgets.pressable.WMinus;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1714;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_437;
import zgoly.meteorist.Meteorist;
import zgoly.meteorist.gui.screens.AutoCraftScreen;
import zgoly.meteorist.modules.autocrafter.AutoCraftFactory;
import zgoly.meteorist.modules.autocrafter.autocrafts.BaseAutoCraft;
import zgoly.meteorist.modules.autocrafter.autocrafts.CraftingTableAutoCraft;
import zgoly.meteorist.modules.autocrafter.autocrafts.InventoryAutoCraft;
import zgoly.meteorist.utils.config.MeteoristConfigManager;

public class AutoCrafter
extends Module {
    private final AutoCraftFactory factory = new AutoCraftFactory();
    private final List<BaseAutoCraft> autoCrafts = new ArrayList<BaseAutoCraft>();
    private BaseAutoCraft currentCraft = null;

    public AutoCrafter() {
        super(Meteorist.CATEGORY, "auto-crafter", "Automatically craft items.");
    }

    public class_2487 toTag() {
        class_2487 tag = super.toTag();
        class_2499 list = new class_2499();
        for (BaseAutoCraft autoCraft : this.autoCrafts) {
            class_2487 mTag = new class_2487();
            mTag.method_10582("type", autoCraft.getTypeName());
            mTag.method_10566("autoCraft", (class_2520)autoCraft.toTag());
            list.add((Object)mTag);
        }
        tag.method_10566("autoCrafts", (class_2520)list);
        return tag;
    }

    public Module fromTag(class_2487 tag) {
        super.fromTag(tag);
        this.autoCrafts.clear();
        class_2499 list = tag.method_10554("autoCrafts", 10);
        for (class_2520 tagI : list) {
            class_2487 tagII = (class_2487)tagI;
            String type = tagII.method_10558("type");
            BaseAutoCraft autoCraft = this.factory.createAutoCraft(type);
            if (autoCraft == null) continue;
            class_2487 autoCraftTag = tagII.method_10562("autoCraft");
            if (autoCraftTag != null) {
                autoCraft.fromTag(autoCraftTag);
            }
            this.autoCrafts.add(autoCraft);
        }
        return this;
    }

    public WWidget getWidget(GuiTheme theme) {
        WVerticalList list = theme.verticalList();
        this.fillWidget(theme, list);
        return list;
    }

    public void fillWidget(GuiTheme theme, WVerticalList list) {
        list.clear();
        WTable table = (WTable)list.add((WWidget)theme.table()).expandX().widget();
        for (BaseAutoCraft autoCraft : this.autoCrafts) {
            table.add((WWidget)theme.label(autoCraft.getTypeName())).expandX().widget();
            WHorizontalList container = (WHorizontalList)table.add((WWidget)theme.horizontalList()).expandX().widget();
            WTable ingredients = (WTable)container.add((WWidget)theme.table()).expandX().widget();
            if (autoCraft instanceof InventoryAutoCraft) {
                InventoryAutoCraft inventoryAutoCraft = (InventoryAutoCraft)autoCraft;
                this.addIngredients(theme, ingredients, inventoryAutoCraft.ingredients, 2);
            } else if (autoCraft instanceof CraftingTableAutoCraft) {
                CraftingTableAutoCraft craftingTableAutoCraft = (CraftingTableAutoCraft)autoCraft;
                this.addIngredients(theme, ingredients, craftingTableAutoCraft.ingredients, 3);
            }
            if (((Boolean)autoCraft.checkOutputItem.get()).booleanValue()) {
                container.add((WWidget)theme.label(">")).expandX();
                WItem outputItem = theme.item(((class_1792)autoCraft.getOutputItem().get()).method_7854());
                outputItem.tooltip = autoCraft.getOutputItem().description;
                container.add((WWidget)outputItem).expandX();
            }
            WTable conditions = (WTable)container.add((WWidget)theme.table()).expandX().widget();
            this.addCheckbox(theme, conditions, autoCraft.enabled);
            this.addCheckbox(theme, conditions, autoCraft.oneMore);
            this.addCheckbox(theme, conditions, autoCraft.clearSlots);
            WContainer moveContainer = (WContainer)table.add((WWidget)theme.horizontalList()).expandX().widget();
            if (this.autoCrafts.size() > 1) {
                int index = this.autoCrafts.indexOf(autoCraft);
                if (index > 0) {
                    WButton moveUp = (WButton)moveContainer.add((WWidget)theme.button(Meteorist.ARROW_UP)).expandX().widget();
                    moveUp.tooltip = "Move auto craft up.";
                    moveUp.action = () -> {
                        this.autoCrafts.remove(index);
                        this.autoCrafts.add(index - 1, autoCraft);
                        this.fillWidget(theme, list);
                    };
                }
                if (index < this.autoCrafts.size() - 1) {
                    WButton moveDown = (WButton)moveContainer.add((WWidget)theme.button(Meteorist.ARROW_DOWN)).expandX().widget();
                    moveDown.tooltip = "Move auto craft down.";
                    moveDown.action = () -> {
                        this.autoCrafts.remove(index);
                        this.autoCrafts.add(index + 1, autoCraft);
                        this.fillWidget(theme, list);
                    };
                }
            }
            WButton editButton = (WButton)table.add((WWidget)theme.button("Edit")).expandX().widget();
            editButton.tooltip = "Edit auto craft.";
            editButton.action = () -> this.mc.method_1507((class_437)new AutoCraftScreen(theme, autoCraft));
            WButton copyButton = (WButton)table.add((WWidget)theme.button(Meteorist.COPY)).widget();
            copyButton.tooltip = "Copy auto craft.";
            copyButton.action = () -> {
                this.autoCrafts.add(this.autoCrafts.indexOf(autoCraft), autoCraft.copy());
                this.fillWidget(theme, list);
            };
            WMinus removeButton = (WMinus)table.add((WWidget)theme.minus()).widget();
            removeButton.tooltip = "Remove auto craft.";
            removeButton.action = () -> {
                this.autoCrafts.remove(autoCraft);
                this.fillWidget(theme, list);
            };
            table.row();
        }
        list.add((WWidget)theme.horizontalSeparator()).expandX();
        WTable controls = (WTable)list.add((WWidget)theme.table()).expandX().widget();
        WButton newInventoryButton = (WButton)controls.add((WWidget)theme.button("Inventory Auto Craft")).expandX().widget();
        newInventoryButton.action = () -> {
            this.autoCrafts.add(new InventoryAutoCraft());
            this.fillWidget(theme, list);
        };
        WButton newCraftingTableButton = (WButton)controls.add((WWidget)theme.button("Crafting Table Auto Craft")).expandX().widget();
        newCraftingTableButton.action = () -> {
            this.autoCrafts.add(new CraftingTableAutoCraft());
            this.fillWidget(theme, list);
        };
        WButton removeAllButton = (WButton)controls.add((WWidget)theme.button("Remove All Auto Crafts")).expandX().widget();
        removeAllButton.action = () -> {
            this.autoCrafts.clear();
            this.fillWidget(theme, list);
        };
        MeteoristConfigManager.configManager(theme, list, this);
    }

    private void addIngredients(GuiTheme theme, WTable ingredients, List<Setting<class_1792>> ingredientsList, int rowSize) {
        for (int i = 0; i < ingredientsList.size(); ++i) {
            WItem ingredientItem = theme.item(((class_1792)ingredientsList.get(i).get()).method_7854());
            ingredientItem.tooltip = ingredientsList.get((int)i).description;
            ingredients.add((WWidget)ingredientItem).widget();
            if ((i + 1) % rowSize != 0 || i >= ingredientsList.size() - 1) continue;
            ingredients.row();
        }
    }

    private void addCheckbox(GuiTheme theme, WTable conditions, Setting<Boolean> setting) {
        WCheckbox checkbox = (WCheckbox)conditions.add((WWidget)theme.checkbox(((Boolean)setting.get()).booleanValue())).widget();
        checkbox.action = () -> setting.set((Object)((Boolean)setting.get() == false ? 1 : 0));
        WLabel label = (WLabel)conditions.add((WWidget)theme.label(setting.title)).widget();
        label.tooltip = setting.description;
        conditions.row();
    }

    public void onDeactivate() {
        this.currentCraft = null;
    }

    @EventHandler
    private void onGameJoined(GameJoinedEvent event) {
        this.currentCraft = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler
    private void onTick(TickEvent.Post event) {
        class_1703 currentScreenHandler = this.mc.field_1724.field_7512;
        if (this.currentCraft == null) {
            for (BaseAutoCraft autoCraft : this.autoCrafts) {
                if ((!(autoCraft instanceof InventoryAutoCraft) || !(currentScreenHandler instanceof class_1723)) && (!(autoCraft instanceof CraftingTableAutoCraft) || !(currentScreenHandler instanceof class_1714)) || !this.checkAutoCraft(autoCraft)) continue;
                this.currentCraft = autoCraft;
                break;
            }
        }
        if (!(currentScreenHandler instanceof class_1723) && !(currentScreenHandler instanceof class_1714)) {
            this.currentCraft = null;
            return;
        }
        if (this.currentCraft == null) return;
        BaseAutoCraft baseAutoCraft = this.currentCraft;
        if (baseAutoCraft instanceof InventoryAutoCraft) {
            InventoryAutoCraft inventoryAutoCraft = (InventoryAutoCraft)baseAutoCraft;
            if (currentScreenHandler instanceof class_1723) {
                class_1723 screen = (class_1723)currentScreenHandler;
                this.processAutoCraft(inventoryAutoCraft, (class_1703)screen);
                return;
            }
        }
        if (!((baseAutoCraft = this.currentCraft) instanceof CraftingTableAutoCraft)) return;
        CraftingTableAutoCraft craftingTableAutoCraft = (CraftingTableAutoCraft)baseAutoCraft;
        if (!(currentScreenHandler instanceof class_1714)) return;
        class_1714 screen = (class_1714)currentScreenHandler;
        this.processAutoCraft(craftingTableAutoCraft, (class_1703)screen);
    }

    private void processAutoCraft(BaseAutoCraft autoCraft, class_1703 screen) {
        class_1735 outputSlot;
        int totalActions = 0;
        for (Setting<class_1792> ingredient : autoCraft.ingredients) {
            FindItemResult result;
            int toSlot;
            class_1799 toSlotStack;
            if (totalActions >= autoCraft.getActionsPerTick()) {
                return;
            }
            class_1792 item = (class_1792)ingredient.get();
            if (item == class_1802.field_8615 || (toSlotStack = ((class_1735)screen.field_7761.get(toSlot = autoCraft.ingredients.indexOf(ingredient) + 1)).method_7677()) == null || toSlotStack.method_7909() == item || !(result = this.findItem(item, autoCraft)).found()) continue;
            if (((Boolean)autoCraft.clearSlots.get()).booleanValue()) {
                this.mc.field_1761.method_2906(screen.field_7763, toSlot, ((Integer)autoCraft.clearSlotsButton.get()).intValue(), (class_1713)autoCraft.clearSlotsAction.get(), (class_1657)this.mc.field_1724);
            }
            this.mc.field_1761.method_2906(screen.field_7763, result.slotId, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
            this.mc.field_1761.method_2906(screen.field_7763, toSlot, 1, class_1713.field_7790, (class_1657)this.mc.field_1724);
            this.mc.field_1761.method_2906(screen.field_7763, result.slotId, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
            ++totalActions;
        }
        if (totalActions == 0 && !(outputSlot = screen.method_7611(0)).method_7677().method_7960()) {
            if (((Boolean)autoCraft.checkOutputItem.get()).booleanValue() && outputSlot.method_7677().method_7909() != autoCraft.getOutputItem().get()) {
                return;
            }
            this.mc.field_1761.method_2906(screen.field_7763, outputSlot.field_7874, ((Integer)autoCraft.outputButton.get()).intValue(), (class_1713)autoCraft.outputAction.get(), (class_1657)this.mc.field_1724);
            this.currentCraft = null;
        }
    }

    public boolean checkAutoCraft(BaseAutoCraft autoCraft) {
        if (!((Boolean)autoCraft.enabled.get()).booleanValue()) {
            return false;
        }
        HashMap requiredItems = new HashMap();
        autoCraft.ingredients.forEach(ingredient -> {
            if (ingredient.get() != class_1802.field_8615) {
                requiredItems.put((class_1792)ingredient.get(), requiredItems.getOrDefault(ingredient.get(), 0) + 1);
            }
        });
        for (Map.Entry entry : requiredItems.entrySet()) {
            FindItemResult result;
            class_1792 item = (class_1792)entry.getKey();
            int count = (Integer)entry.getValue();
            if (((Boolean)autoCraft.oneMore.get()).booleanValue()) {
                ++count;
            }
            if ((result = this.findItem(item, autoCraft)).found() && result.totalCount >= count) continue;
            return false;
        }
        return true;
    }

    public FindItemResult findItem(class_1792 item, BaseAutoCraft autoCraft) {
        if (this.mc.field_1724 == null) {
            return new FindItemResult(-1, 0);
        }
        int slotId = -1;
        int totalCount = 0;
        class_1703 screenHandler = this.mc.field_1724.field_7512;
        if (screenHandler instanceof class_1714 || screenHandler instanceof class_1723) {
            for (class_1735 slot : screenHandler.field_7761) {
                class_1799 stack;
                if (screenHandler instanceof class_1714 && slot.field_7874 < 9 || screenHandler instanceof class_1723 && slot.field_7874 < 4 || (stack = slot.method_7677()) == null || stack.method_7909() != item) continue;
                int count = stack.method_7947();
                if (((Boolean)autoCraft.keepSingleStacks.get()).booleanValue() && count == 1) continue;
                if (slotId == -1) {
                    slotId = slot.field_7874;
                }
                totalCount += count;
            }
        }
        return new FindItemResult(slotId, totalCount);
    }

    public record FindItemResult(int slotId, int totalCount) {
        public boolean found() {
            return this.slotId != -1;
        }
    }
}

