/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.modules.autologin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import meteordevelopment.meteorclient.events.game.GameJoinedEvent;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WContainer;
import meteordevelopment.meteorclient.gui.widgets.containers.WVerticalList;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringListSetting;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_7472;
import zgoly.meteorist.Meteorist;
import zgoly.meteorist.modules.autologin.BaseAutoLogin;
import zgoly.meteorist.utils.config.MeteoristConfig;
import zgoly.meteorist.utils.config.MeteoristConfigManager;

public class AutoLogin
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Boolean> autoSave;
    private final Setting<Boolean> ignoreSelf;
    private final Setting<String> loginCommand;
    private final Setting<List<String>> commandsToHandle;
    private final Setting<Boolean> saveServerIp;
    private final Setting<Boolean> saveUsername;
    private final Setting<Boolean> checkPasswordCommand;
    private final Setting<Boolean> checkExecutionMode;
    private final Setting<Boolean> checkDelay;
    private final Setting<Boolean> checkUsername;
    private final Setting<Boolean> checkServerIp;
    private final Setting<Boolean> checkLastLogin;
    public static List<BaseAutoLogin> autoLogins = new ArrayList<BaseAutoLogin>();
    private long startWorldTime;
    private boolean work;
    private boolean isSendingChatMessage;

    public AutoLogin() {
        super(Meteorist.CATEGORY, "auto-login", "Automatically logs in your account using /login.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.autoSave = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("auto-save")).description("Automatically saves passwords when you login or register.")).defaultValue((Object)false)).build());
        this.ignoreSelf = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ignore-self")).description("Ignore self commands. Recommended to leave enabled, otherwise Auto Save will trigger on Auto Login commands.")).defaultValue((Object)true)).visible(() -> this.autoSave.get())).build());
        this.loginCommand = this.sgGeneral.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("login-command")).description("Command to login.")).defaultValue((Object)"/login")).visible(() -> this.autoSave.get())).build());
        this.commandsToHandle = this.sgGeneral.add((Setting)((StringListSetting.Builder)((StringListSetting.Builder)((StringListSetting.Builder)new StringListSetting.Builder().name("commands-to-handle")).description("Commands to handle.")).defaultValue(new String[]{"login", "log", "l", "register", "reg"}).visible(() -> this.autoSave.get())).build());
        this.saveServerIp = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("save-server-ip")).description("Save server IP in filter.")).defaultValue((Object)true)).visible(() -> this.autoSave.get())).build());
        this.saveUsername = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("save-username")).description("Save username in filter.")).defaultValue((Object)true)).visible(() -> this.autoSave.get())).build());
        this.checkPasswordCommand = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("check-password-command")).description("Whether to check password command when adding new auto login.")).defaultValue((Object)true)).visible(() -> this.autoSave.get())).build());
        this.checkExecutionMode = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("check-execution-mode")).description("Whether to check execution mode when adding new auto login.")).defaultValue((Object)false)).visible(() -> this.autoSave.get())).build());
        this.checkDelay = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("check-delay")).description("Whether to check delay when adding new auto login.")).defaultValue((Object)false)).visible(() -> this.autoSave.get())).build());
        this.checkUsername = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("check-username")).description("Whether to check username when adding new auto login.")).defaultValue((Object)false)).visible(() -> this.autoSave.get())).build());
        this.checkServerIp = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("check-server-ip")).description("Whether to check server IP when adding new auto login.")).defaultValue((Object)false)).visible(() -> this.autoSave.get())).build());
        this.checkLastLogin = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("check-last-login")).description("Whether to check last login when adding new auto login.")).defaultValue((Object)false)).visible(() -> this.autoSave.get())).build());
        this.startWorldTime = -1L;
        this.work = true;
        this.isSendingChatMessage = false;
    }

    public void onActivate() {
        this.startWorldTime = -1L;
    }

    public class_2487 toTag() {
        class_2487 superTag = super.toTag();
        class_2487 tag = new class_2487();
        class_2499 list = new class_2499();
        for (BaseAutoLogin autoLogin : autoLogins) {
            class_2487 mTag = new class_2487();
            mTag.method_10566("autoLogin", (class_2520)autoLogin.toTag());
            list.add((Object)mTag);
        }
        tag.method_10566("autoLogins", (class_2520)list);
        MeteoristConfig.save(this.name, "default", tag);
        return superTag;
    }

    public Module fromTag(class_2487 superTag) {
        class_2487 tag = MeteoristConfig.load(this.name, "default");
        autoLogins.clear();
        class_2499 list = tag.method_10554("autoLogins", 10);
        for (class_2520 tagII : list) {
            class_2487 tagI = (class_2487)tagII;
            BaseAutoLogin autoLogin = new BaseAutoLogin();
            class_2487 autoLoginTag = tagI.method_10562("autoLogin");
            if (autoLoginTag != null) {
                autoLogin.fromTag(autoLoginTag);
            }
            autoLogins.add(autoLogin);
        }
        return super.fromTag(superTag);
    }

    public WWidget getWidget(GuiTheme theme) {
        WVerticalList list = theme.verticalList();
        this.fillWidget(theme, list);
        return list;
    }

    private void fillWidget(GuiTheme theme, WVerticalList list) {
        list.clear();
        for (BaseAutoLogin autoLogin : autoLogins) {
            list.add(theme.settings(autoLogin.settings)).expandX();
            WContainer controls = (WContainer)list.add((WWidget)theme.horizontalList()).widget();
            if (autoLogins.size() > 1) {
                WContainer moveContainer = (WContainer)controls.add((WWidget)theme.horizontalList()).expandX().widget();
                int index = autoLogins.indexOf(autoLogin);
                if (index > 0) {
                    WButton moveUp = (WButton)moveContainer.add((WWidget)theme.button(Meteorist.ARROW_UP)).expandX().widget();
                    moveUp.tooltip = "Move auto login up.";
                    moveUp.action = () -> {
                        autoLogins.remove(index);
                        autoLogins.add(index - 1, autoLogin);
                        this.fillWidget(theme, list);
                    };
                }
                if (index < autoLogins.size() - 1) {
                    WButton moveDown = (WButton)moveContainer.add((WWidget)theme.button(Meteorist.ARROW_DOWN)).expandX().widget();
                    moveDown.tooltip = "Move auto login down.";
                    moveDown.action = () -> {
                        autoLogins.remove(index);
                        autoLogins.add(index + 1, autoLogin);
                        this.fillWidget(theme, list);
                    };
                }
            }
            WButton copy = (WButton)controls.add((WWidget)theme.button("Copy")).expandX().widget();
            copy.tooltip = "Duplicate auto login.";
            copy.action = () -> {
                autoLogins.add(autoLogins.indexOf(autoLogin), autoLogin.copy());
                this.fillWidget(theme, list);
            };
            WButton remove = (WButton)controls.add((WWidget)theme.button("Remove")).expandX().widget();
            remove.tooltip = "Remove auto login.";
            remove.action = () -> {
                autoLogins.remove(autoLogin);
                this.fillWidget(theme, list);
            };
        }
        list.add((WWidget)theme.horizontalSeparator()).expandX();
        WContainer controls = (WContainer)list.add((WWidget)theme.horizontalList()).expandX().widget();
        WButton add = (WButton)controls.add((WWidget)theme.button("New Auto Login")).expandX().widget();
        add.action = () -> {
            BaseAutoLogin autoLogin = new BaseAutoLogin();
            autoLogins.add(autoLogin);
            this.fillWidget(theme, list);
        };
        WButton removeAll = (WButton)controls.add((WWidget)theme.button("Remove All Auto Logins")).expandX().widget();
        removeAll.action = () -> {
            autoLogins.clear();
            this.fillWidget(theme, list);
        };
        MeteoristConfigManager.configManager(theme, list, this);
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (this.work) {
            if (this.startWorldTime == -1L) {
                this.startWorldTime = this.mc.field_1687.method_8510();
            }
            boolean hasRemainingAutoLogins = false;
            for (BaseAutoLogin autoLogin : List.copyOf(autoLogins)) {
                if (this.mc.field_1687.method_8510() < this.startWorldTime + (long)((Integer)autoLogin.delay.get()).intValue()) {
                    hasRemainingAutoLogins = true;
                    continue;
                }
                if (autoLogin.executionMode.get() == BaseAutoLogin.ExecutionMode.Multiplayer && this.mc.method_1542() || autoLogin.executionMode.get() == BaseAutoLogin.ExecutionMode.Singleplayer && !this.mc.method_1542() || !((String)autoLogin.serverIpFilter.get()).isEmpty() && !Utils.getWorldName().equals(autoLogin.serverIpFilter.get()) || !((String)autoLogin.usernameFilter.get()).isEmpty() && !this.mc.method_1548().method_1676().equals(autoLogin.usernameFilter.get())) continue;
                this.isSendingChatMessage = true;
                ChatUtils.sendPlayerMsg((String)((String)autoLogin.passwordCommand.get()));
                this.isSendingChatMessage = false;
                if (((Boolean)autoLogin.lastLogin.get()).booleanValue()) {
                    this.work = false;
                    break;
                }
                if (hasRemainingAutoLogins) continue;
                this.work = false;
            }
        }
    }

    @EventHandler
    private void onGameJoined(GameJoinedEvent event) {
        this.startWorldTime = -1L;
        this.work = true;
    }

    @EventHandler
    private void onPacketSent(PacketEvent.Send event) {
        class_2596 class_25962;
        if (((Boolean)this.autoSave.get()).booleanValue() && (class_25962 = event.packet) instanceof class_7472) {
            class_7472 packet = (class_7472)class_25962;
            if (((Boolean)this.ignoreSelf.get()).booleanValue() && this.isSendingChatMessage) {
                return;
            }
            String command = packet.comp_808();
            String[] args = command.split(" ");
            if (args.length >= 2 && ((List)this.commandsToHandle.get()).contains(args[0])) {
                BaseAutoLogin autoLogin = new BaseAutoLogin();
                autoLogin.passwordCommand.set((Object)((String)this.loginCommand.get() + " " + args[1]));
                if (((Boolean)this.saveUsername.get()).booleanValue()) {
                    autoLogin.usernameFilter.set((Object)this.mc.method_1548().method_1676());
                }
                if (((Boolean)this.saveServerIp.get()).booleanValue() && this.mc.method_1576() != null) {
                    autoLogin.serverIpFilter.set((Object)Utils.getWorldName());
                }
                if (!this.exists(autoLogin)) {
                    autoLogins.add(autoLogin);
                }
            }
        }
    }

    public boolean exists(BaseAutoLogin toCheck) {
        for (BaseAutoLogin autoLogin : List.copyOf(autoLogins)) {
            boolean allChecksPassed = true;
            if (((Boolean)this.checkPasswordCommand.get()).booleanValue()) {
                allChecksPassed &= ((String)autoLogin.passwordCommand.get()).equals(toCheck.passwordCommand.get());
            }
            if (((Boolean)this.checkExecutionMode.get()).booleanValue()) {
                allChecksPassed &= autoLogin.executionMode.get() == toCheck.executionMode.get();
            }
            if (((Boolean)this.checkDelay.get()).booleanValue()) {
                allChecksPassed &= Objects.equals(autoLogin.delay.get(), toCheck.delay.get());
            }
            if (((Boolean)this.checkUsername.get()).booleanValue()) {
                allChecksPassed &= ((String)autoLogin.usernameFilter.get()).equals(toCheck.usernameFilter.get());
            }
            if (((Boolean)this.checkServerIp.get()).booleanValue()) {
                allChecksPassed &= ((String)autoLogin.serverIpFilter.get()).equals(toCheck.serverIpFilter.get());
            }
            if (((Boolean)this.checkLastLogin.get()).booleanValue()) {
                allChecksPassed &= autoLogin.lastLogin.get() == toCheck.lastLogin.get();
            }
            if (!allChecksPassed) continue;
            return true;
        }
        return false;
    }
}

