/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.modules.autotrade;

import java.util.ArrayList;
import java.util.List;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WContainer;
import meteordevelopment.meteorclient.gui.widgets.containers.WHorizontalList;
import meteordevelopment.meteorclient.gui.widgets.containers.WTable;
import meteordevelopment.meteorclient.gui.widgets.containers.WVerticalList;
import meteordevelopment.meteorclient.gui.widgets.input.WIntEdit;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.gui.widgets.pressable.WMinus;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2863;
import net.minecraft.class_3943;
import net.minecraft.class_437;
import net.minecraft.class_492;
import net.minecraft.class_9306;
import zgoly.meteorist.Meteorist;
import zgoly.meteorist.gui.screens.OfferScreen;
import zgoly.meteorist.modules.autotrade.OfferFactory;
import zgoly.meteorist.modules.autotrade.offers.BaseOffer;
import zgoly.meteorist.modules.autotrade.offers.IdOffer;
import zgoly.meteorist.modules.autotrade.offers.ItemsOffer;
import zgoly.meteorist.utils.config.MeteoristConfigManager;

public class AutoTrade
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Boolean> oneOfferPerTick;
    private final Setting<Boolean> closeWhenDone;
    private final Setting<Boolean> printDebugInfo;
    private final OfferFactory factory;
    private final List<BaseOffer> offers;
    private class_3943 lastTrade;

    public AutoTrade() {
        super(Meteorist.CATEGORY, "auto-trade", "Automatically trades items with villagers (idea by Hiradpi).");
        this.sgGeneral = this.settings.createGroup("Auto Trade");
        this.oneOfferPerTick = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("one-offer-per-tick")).description("One offer per tick.")).defaultValue((Object)true)).build());
        this.closeWhenDone = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("close-when-done")).description("Closes the trade screen when done.")).defaultValue((Object)false)).build());
        this.printDebugInfo = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("print-debug-info")).description("Prints debug information.")).defaultValue((Object)false)).build());
        this.factory = new OfferFactory();
        this.offers = new ArrayList<BaseOffer>();
        this.lastTrade = null;
    }

    public class_2487 toTag() {
        class_2487 tag = super.toTag();
        class_2499 list = new class_2499();
        for (BaseOffer offer : this.offers) {
            class_2487 mTag = new class_2487();
            mTag.method_10582("type", offer.getTypeName());
            mTag.method_10566("offer", (class_2520)offer.toTag());
            list.add((Object)mTag);
        }
        tag.method_10566("offers", (class_2520)list);
        return tag;
    }

    public Module fromTag(class_2487 tag) {
        super.fromTag(tag);
        this.offers.clear();
        class_2499 list = tag.method_10554("offers", 10);
        for (class_2520 tagII : list) {
            class_2487 tagI = (class_2487)tagII;
            String type = tagI.method_10558("type");
            BaseOffer offer = this.factory.createOffer(type);
            if (offer == null) continue;
            class_2487 offerTag = tagI.method_10562("offer");
            if (offerTag != null) {
                offer.fromTag(offerTag);
            }
            this.offers.add(offer);
        }
        return this;
    }

    public WWidget getWidget(GuiTheme theme) {
        WVerticalList list = theme.verticalList();
        this.fillWidget(theme, list);
        return list;
    }

    public void fillWidget(GuiTheme theme, WVerticalList list) {
        list.clear();
        WTable table = (WTable)list.add((WWidget)theme.table()).expandX().widget();
        for (BaseOffer offer : this.offers) {
            table.add((WWidget)theme.label(offer.getTypeName())).expandX().widget();
            WHorizontalList container = (WHorizontalList)table.add((WWidget)theme.horizontalList()).expandX().widget();
            if (offer instanceof ItemsOffer) {
                String range;
                int max;
                int min;
                ItemsOffer itemsOffer = (ItemsOffer)offer;
                int pad = 16;
                if (((Boolean)itemsOffer.checkFirstInputItem.get()).booleanValue()) {
                    if (((Boolean)itemsOffer.checkFirstInputItemCount.get()).booleanValue()) {
                        min = (Integer)itemsOffer.minFirstInputItemCount.get();
                        range = min == (max = ((Integer)itemsOffer.maxFirstInputItemCount.get()).intValue()) ? "x" + min : "x" + min + " - x" + max;
                        container.add((WWidget)theme.itemWithLabel(((class_1792)itemsOffer.firstInputItem.get()).method_7854(), range)).padRight((double)pad);
                    } else {
                        container.add((WWidget)theme.item(((class_1792)itemsOffer.firstInputItem.get()).method_7854())).padRight((double)pad);
                    }
                }
                if (((Boolean)itemsOffer.checkFirstInputItem.get()).booleanValue() && ((Boolean)itemsOffer.checkSecondInputItem.get()).booleanValue()) {
                    container.add((WWidget)theme.label(" + ")).padRight((double)pad);
                }
                if (((Boolean)itemsOffer.checkSecondInputItem.get()).booleanValue()) {
                    if (((Boolean)itemsOffer.checkSecondInputItemCount.get()).booleanValue()) {
                        min = (Integer)itemsOffer.minSecondInputItemCount.get();
                        range = min == (max = ((Integer)itemsOffer.maxSecondInputItemCount.get()).intValue()) ? "x" + min : "x" + min + " - x" + max;
                        container.add((WWidget)theme.itemWithLabel(((class_1792)itemsOffer.secondInputItem.get()).method_7854(), range)).padRight((double)pad);
                    } else {
                        container.add((WWidget)theme.item(((class_1792)itemsOffer.secondInputItem.get()).method_7854())).padRight((double)pad);
                    }
                }
                container.add((WWidget)theme.label(">")).padRight((double)pad);
                if (((Boolean)itemsOffer.checkOutputItem.get()).booleanValue()) {
                    if (((Boolean)itemsOffer.checkOutputItemCount.get()).booleanValue()) {
                        min = (Integer)itemsOffer.minOutputItemCount.get();
                        range = min == (max = ((Integer)itemsOffer.maxOutputItemCount.get()).intValue()) ? "x" + min : "x" + min + " - x" + max;
                        container.add((WWidget)theme.itemWithLabel(((class_1792)itemsOffer.outputItem.get()).method_7854(), range));
                    } else {
                        container.add((WWidget)theme.item(((class_1792)itemsOffer.outputItem.get()).method_7854()));
                    }
                }
            } else if (offer instanceof IdOffer) {
                IdOffer idOffer = (IdOffer)offer;
                WIntEdit edit = (WIntEdit)container.add((WWidget)theme.intEdit(((Integer)idOffer.offerId.get()).intValue(), 0, Integer.MAX_VALUE, true)).expandX().widget();
                edit.tooltip = idOffer.offerId.description;
                edit.actionOnRelease = () -> idOffer.offerId.set((Object)edit.get());
            }
            WButton edit = (WButton)table.add((WWidget)theme.button("Edit")).expandX().widget();
            edit.tooltip = "Edit the offer.";
            edit.action = () -> this.mc.method_1507((class_437)new OfferScreen(theme, offer));
            WContainer moveContainer = (WContainer)table.add((WWidget)theme.horizontalList()).expandX().widget();
            if (this.offers.size() > 1) {
                int index = this.offers.indexOf(offer);
                if (index > 0) {
                    WButton moveUp = (WButton)moveContainer.add((WWidget)theme.button(Meteorist.ARROW_UP)).expandX().widget();
                    moveUp.tooltip = "Move offer up.";
                    moveUp.action = () -> {
                        this.offers.remove(index);
                        this.offers.add(index - 1, offer);
                        this.fillWidget(theme, list);
                    };
                }
                if (index < this.offers.size() - 1) {
                    WButton moveDown = (WButton)moveContainer.add((WWidget)theme.button(Meteorist.ARROW_DOWN)).expandX().widget();
                    moveDown.tooltip = "Move offer down.";
                    moveDown.action = () -> {
                        this.offers.remove(index);
                        this.offers.add(index + 1, offer);
                        this.fillWidget(theme, list);
                    };
                }
            }
            WButton copy = (WButton)table.add((WWidget)theme.button(Meteorist.COPY)).widget();
            copy.tooltip = "Copy offer.";
            copy.action = () -> {
                this.offers.add(this.offers.indexOf(offer), offer.copy());
                this.fillWidget(theme, list);
            };
            WMinus remove = (WMinus)table.add((WWidget)theme.minus()).widget();
            remove.tooltip = "Remove offer.";
            remove.action = () -> {
                this.offers.remove(offer);
                this.fillWidget(theme, list);
            };
            table.row();
        }
        list.add((WWidget)theme.horizontalSeparator()).expandX();
        WTable controls = (WTable)list.add((WWidget)theme.table()).expandX().widget();
        WButton createItemsOffer = (WButton)controls.add((WWidget)theme.button("New Items Offer")).expandX().widget();
        createItemsOffer.action = () -> {
            this.offers.add(new ItemsOffer());
            this.fillWidget(theme, list);
        };
        WButton createIdOffer = (WButton)controls.add((WWidget)theme.button("New ID Offer")).expandX().widget();
        createIdOffer.action = () -> {
            this.offers.add(new IdOffer());
            this.fillWidget(theme, list);
        };
        WButton removeAll = (WButton)controls.add((WWidget)theme.button("Remove All Offers")).widget();
        removeAll.action = () -> {
            this.offers.clear();
            this.fillWidget(theme, list);
        };
        MeteoristConfigManager.configManager(theme, list, this);
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        boolean successfulOffer = false;
        if (this.lastTrade != null && this.mc.field_1755 instanceof class_492) {
            class_1916 tradeOffers = this.lastTrade.method_17590();
            boolean offerMatched = false;
            for (class_1914 tradeOffer : tradeOffers) {
                for (BaseOffer offer : this.offers) {
                    if (!((Boolean)offer.enabled.get()).booleanValue()) continue;
                    if (offer instanceof ItemsOffer) {
                        int max;
                        int min;
                        int count;
                        class_1792 tradeItem;
                        class_1792 item;
                        ItemsOffer itemsOffer = (ItemsOffer)offer;
                        this.printInfo("");
                        this.printInfo("===== Trade Offer \u2116" + tradeOffers.indexOf((Object)tradeOffer) + " (Offer: " + this.offers.indexOf(offer) + ") =====");
                        boolean firstInputItemMatched = true;
                        boolean secondInputItemMatched = true;
                        boolean outputItemMatched = true;
                        this.printInfo("");
                        this.printInfo("First Input Item");
                        if (((Boolean)itemsOffer.checkFirstInputItem.get()).booleanValue()) {
                            item = (class_1792)itemsOffer.firstInputItem.get();
                            tradeItem = (class_1792)tradeOffer.method_57556().comp_2424().comp_349();
                            this.printInfo("Item: " + String.valueOf(item) + ", Trade Item: " + String.valueOf(tradeItem));
                            if (item == tradeItem) {
                                if (((Boolean)itemsOffer.checkFirstInputItemCount.get()).booleanValue()) {
                                    count = (Boolean)itemsOffer.useFinalCount.get() != false ? tradeOffer.method_19272().method_7947() : tradeOffer.method_8246().method_7947();
                                    min = (Integer)itemsOffer.minFirstInputItemCount.get();
                                    max = (Integer)itemsOffer.maxFirstInputItemCount.get();
                                    firstInputItemMatched = count >= min && count <= max;
                                    this.printInfo("Count: " + count + ", Min: " + min + ", Max: " + max);
                                }
                            } else {
                                firstInputItemMatched = false;
                            }
                        }
                        this.printInfo("Item matched: " + firstInputItemMatched);
                        this.printInfo("");
                        this.printInfo("Second Input Item");
                        if (((Boolean)itemsOffer.checkSecondInputItem.get()).booleanValue() && tradeOffer.method_57557().isPresent()) {
                            item = (class_1792)itemsOffer.secondInputItem.get();
                            tradeItem = (class_1792)((class_9306)tradeOffer.method_57557().get()).comp_2424().comp_349();
                            this.printInfo("Item: " + String.valueOf(item) + ", Trade Item: " + String.valueOf(tradeItem));
                            if (item == tradeItem) {
                                if (((Boolean)itemsOffer.checkSecondInputItemCount.get()).booleanValue()) {
                                    count = tradeOffer.method_8247().method_7947();
                                    min = (Integer)itemsOffer.minSecondInputItemCount.get();
                                    max = (Integer)itemsOffer.maxSecondInputItemCount.get();
                                    secondInputItemMatched = count >= min && count <= max;
                                    this.printInfo("Count: " + count + ", Min: " + min + ", Max: " + max);
                                }
                            } else {
                                secondInputItemMatched = false;
                            }
                        }
                        this.printInfo("Item matched: " + secondInputItemMatched);
                        this.printInfo("");
                        this.printInfo("Output Item");
                        if (((Boolean)itemsOffer.checkOutputItem.get()).booleanValue()) {
                            item = (class_1792)itemsOffer.outputItem.get();
                            tradeItem = tradeOffer.method_8250().method_7909();
                            this.printInfo("Item: " + String.valueOf(item) + ", Trade Item: " + String.valueOf(tradeItem));
                            if (item == tradeItem) {
                                if (((Boolean)itemsOffer.checkOutputItemCount.get()).booleanValue()) {
                                    count = tradeOffer.method_8250().method_7947();
                                    min = (Integer)itemsOffer.minOutputItemCount.get();
                                    max = (Integer)itemsOffer.maxOutputItemCount.get();
                                    outputItemMatched = count >= min && count <= max;
                                    this.printInfo("Count: " + count + ", Min: " + min + ", Max: " + max);
                                }
                            } else {
                                outputItemMatched = false;
                            }
                        }
                        this.printInfo("Item matched: " + outputItemMatched);
                        if (!firstInputItemMatched || !secondInputItemMatched || !outputItemMatched || tradeOffer.method_8255()) continue;
                        offerMatched = true;
                        break;
                    }
                    if (!(offer instanceof IdOffer)) continue;
                    IdOffer idOffer = (IdOffer)offer;
                    if (((Integer)idOffer.offerId.get()).intValue() != tradeOffers.indexOf((Object)tradeOffer) || tradeOffer.method_8255()) continue;
                    offerMatched = true;
                    break;
                }
                if (!offerMatched) continue;
                offerMatched = false;
                successfulOffer = true;
                this.printInfo("Offer matched");
                this.mc.field_1687.method_8522((class_2596)new class_2863(tradeOffers.indexOf((Object)tradeOffer)));
                this.mc.field_1761.method_2906(this.mc.field_1724.field_7512.field_7763, 2, 0, class_1713.field_7794, (class_1657)this.mc.field_1724);
                if (!((Boolean)this.oneOfferPerTick.get()).booleanValue()) continue;
                break;
            }
            if (((Boolean)this.closeWhenDone.get()).booleanValue() && successfulOffer) {
                this.mc.field_1755.method_25419();
            }
        }
    }

    @EventHandler
    public void onPacket(PacketEvent.Receive event) {
        class_2596 class_25962 = event.packet;
        if (class_25962 instanceof class_3943) {
            class_3943 packet;
            this.lastTrade = packet = (class_3943)class_25962;
        }
    }

    private void printInfo(String message) {
        if (((Boolean)this.printDebugInfo.get()).booleanValue()) {
            this.info(message, new Object[0]);
        }
    }
}

