/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.modules.instructions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import meteordevelopment.meteorclient.events.game.GameJoinedEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WContainer;
import meteordevelopment.meteorclient.gui.widgets.containers.WTable;
import meteordevelopment.meteorclient.gui.widgets.containers.WVerticalList;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.gui.widgets.pressable.WMinus;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import zgoly.meteorist.Meteorist;
import zgoly.meteorist.modules.instructions.InstructionFactory;
import zgoly.meteorist.modules.instructions.instructions.BaseInstruction;
import zgoly.meteorist.modules.instructions.instructions.CommandInstruction;
import zgoly.meteorist.modules.instructions.instructions.DelayInstruction;
import zgoly.meteorist.utils.InstructionUtils;
import zgoly.meteorist.utils.config.MeteoristConfigManager;

public class Instructions
extends Module {
    public final SettingGroup sgDebug;
    public final Setting<Boolean> printDebugInfo;
    public static List<BaseInstruction> instructions = new ArrayList<BaseInstruction>();
    private final InstructionFactory factory;
    private int startTick;

    public Instructions() {
        super(Meteorist.CATEGORY, "instructions", "Runs commands with different delays and number of cycles. Supports Starscript.");
        this.sgDebug = this.settings.createGroup("Debug");
        this.printDebugInfo = this.sgDebug.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("print-debug-info")).description("Logs debug information to the chat. Not intended for the module, but for the command.")).defaultValue((Object)false)).build());
        this.factory = new InstructionFactory();
        this.startTick = -1;
    }

    public class_2487 toTag() {
        class_2487 tag = super.toTag();
        class_2499 list = new class_2499();
        for (BaseInstruction instruction : instructions) {
            class_2487 mTag = new class_2487();
            mTag.method_10582("type", instruction.getTypeName());
            mTag.method_10566("instruction", (class_2520)instruction.toTag());
            list.add((Object)mTag);
        }
        tag.method_10566("instructions", (class_2520)list);
        return tag;
    }

    public Module fromTag(class_2487 tag) {
        super.fromTag(tag);
        instructions.clear();
        instructions = InstructionUtils.readInstructionsFromTag(tag, this.factory);
        return this;
    }

    public WWidget getWidget(GuiTheme theme) {
        WVerticalList list = theme.verticalList();
        this.fillWidget(theme, list);
        return list;
    }

    private void fillWidget(GuiTheme theme, WVerticalList list) {
        list.clear();
        for (BaseInstruction instruction : instructions) {
            list.add(theme.settings(instruction.settings)).expandX();
            WContainer container = (WContainer)list.add((WWidget)theme.horizontalList()).expandX().widget();
            if (instructions.size() > 1) {
                int index = instructions.indexOf(instruction);
                if (index > 0) {
                    WButton moveUp = (WButton)container.add((WWidget)theme.button(Meteorist.ARROW_UP)).widget();
                    moveUp.tooltip = "Move instruction up.";
                    moveUp.action = () -> {
                        instructions.remove(index);
                        instructions.add(index - 1, instruction);
                        this.fillWidget(theme, list);
                    };
                }
                if (index < instructions.size() - 1) {
                    WButton moveDown = (WButton)container.add((WWidget)theme.button(Meteorist.ARROW_DOWN)).widget();
                    moveDown.tooltip = "Move instruction down.";
                    moveDown.action = () -> {
                        instructions.remove(index);
                        instructions.add(index + 1, instruction);
                        this.fillWidget(theme, list);
                    };
                }
            }
            WButton copy = (WButton)container.add((WWidget)theme.button(Meteorist.COPY)).widget();
            copy.tooltip = "Duplicate instruction.";
            copy.action = () -> {
                instructions.add(instructions.indexOf(instruction), instruction.copy());
                this.fillWidget(theme, list);
            };
            WMinus remove = (WMinus)container.add((WWidget)theme.minus()).widget();
            remove.tooltip = "Remove instruction.";
            remove.action = () -> {
                instructions.remove(instruction);
                this.fillWidget(theme, list);
            };
        }
        list.add((WWidget)theme.horizontalSeparator()).expandX();
        WTable controls = (WTable)list.add((WWidget)theme.table()).expandX().widget();
        WButton createCommand = (WButton)controls.add((WWidget)theme.button("New Command")).expandX().widget();
        createCommand.action = () -> {
            CommandInstruction instruction = new CommandInstruction();
            instructions.add(instruction);
            this.fillWidget(theme, list);
        };
        WButton createDelay = (WButton)controls.add((WWidget)theme.button("New Delay")).expandX().widget();
        createDelay.action = () -> {
            DelayInstruction instruction = new DelayInstruction();
            instructions.add(instruction);
            this.fillWidget(theme, list);
        };
        WButton removeAll = (WButton)controls.add((WWidget)theme.button("Remove All Instructions")).expandX().widget();
        removeAll.action = () -> {
            instructions.clear();
            this.fillWidget(theme, list);
        };
        MeteoristConfigManager.configManager(theme, list, this);
    }

    @EventHandler
    private void onGameJoined(GameJoinedEvent event) {
        this.startTick = -1;
    }

    public void onDeactivate() {
        this.startTick = -1;
    }

    @EventHandler
    public void onTick(TickEvent.Post event) {
        int currentTick = (int)this.mc.field_1687.method_8510();
        if (this.startTick == -1) {
            this.startTick = currentTick;
        }
        HashMap<Integer, List<String>> map = new HashMap<Integer, List<String>>();
        int lastTick = InstructionUtils.processInstructions(instructions, map);
        InstructionUtils.executeCommands(map, currentTick, this.startTick);
        if (this.startTick + lastTick <= currentTick) {
            this.startTick = -1;
        }
    }
}

