/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.modules.placer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WContainer;
import meteordevelopment.meteorclient.gui.widgets.containers.WTable;
import meteordevelopment.meteorclient.gui.widgets.containers.WVerticalList;
import meteordevelopment.meteorclient.gui.widgets.input.WTextBox;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.gui.widgets.pressable.WCheckbox;
import meteordevelopment.meteorclient.gui.widgets.pressable.WMinus;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.combat.KillAura;
import meteordevelopment.meteorclient.systems.modules.player.AutoEat;
import meteordevelopment.meteorclient.systems.modules.player.AutoGap;
import meteordevelopment.meteorclient.utils.player.FindItemResult;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.world.BlockUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import zgoly.meteorist.Meteorist;
import zgoly.meteorist.gui.screens.PlacerScreen;
import zgoly.meteorist.gui.widgets.WVisibilityCheckbox;
import zgoly.meteorist.modules.placer.BasePlacer;
import zgoly.meteorist.utils.MeteoristUtils;
import zgoly.meteorist.utils.config.MeteoristConfigManager;

public class Placer
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgTiming;
    private final SettingGroup sgPause;
    private final Setting<Boolean> checkConditions;
    private final Setting<Boolean> rotateHead;
    private final Setting<Boolean> limitRange;
    private final Setting<Double> maxRange;
    private final Setting<Boolean> renderEachBlock;
    private final Setting<Boolean> useDelay;
    private final Setting<Integer> maxBlocksPerTick;
    private final Setting<Integer> delay;
    private final Setting<Boolean> pauseOnAutoEat;
    private final Setting<Boolean> pauseOnAutoGap;
    private final Setting<Boolean> pauseOnKillAura;
    List<BasePlacer> placers;
    private int timer;
    private boolean work;

    public Placer() {
        super(Meteorist.CATEGORY, "placer", "Places blocks in range.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgTiming = this.settings.createGroup("Timing");
        this.sgPause = this.settings.createGroup("Pause");
        this.checkConditions = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("check-conditions")).description("Check conditions for placing blocks, such as whether block can be placed and whether there is entity that blocking block from being placed.")).defaultValue((Object)true)).build());
        this.rotateHead = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("rotate-head")).description("Rotate head when placing a block.")).defaultValue((Object)true)).build());
        this.limitRange = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("limit-range")).description("Limit block placement range.")).defaultValue((Object)true)).build());
        this.maxRange = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("max-range")).description("Max range to place blocks.")).defaultValue(4.0).visible(() -> this.limitRange.get())).sliderRange(1.0, 6.0).build());
        this.renderEachBlock = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("render-each-block")).description("Render each block in placer area.")).defaultValue((Object)true)).build());
        this.useDelay = this.sgTiming.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("use-delay")).description("Use delay between placing blocks.")).defaultValue((Object)true)).build());
        this.maxBlocksPerTick = this.sgTiming.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("max-blocks-per-tick")).description("Maximum blocks to place per tick.")).defaultValue((Object)1)).visible(() -> this.useDelay.get())).min(1).sliderRange(1, 10).build());
        this.delay = this.sgTiming.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("delay")).description("Delay after placing block(s) in ticks (20 ticks = 1 sec).")).defaultValue((Object)1)).visible(() -> this.useDelay.get())).range(1, 120).sliderRange(1, 40).build());
        this.pauseOnAutoEat = this.sgPause.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("pause-on-auto-eat")).description("Pause when Auto Eat is active and eats food.")).defaultValue((Object)true)).build());
        this.pauseOnAutoGap = this.sgPause.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("pause-on-auto-gap")).description("Pause when Auto Gap is active and eats gaps.")).defaultValue((Object)true)).build());
        this.pauseOnKillAura = this.sgPause.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("pause-on-kill-aura")).description("Pause when Kill Aura is active and attacks target entities.")).defaultValue((Object)true)).build());
        this.placers = new ArrayList<BasePlacer>();
    }

    public class_2487 toTag() {
        class_2487 tag = super.toTag();
        class_2499 list = new class_2499();
        for (BasePlacer placer : this.placers) {
            class_2487 mTag = new class_2487();
            mTag.method_10566("placer", (class_2520)placer.toTag());
            list.add((Object)mTag);
        }
        tag.method_10566("placers", (class_2520)list);
        return tag;
    }

    public Module fromTag(class_2487 tag) {
        super.fromTag(tag);
        this.placers.clear();
        class_2499 list = tag.method_10554("placers", 10);
        for (class_2520 tagII : list) {
            class_2487 tagI = (class_2487)tagII;
            BasePlacer placer = new BasePlacer();
            class_2487 placerTag = tagI.method_10562("placer");
            if (placerTag != null) {
                placer.fromTag(placerTag);
            }
            placer.settings.registerColorSettings(null);
            this.placers.add(placer);
        }
        return this;
    }

    public WWidget getWidget(GuiTheme theme) {
        WVerticalList list = theme.verticalList();
        this.fillWidget(theme, list);
        return list;
    }

    public void fillWidget(GuiTheme theme, WVerticalList list) {
        list.clear();
        WTable table = (WTable)list.add((WWidget)theme.table()).expandX().widget();
        for (BasePlacer placer : this.placers) {
            WTextBox name = (WTextBox)table.add((WWidget)theme.textBox((String)placer.name.get(), "Name")).expandX().widget();
            name.tooltip = placer.name.description;
            name.actionOnUnfocused = () -> placer.name.set((Object)name.get());
            WVisibilityCheckbox visible = new WVisibilityCheckbox((Boolean)placer.visible.get());
            table.add((WWidget)visible).widget();
            visible.tooltip = placer.visible.description;
            visible.action = () -> placer.visible.set((Object)visible.checked);
            WCheckbox active = (WCheckbox)table.add((WWidget)theme.checkbox(((Boolean)placer.active.get()).booleanValue())).widget();
            active.tooltip = placer.active.description;
            active.action = () -> placer.active.set((Object)active.checked);
            WButton edit = (WButton)table.add((WWidget)theme.button("Edit")).expandX().widget();
            edit.tooltip = "Edit the placer.";
            edit.action = () -> this.mc.method_1507((class_437)new PlacerScreen(theme, placer));
            WContainer moveContainer = (WContainer)table.add((WWidget)theme.horizontalList()).expandX().widget();
            if (this.placers.size() > 1) {
                int index = this.placers.indexOf(placer);
                if (index > 0) {
                    WButton moveUp = (WButton)moveContainer.add((WWidget)theme.button(Meteorist.ARROW_UP)).expandX().widget();
                    moveUp.tooltip = "Move placer up.";
                    moveUp.action = () -> {
                        this.placers.remove(index);
                        this.placers.add(index - 1, placer);
                        this.fillWidget(theme, list);
                    };
                }
                if (index < this.placers.size() - 1) {
                    WButton moveDown = (WButton)moveContainer.add((WWidget)theme.button(Meteorist.ARROW_DOWN)).expandX().widget();
                    moveDown.tooltip = "Move placer down.";
                    moveDown.action = () -> {
                        this.placers.remove(index);
                        this.placers.add(index + 1, placer);
                        this.fillWidget(theme, list);
                    };
                }
            }
            WButton copy = (WButton)table.add((WWidget)theme.button(Meteorist.COPY)).widget();
            copy.tooltip = "Duplicate placer.";
            copy.action = () -> {
                BasePlacer newPlacer = placer.copy();
                newPlacer.settings.registerColorSettings(null);
                this.placers.add(this.placers.indexOf(placer), newPlacer);
                this.fillWidget(theme, list);
            };
            WMinus remove = (WMinus)table.add((WWidget)theme.minus()).widget();
            remove.tooltip = "Remove placer.";
            remove.action = () -> {
                placer.settings.unregisterColorSettings();
                this.placers.remove(placer);
                this.fillWidget(theme, list);
            };
            table.row();
        }
        WTable controls = (WTable)list.add((WWidget)theme.table()).expandX().widget();
        WButton create = (WButton)controls.add((WWidget)theme.button("New Placer")).expandX().widget();
        create.action = () -> {
            BasePlacer placer = new BasePlacer();
            placer.settings.registerColorSettings(null);
            placer.name.set((Object)("Placer #" + (this.placers.size() + 1)));
            this.placers.add(placer);
            this.fillWidget(theme, list);
        };
        WButton removeAll = (WButton)controls.add((WWidget)theme.button("Remove All Placers")).expandX().widget();
        removeAll.action = () -> {
            this.placers.forEach(placer -> placer.settings.unregisterColorSettings());
            this.placers.clear();
            this.fillWidget(theme, list);
        };
        MeteoristConfigManager.configManager(theme, list, this);
    }

    private class_3545<class_2338, class_2338> getPlacePos(BasePlacer placer) {
        class_2338 finalPos1 = this.rotateBlockPos((class_2338)placer.cornerPos1.get(), (Boolean)placer.rotateY1.get());
        if (!((Boolean)placer.rotateX1.get()).booleanValue()) {
            finalPos1 = new class_2338(((class_2338)placer.cornerPos1.get()).method_10263(), finalPos1.method_10264(), finalPos1.method_10260());
        }
        if (!((Boolean)placer.rotateZ1.get()).booleanValue()) {
            finalPos1 = new class_2338(finalPos1.method_10263(), finalPos1.method_10264(), ((class_2338)placer.cornerPos1.get()).method_10260());
        }
        finalPos1 = finalPos1.method_10081((class_2382)this.mc.field_1724.method_24515());
        if (((Boolean)placer.anchorX1.get()).booleanValue()) {
            finalPos1 = new class_2338(((class_2338)placer.cornerPos1.get()).method_10263(), finalPos1.method_10264(), finalPos1.method_10260());
        }
        if (((Boolean)placer.anchorY1.get()).booleanValue()) {
            finalPos1 = new class_2338(finalPos1.method_10263(), ((class_2338)placer.cornerPos1.get()).method_10264(), finalPos1.method_10260());
        }
        if (((Boolean)placer.anchorZ1.get()).booleanValue()) {
            finalPos1 = new class_2338(finalPos1.method_10263(), finalPos1.method_10264(), ((class_2338)placer.cornerPos1.get()).method_10260());
        }
        finalPos1 = finalPos1.method_10081((class_2382)placer.cornerAnchorPos1.get());
        class_2338 finalPos2 = this.rotateBlockPos((class_2338)placer.cornerPos2.get(), (Boolean)placer.rotateY2.get());
        if (!((Boolean)placer.rotateX2.get()).booleanValue()) {
            finalPos2 = new class_2338(((class_2338)placer.cornerPos2.get()).method_10263(), finalPos2.method_10264(), finalPos2.method_10260());
        }
        if (!((Boolean)placer.rotateZ2.get()).booleanValue()) {
            finalPos2 = new class_2338(finalPos2.method_10263(), finalPos2.method_10264(), ((class_2338)placer.cornerPos2.get()).method_10260());
        }
        finalPos2 = finalPos2.method_10081((class_2382)this.mc.field_1724.method_24515());
        if (((Boolean)placer.anchorX2.get()).booleanValue()) {
            finalPos2 = new class_2338(((class_2338)placer.cornerPos2.get()).method_10263(), finalPos2.method_10264(), finalPos2.method_10260());
        }
        if (((Boolean)placer.anchorY2.get()).booleanValue()) {
            finalPos2 = new class_2338(finalPos2.method_10263(), ((class_2338)placer.cornerPos2.get()).method_10264(), finalPos2.method_10260());
        }
        if (((Boolean)placer.anchorZ2.get()).booleanValue()) {
            finalPos2 = new class_2338(finalPos2.method_10263(), finalPos2.method_10264(), ((class_2338)placer.cornerPos2.get()).method_10260());
        }
        finalPos2 = finalPos2.method_10081((class_2382)placer.cornerAnchorPos2.get());
        return new class_3545((Object)finalPos1, (Object)finalPos2);
    }

    private Stream<class_2338> getPlaceStream(class_3545<class_2338, class_2338> finalPos) {
        return class_2338.method_20437((class_2338)((class_2338)finalPos.method_15442()), (class_2338)((class_2338)finalPos.method_15441()));
    }

    public void onActivate() {
        this.timer = 0;
        this.work = true;
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (((Boolean)this.pauseOnAutoEat.get()).booleanValue() && ((AutoEat)Modules.get().get(AutoEat.class)).eating) {
            return;
        }
        if (((Boolean)this.pauseOnAutoGap.get()).booleanValue() && ((AutoGap)Modules.get().get(AutoGap.class)).isEating()) {
            return;
        }
        if (((Boolean)this.pauseOnKillAura.get()).booleanValue() && ((KillAura)Modules.get().get(KillAura.class)).attacking) {
            return;
        }
        if (this.work) {
            int loopCount = 0;
            block0: for (BasePlacer placer : this.placers) {
                if (!((Boolean)placer.active.get()).booleanValue()) continue;
                ArrayList<class_2338> blockPosList = new ArrayList<class_2338>();
                class_3545<class_2338, class_2338> finalPos = this.getPlacePos(placer);
                class_2338.method_20437((class_2338)((class_2338)finalPos.method_15442()), (class_2338)((class_2338)finalPos.method_15441())).filter(blockPos -> (Boolean)this.limitRange.get() == false || !(blockPos.method_46558().method_1022(this.mc.field_1724.method_33571()) > (Double)this.maxRange.get())).forEach(blockPos -> blockPosList.add(new class_2338((class_2382)blockPos)));
                blockPosList.sort(Comparator.comparingDouble(blockPos -> blockPos.method_46558().method_1022(this.mc.field_1724.method_33571())));
                for (class_2338 blockPos2 : blockPosList) {
                    if (((Boolean)this.useDelay.get()).booleanValue() && loopCount >= (Integer)this.maxBlocksPerTick.get()) break block0;
                    if (((Boolean)this.checkConditions.get()).booleanValue() && (!BlockUtils.canPlace((class_2338)blockPos2) || MeteoristUtils.isCollidesEntity(blockPos2))) continue;
                    Random random = new Random();
                    ArrayList<class_2248> hotbarBlocks = new ArrayList<class_2248>();
                    for (class_2248 block : (List)placer.blocks.get()) {
                        FindItemResult itemResult = InvUtils.findInHotbar((class_1792[])new class_1792[]{block.method_8389()});
                        if (!itemResult.found()) continue;
                        hotbarBlocks.add(block);
                    }
                    if (!hotbarBlocks.isEmpty()) {
                        class_2248 blockToPlace = (class_2248)hotbarBlocks.get(random.nextInt(hotbarBlocks.size()));
                        FindItemResult itemResult = InvUtils.findInHotbar((class_1792[])new class_1792[]{blockToPlace.method_8389()});
                        BlockUtils.place((class_2338)blockPos2, (FindItemResult)itemResult, (boolean)((Boolean)this.rotateHead.get()), (int)0);
                    }
                    if (!((Boolean)this.useDelay.get()).booleanValue()) continue;
                    ++loopCount;
                }
            }
            if (((Boolean)this.useDelay.get()).booleanValue()) {
                this.work = false;
            }
        }
        if (((Boolean)this.useDelay.get()).booleanValue()) {
            if (this.timer + 1 >= (Integer)this.delay.get()) {
                this.timer = 0;
                this.work = true;
            } else {
                ++this.timer;
            }
        }
    }

    public class_2338 rotateBlockPos(class_2338 pos, boolean rotateY) {
        if (rotateY) {
            float pitch = this.mc.field_1724.method_36455();
            if (pitch > 45.0f) {
                pos = new class_2338(pos.method_10264(), -pos.method_10263(), pos.method_10260());
            } else if (pitch < -45.0f) {
                pos = new class_2338(-pos.method_10264(), pos.method_10263(), pos.method_10260());
            }
        }
        class_2350 direction = class_2350.method_10150((double)this.mc.field_1724.method_36454());
        return switch (direction) {
            case class_2350.field_11043 -> new class_2338(pos.method_10260(), pos.method_10264(), -pos.method_10263());
            case class_2350.field_11035 -> new class_2338(-pos.method_10260(), pos.method_10264(), pos.method_10263());
            case class_2350.field_11039 -> new class_2338(-pos.method_10263(), pos.method_10264(), -pos.method_10260());
            default -> pos;
        };
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        for (BasePlacer placer : this.placers) {
            if (!((Boolean)placer.visible.get()).booleanValue()) continue;
            if (((Boolean)this.renderEachBlock.get()).booleanValue()) {
                this.getPlaceStream(this.getPlacePos(placer)).forEach(blockPos -> event.renderer.box(blockPos, (Color)placer.sideColor.get(), (Color)placer.lineColor.get(), ShapeMode.Both, 0));
                continue;
            }
            class_3545<class_2338, class_2338> finalPos = this.getPlacePos(placer);
            event.renderer.box(class_238.method_54784((class_2338)((class_2338)finalPos.method_15442()), (class_2338)((class_2338)finalPos.method_15441())), (Color)placer.sideColor.get(), (Color)placer.lineColor.get(), ShapeMode.Both, 0);
        }
    }
}

