/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.modules.rangeactions;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import meteordevelopment.meteorclient.events.entity.player.AttackEntityEvent;
import meteordevelopment.meteorclient.events.entity.player.InteractBlockEvent;
import meteordevelopment.meteorclient.events.entity.player.InteractEntityEvent;
import meteordevelopment.meteorclient.events.entity.player.StartBreakingBlockEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WContainer;
import meteordevelopment.meteorclient.gui.widgets.containers.WTable;
import meteordevelopment.meteorclient.gui.widgets.containers.WVerticalList;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.gui.widgets.pressable.WMinus;
import meteordevelopment.meteorclient.systems.friends.Friends;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1321;
import net.minecraft.class_1429;
import net.minecraft.class_1493;
import net.minecraft.class_1560;
import net.minecraft.class_1590;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import zgoly.meteorist.Meteorist;
import zgoly.meteorist.modules.rangeactions.RangeActionFactory;
import zgoly.meteorist.modules.rangeactions.rangeactions.BaseRangeAction;
import zgoly.meteorist.modules.rangeactions.rangeactions.CommandsRangeAction;
import zgoly.meteorist.modules.rangeactions.rangeactions.DespawnerRangeAction;
import zgoly.meteorist.modules.rangeactions.rangeactions.InteractionRangeAction;
import zgoly.meteorist.utils.config.MeteoristConfigManager;

public class RangeActions
extends Module {
    public static List<BaseRangeAction> rangeActions = new ArrayList<BaseRangeAction>();
    private final RangeActionFactory factory = new RangeActionFactory();
    private final Map<CommandsRangeAction, Integer> commandDelayTimers = new HashMap<CommandsRangeAction, Integer>();
    private final Map<CommandsRangeAction, Integer> commandIndex = new HashMap<CommandsRangeAction, Integer>();
    private Map<String, Boolean> ignoreFlags = new HashMap<String, Boolean>();

    public RangeActions() {
        super(Meteorist.CATEGORY, "range-actions", "Combined functionality of different range actions.");
    }

    public class_2487 toTag() {
        class_2487 tag = super.toTag();
        class_2499 list = new class_2499();
        for (BaseRangeAction rangeAction : rangeActions) {
            class_2487 mTag = new class_2487();
            mTag.method_10582("type", rangeAction.getTypeName());
            mTag.method_10566("rangeAction", (class_2520)rangeAction.toTag());
            list.add((Object)mTag);
        }
        tag.method_10566("rangeActions", (class_2520)list);
        return tag;
    }

    public Module fromTag(class_2487 tag) {
        super.fromTag(tag);
        rangeActions.clear();
        class_2499 list = tag.method_10554("rangeActions", 10);
        for (class_2520 tagII : list) {
            class_2487 tagI = (class_2487)tagII;
            String type = tagI.method_10558("type");
            BaseRangeAction rangeAction = this.factory.createRangeAction(type);
            if (rangeAction == null) continue;
            class_2487 rangeActionTag = tagI.method_10562("rangeAction");
            if (rangeActionTag != null) {
                rangeAction.fromTag(rangeActionTag);
            }
            rangeActions.add(rangeAction);
        }
        return this;
    }

    public WWidget getWidget(GuiTheme theme) {
        WVerticalList list = theme.verticalList();
        this.fillWidget(theme, list);
        return list;
    }

    private void fillWidget(GuiTheme theme, WVerticalList list) {
        list.clear();
        for (BaseRangeAction rangeAction : rangeActions) {
            list.add(theme.settings(rangeAction.settings)).expandX();
            WContainer container = (WContainer)list.add((WWidget)theme.horizontalList()).expandX().widget();
            if (rangeActions.size() > 1) {
                int index = rangeActions.indexOf(rangeAction);
                if (index > 0) {
                    WButton moveUp = (WButton)container.add((WWidget)theme.button(Meteorist.ARROW_UP)).widget();
                    moveUp.tooltip = "Move range action up.";
                    moveUp.action = () -> {
                        rangeActions.remove(index);
                        rangeActions.add(index - 1, rangeAction);
                        this.fillWidget(theme, list);
                    };
                }
                if (index < rangeActions.size() - 1) {
                    WButton moveDown = (WButton)container.add((WWidget)theme.button(Meteorist.ARROW_DOWN)).widget();
                    moveDown.tooltip = "Move range action down.";
                    moveDown.action = () -> {
                        rangeActions.remove(index);
                        rangeActions.add(index + 1, rangeAction);
                        this.fillWidget(theme, list);
                    };
                }
            }
            WButton copy = (WButton)container.add((WWidget)theme.button(Meteorist.COPY)).widget();
            copy.tooltip = "Duplicate range action.";
            copy.action = () -> {
                rangeActions.add(rangeActions.indexOf(rangeAction), rangeAction.copy());
                this.fillWidget(theme, list);
            };
            WMinus remove = (WMinus)container.add((WWidget)theme.minus()).widget();
            remove.tooltip = "Remove range action.";
            remove.action = () -> {
                rangeActions.remove(rangeAction);
                this.fillWidget(theme, list);
            };
        }
        list.add((WWidget)theme.horizontalSeparator()).expandX();
        WTable controls = (WTable)list.add((WWidget)theme.table()).expandX().widget();
        WButton createInteraction = (WButton)controls.add((WWidget)theme.button("New Interaction")).expandX().widget();
        createInteraction.action = () -> {
            InteractionRangeAction interactionAction = new InteractionRangeAction();
            rangeActions.add(interactionAction);
            this.fillWidget(theme, list);
        };
        WButton createDespawner = (WButton)controls.add((WWidget)theme.button("New Despawner")).expandX().widget();
        createDespawner.action = () -> {
            DespawnerRangeAction rangeAction = new DespawnerRangeAction();
            rangeActions.add(rangeAction);
            this.fillWidget(theme, list);
        };
        WButton createCommands = (WButton)controls.add((WWidget)theme.button("New Commands")).expandX().widget();
        createCommands.action = () -> {
            CommandsRangeAction rangeAction = new CommandsRangeAction();
            rangeActions.add(rangeAction);
            this.fillWidget(theme, list);
        };
        WButton removeAll = (WButton)controls.add((WWidget)theme.button("Remove All Range Actions")).expandX().widget();
        removeAll.action = () -> {
            rangeActions.clear();
            this.fillWidget(theme, list);
        };
        MeteoristConfigManager.configManager(theme, list, this);
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        HashMap<String, Boolean> ignoreFlags = new HashMap<String, Boolean>();
        ignoreFlags.put("ignoreStartBreakingBlock", false);
        ignoreFlags.put("ignoreInteractBlock", false);
        ignoreFlags.put("ignoreAttackEntity", false);
        ignoreFlags.put("ignoreInteractEntity", false);
        boolean shouldSneak = false;
        for (BaseRangeAction rangeAction : rangeActions) {
            for (class_1297 entity : this.mc.field_1687.method_18112()) {
                if (entity == this.mc.field_1724 || !((Set)rangeAction.entities.get()).contains(entity.method_5864()) || ((Boolean)rangeAction.ignoreFriends.get()).booleanValue() && entity instanceof class_1657 && Friends.get().isFriend((class_1657)entity) || ((Boolean)rangeAction.ignoreBabies.get()).booleanValue() && entity instanceof class_1429 && ((class_1429)entity).method_6109() || ((Boolean)rangeAction.ignoreNamed.get()).booleanValue() && entity.method_16914() || ((Boolean)rangeAction.ignorePassive.get()).booleanValue() && this.isPassive(entity) || ((Boolean)rangeAction.ignoreTamed.get()).booleanValue() && entity instanceof class_1321 && ((class_1321)entity).method_6139() != null && ((class_1321)entity).method_6139().equals(this.mc.field_1724.method_5667())) continue;
                double distance = this.mc.field_1724.method_5739(entity);
                if (distance >= (Double)rangeAction.rangeFrom.get() && distance <= (Double)rangeAction.rangeTo.get()) {
                    BaseRangeAction baseRangeAction;
                    Objects.requireNonNull(rangeAction);
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InteractionRangeAction.class, DespawnerRangeAction.class, CommandsRangeAction.class}, (Object)baseRangeAction, n)) {
                        case 0: {
                            InteractionRangeAction interactionAction = (InteractionRangeAction)baseRangeAction;
                            if (((Boolean)interactionAction.ignoreStartBreakingBlock.get()).booleanValue()) {
                                ignoreFlags.put("ignoreStartBreakingBlock", true);
                            }
                            if (((Boolean)interactionAction.ignoreInteractBlock.get()).booleanValue()) {
                                ignoreFlags.put("ignoreInteractBlock", true);
                            }
                            if (((Boolean)interactionAction.ignoreAttackEntity.get()).booleanValue()) {
                                ignoreFlags.put("ignoreAttackEntity", true);
                            }
                            if (((Boolean)interactionAction.ignoreInteractEntity.get()).booleanValue()) {
                                ignoreFlags.put("ignoreInteractEntity", true);
                            }
                            if (!((Boolean)interactionAction.enableSneak.get()).booleanValue()) break;
                            shouldSneak = true;
                            break;
                        }
                        case 1: {
                            DespawnerRangeAction despawnerAction = (DespawnerRangeAction)baseRangeAction;
                            if (((Boolean)despawnerAction.checkRoof.get()).booleanValue() && !this.mc.field_1687.method_8311(this.mc.field_1724.method_24515().method_10084())) break;
                            this.mc.field_1724.method_18799(this.mc.field_1724.method_18798().method_1031(0.0, ((Double)despawnerAction.upVelocity.get()).doubleValue(), 0.0));
                            break;
                        }
                        case 2: {
                            CommandsRangeAction commandsAction = (CommandsRangeAction)baseRangeAction;
                            int delay = (Integer)commandsAction.delay.get();
                            int commandsPerTick = (Integer)commandsAction.commandsPerTick.get();
                            this.commandDelayTimers.putIfAbsent(commandsAction, 0);
                            this.commandIndex.putIfAbsent(commandsAction, 0);
                            int timer = this.commandDelayTimers.get(commandsAction);
                            int index = this.commandIndex.get(commandsAction);
                            if (timer >= delay) {
                                for (int i = 0; i < commandsPerTick && index < ((List)commandsAction.commands.get()).size(); ++index, ++i) {
                                    ChatUtils.sendPlayerMsg((String)((String)((List)commandsAction.commands.get()).get(index)));
                                }
                                this.commandIndex.put(commandsAction, index);
                                this.commandDelayTimers.put(commandsAction, 0);
                            } else {
                                this.commandDelayTimers.put(commandsAction, timer + 1);
                            }
                            if (index < ((List)commandsAction.commands.get()).size()) break;
                            this.commandIndex.put(commandsAction, 0);
                            break;
                        }
                    }
                }
            }
        }
        if (shouldSneak) {
            this.mc.field_1690.field_1832.method_23481(true);
        }
        this.ignoreFlags = ignoreFlags;
    }

    private boolean isPassive(class_1297 entity) {
        return entity instanceof class_1560 && !((class_1560)entity).method_7028() || entity instanceof class_1590 && !((class_1590)entity).method_6510() || entity instanceof class_1493 && !((class_1493)entity).method_6510();
    }

    @EventHandler(priority=100)
    private void onStartBreakingBlockEvent(StartBreakingBlockEvent event) {
        if (this.ignoreFlags.getOrDefault("ignoreStartBreakingBlock", false).booleanValue()) {
            event.cancel();
        }
    }

    @EventHandler
    private void onInteractBlock(InteractBlockEvent event) {
        if (this.ignoreFlags.getOrDefault("ignoreInteractBlock", false).booleanValue()) {
            event.cancel();
        }
    }

    @EventHandler(priority=100)
    private void onAttackEntity(AttackEntityEvent event) {
        if (this.ignoreFlags.getOrDefault("ignoreAttackEntity", false).booleanValue()) {
            event.cancel();
        }
    }

    @EventHandler
    private void onInteractEntity(InteractEntityEvent event) {
        if (this.ignoreFlags.getOrDefault("ignoreInteractEntity", false).booleanValue()) {
            event.cancel();
        }
    }
}

