/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.modules.slotclick;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import meteordevelopment.meteorclient.events.game.GameJoinedEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WContainer;
import meteordevelopment.meteorclient.gui.widgets.containers.WTable;
import meteordevelopment.meteorclient.gui.widgets.containers.WVerticalList;
import meteordevelopment.meteorclient.gui.widgets.input.WIntEdit;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.gui.widgets.pressable.WMinus;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_2203;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_7225;
import zgoly.meteorist.Meteorist;
import zgoly.meteorist.gui.screens.SlotSelectionScreen;
import zgoly.meteorist.modules.slotclick.SelectionFactory;
import zgoly.meteorist.modules.slotclick.selections.BaseSlotSelection;
import zgoly.meteorist.modules.slotclick.selections.DefaultSlotSelection;
import zgoly.meteorist.modules.slotclick.selections.DelaySelection;
import zgoly.meteorist.modules.slotclick.selections.SingleSlotSelection;
import zgoly.meteorist.modules.slotclick.selections.SlotRangeSelection;
import zgoly.meteorist.modules.slotclick.selections.SwapSlotSelection;
import zgoly.meteorist.utils.config.MeteoristConfigManager;

public class SlotClick
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Boolean> disableAfterIteration;
    private final Setting<Boolean> printDebugInfo;
    public static List<BaseSlotSelection> slotSelections = new ArrayList<BaseSlotSelection>();
    private final SelectionFactory factory;
    private int startTick;

    public SlotClick() {
        super(Meteorist.CATEGORY, "slot-click", "Module that automates clicking on slots.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.disableAfterIteration = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("disable-after-iteration")).description("Disables the module after one iteration.")).defaultValue((Object)false)).build());
        this.printDebugInfo = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("print-debug-info")).description("Prints debug information.")).defaultValue((Object)false)).build());
        this.factory = new SelectionFactory();
        this.startTick = -1;
    }

    public static List<Integer> createList(int start, int end) {
        List<Integer> list = IntStream.rangeClosed(Math.min(start, end), Math.max(start, end)).boxed().toList();
        return start > end ? list.reversed() : list;
    }

    public class_2487 toTag() {
        class_2487 tag = super.toTag();
        class_2499 list = new class_2499();
        for (BaseSlotSelection slotSelection : slotSelections) {
            class_2487 mTag = new class_2487();
            mTag.method_10582("type", slotSelection.getTypeName());
            mTag.method_10566("slotSelection", (class_2520)slotSelection.toTag());
            list.add((Object)mTag);
        }
        tag.method_10566("slotSelections", (class_2520)list);
        return tag;
    }

    public Module fromTag(class_2487 tag) {
        super.fromTag(tag);
        slotSelections.clear();
        class_2499 list = tag.method_10554("slotSelections", 10);
        for (class_2520 tagII : list) {
            class_2487 tagI = (class_2487)tagII;
            String type = tagI.method_10558("type");
            BaseSlotSelection slotSelection = this.factory.createSelection(type);
            if (slotSelection == null) continue;
            class_2487 slotSelectionTag = tagI.method_10562("slotSelection");
            if (slotSelectionTag != null) {
                slotSelection.fromTag(slotSelectionTag);
            }
            slotSelections.add(slotSelection);
        }
        return this;
    }

    public void onDeactivate() {
        this.startTick = -1;
    }

    @EventHandler
    private void onGameJoined(GameJoinedEvent event) {
        this.startTick = -1;
    }

    public WWidget getWidget(GuiTheme theme) {
        WVerticalList list = theme.verticalList();
        this.fillWidget(theme, list);
        return list;
    }

    public void fillWidget(GuiTheme theme, WVerticalList list) {
        list.clear();
        WTable table = (WTable)list.add((WWidget)theme.table()).expandX().widget();
        for (BaseSlotSelection slotSelection : slotSelections) {
            BaseSlotSelection baseSlotSelection;
            table.add((WWidget)theme.label(slotSelection.getTypeName())).expandX().widget();
            WContainer infoContainer = (WContainer)table.add((WWidget)theme.horizontalList()).expandX().widget();
            Objects.requireNonNull(slotSelection);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SingleSlotSelection.class, SlotRangeSelection.class, SwapSlotSelection.class, DelaySelection.class}, (Object)baseSlotSelection, n)) {
                case 0: {
                    SingleSlotSelection singleSlotSelection = (SingleSlotSelection)baseSlotSelection;
                    WIntEdit slot = (WIntEdit)infoContainer.add((WWidget)theme.intEdit(((Integer)singleSlotSelection.slot.get()).intValue(), 0, Integer.MAX_VALUE, true)).widget();
                    slot.tooltip = singleSlotSelection.slot.description;
                    slot.actionOnRelease = () -> singleSlotSelection.slot.set((Object)slot.get());
                    break;
                }
                case 1: {
                    SlotRangeSelection slotRangeSelection = (SlotRangeSelection)baseSlotSelection;
                    WIntEdit fromSlot = (WIntEdit)infoContainer.add((WWidget)theme.intEdit(((Integer)slotRangeSelection.fromSlot.get()).intValue(), 0, Integer.MAX_VALUE, true)).widget();
                    fromSlot.tooltip = slotRangeSelection.fromSlot.description;
                    fromSlot.actionOnRelease = () -> slotRangeSelection.fromSlot.set((Object)fromSlot.get());
                    WIntEdit toSlot = (WIntEdit)infoContainer.add((WWidget)theme.intEdit(((Integer)slotRangeSelection.toSlot.get()).intValue(), 0, Integer.MAX_VALUE, true)).widget();
                    toSlot.tooltip = slotRangeSelection.toSlot.description;
                    toSlot.actionOnRelease = () -> slotRangeSelection.toSlot.set((Object)toSlot.get());
                    break;
                }
                case 2: {
                    SwapSlotSelection swapSlotSelection = (SwapSlotSelection)baseSlotSelection;
                    WIntEdit fromSlot = (WIntEdit)infoContainer.add((WWidget)theme.intEdit(((Integer)swapSlotSelection.fromSlot.get()).intValue(), 0, Integer.MAX_VALUE, true)).widget();
                    fromSlot.tooltip = swapSlotSelection.fromSlot.description;
                    fromSlot.actionOnRelease = () -> swapSlotSelection.fromSlot.set((Object)fromSlot.get());
                    WIntEdit toSlot = (WIntEdit)infoContainer.add((WWidget)theme.intEdit(((Integer)swapSlotSelection.toSlot.get()).intValue(), 0, Integer.MAX_VALUE, true)).widget();
                    toSlot.tooltip = swapSlotSelection.toSlot.description;
                    toSlot.actionOnRelease = () -> swapSlotSelection.toSlot.set((Object)toSlot.get());
                    break;
                }
                case 3: {
                    DelaySelection delaySelection = (DelaySelection)baseSlotSelection;
                    WIntEdit delay = (WIntEdit)infoContainer.add((WWidget)theme.intEdit(((Integer)delaySelection.delay.get()).intValue(), 0, Integer.MAX_VALUE, true)).widget();
                    delay.tooltip = delaySelection.delay.description;
                    delay.actionOnRelease = () -> delaySelection.delay.set((Object)delay.get());
                    break;
                }
            }
            WButton edit = (WButton)table.add((WWidget)theme.button("Edit")).expandX().widget();
            edit.tooltip = "Edit the slot selection.";
            edit.action = () -> this.mc.method_1507((class_437)new SlotSelectionScreen(theme, slotSelection));
            WContainer moveContainer = (WContainer)table.add((WWidget)theme.horizontalList()).expandX().widget();
            if (slotSelections.size() > 1) {
                int index = slotSelections.indexOf(slotSelection);
                if (index > 0) {
                    WButton moveUp = (WButton)moveContainer.add((WWidget)theme.button(Meteorist.ARROW_UP)).expandX().widget();
                    moveUp.tooltip = "Move slot selection up.";
                    moveUp.action = () -> {
                        slotSelections.remove(index);
                        slotSelections.add(index - 1, slotSelection);
                        this.fillWidget(theme, list);
                    };
                }
                if (index < slotSelections.size() - 1) {
                    WButton moveDown = (WButton)moveContainer.add((WWidget)theme.button(Meteorist.ARROW_DOWN)).expandX().widget();
                    moveDown.tooltip = "Move slot selection down.";
                    moveDown.action = () -> {
                        slotSelections.remove(index);
                        slotSelections.add(index + 1, slotSelection);
                        this.fillWidget(theme, list);
                    };
                }
            }
            WButton copy = (WButton)table.add((WWidget)theme.button(Meteorist.COPY)).widget();
            copy.tooltip = "Copy slot selection.";
            copy.action = () -> {
                slotSelections.add(slotSelections.indexOf(slotSelection), slotSelection.copy());
                this.fillWidget(theme, list);
            };
            WMinus remove = (WMinus)table.add((WWidget)theme.minus()).widget();
            remove.tooltip = "Remove slot selection.";
            remove.action = () -> {
                slotSelections.remove(slotSelection);
                this.fillWidget(theme, list);
            };
            table.row();
        }
        list.add((WWidget)theme.horizontalSeparator()).expandX();
        WTable controls = (WTable)list.add((WWidget)theme.table()).expandX().widget();
        WButton createSingleSlotSelection = (WButton)controls.add((WWidget)theme.button("New Single")).widget();
        createSingleSlotSelection.action = () -> {
            slotSelections.add(new SingleSlotSelection());
            this.fillWidget(theme, list);
        };
        WButton createSlotRangeSelection = (WButton)controls.add((WWidget)theme.button("New Range")).widget();
        createSlotRangeSelection.action = () -> {
            slotSelections.add(new SlotRangeSelection());
            this.fillWidget(theme, list);
        };
        WButton createSwapSlotSelection = (WButton)controls.add((WWidget)theme.button("New Swap")).widget();
        createSwapSlotSelection.action = () -> {
            slotSelections.add(new SwapSlotSelection());
            this.fillWidget(theme, list);
        };
        WButton createDelaySelection = (WButton)controls.add((WWidget)theme.button("New Delay")).widget();
        createDelaySelection.action = () -> {
            slotSelections.add(new DelaySelection());
            this.fillWidget(theme, list);
        };
        WButton removeAll = (WButton)controls.add((WWidget)theme.button("Remove All Selections")).widget();
        removeAll.action = () -> {
            slotSelections.clear();
            this.fillWidget(theme, list);
        };
        MeteoristConfigManager.configManager(theme, list, this);
    }

    @EventHandler
    public void onTick(TickEvent.Pre event) {
        int currentTick = (int)this.mc.field_1687.method_8510();
        if (this.startTick == -1) {
            this.startTick = currentTick;
        }
        HashMap<Integer, List> map = new HashMap<Integer, List>();
        int tick = 0;
        for (BaseSlotSelection baseSlotSelection : slotSelections) {
            if (baseSlotSelection instanceof DelaySelection) {
                DelaySelection delaySelection = (DelaySelection)baseSlotSelection;
                tick += ((Integer)delaySelection.delay.get()).intValue();
                continue;
            }
            if (baseSlotSelection instanceof SingleSlotSelection || baseSlotSelection instanceof SwapSlotSelection) {
                map.computeIfAbsent(tick, ArrayList::new).add(baseSlotSelection);
                continue;
            }
            if (!(baseSlotSelection instanceof SlotRangeSelection)) continue;
            SlotRangeSelection slotRangeSelection = (SlotRangeSelection)baseSlotSelection;
            List<Integer> slots = SlotClick.createList((Integer)slotRangeSelection.fromSlot.get(), (Integer)slotRangeSelection.toSlot.get());
            for (int slot : slots) {
                SlotRangeSelection copy = slotRangeSelection.copy();
                copy.calculatedSlot = slot;
                map.computeIfAbsent(tick, ArrayList::new).add(copy);
                if (slots.indexOf(slot) >= slots.size() - 1) continue;
                tick += ((Integer)copy.delay.get()).intValue();
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            if (this.startTick + (Integer)entry.getKey() != currentTick) continue;
            for (BaseSlotSelection baseSlotSelection : (List)entry.getValue()) {
                int checkScreenName;
                String screenName;
                class_1703 screenHandler;
                DefaultSlotSelection defaultSlotSelection;
                block43: {
                    class_437 screen;
                    block42: {
                        if (!(baseSlotSelection instanceof DefaultSlotSelection)) continue;
                        defaultSlotSelection = (DefaultSlotSelection)baseSlotSelection;
                        this.printInfo("Slot selection: " + defaultSlotSelection.getTypeName());
                        screen = this.mc.field_1755;
                        screenHandler = this.mc.field_1724.field_7512;
                        if (((Boolean)defaultSlotSelection.checkContainerType.get()).booleanValue()) {
                            this.printInfo("Checking container type...");
                            try {
                                boolean containerTypeMatched;
                                if (defaultSlotSelection.containerTypeMode.get() == DefaultSlotSelection.ContainerTypeMode.Whitelist) {
                                    containerTypeMatched = ((List)defaultSlotSelection.containerType.get()).contains(screenHandler.method_17358());
                                } else {
                                    boolean bl = containerTypeMatched = !((List)defaultSlotSelection.containerType.get()).contains(screenHandler.method_17358());
                                }
                                if (containerTypeMatched) {
                                    this.printInfo("Container type matched!");
                                    break block42;
                                }
                                this.printWarning("Container type not matched!");
                            }
                            catch (Exception e) {
                                this.printError(e.getMessage());
                                if (((Boolean)defaultSlotSelection.ignoreMenuTypeMismatch.get()).booleanValue()) break block42;
                            }
                            continue;
                        }
                    }
                    if (((Boolean)defaultSlotSelection.checkScreenName.get()).booleanValue()) {
                        this.printInfo("Checking screen name...");
                        try {
                            Pattern screenNamePattern = Pattern.compile((String)defaultSlotSelection.screenName.get());
                            screenName = screen != null ? screen.method_25440().getString() : "null";
                            this.printInfo("Screen name: " + (String)screenName);
                            this.printInfo("Regular expression: " + screenNamePattern.pattern());
                            checkScreenName = screenNamePattern.matcher(screenName).find() ? 1 : 0;
                            if (checkScreenName != 0) {
                                this.printInfo("Screen name matched!");
                                break block43;
                            }
                            this.printWarning("Screen name not matched!");
                            continue;
                        }
                        catch (Exception e) {
                            this.printError(e.getMessage());
                        }
                    }
                }
                if (((Boolean)defaultSlotSelection.checkSlotItemData.get()).booleanValue()) {
                    this.printInfo("Checking slot item data...");
                    int slot = 0;
                    Objects.requireNonNull(defaultSlotSelection);
                    checkScreenName = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SingleSlotSelection.class, SwapSlotSelection.class, SlotRangeSelection.class}, (Object)screenName, checkScreenName)) {
                        case 0: {
                            SingleSlotSelection singleSlotSelection = (SingleSlotSelection)((Object)screenName);
                            slot = (Integer)singleSlotSelection.slot.get();
                            break;
                        }
                        case 1: {
                            SwapSlotSelection swapSlotSelection = (SwapSlotSelection)((Object)screenName);
                            slot = (Integer)swapSlotSelection.fromSlot.get();
                            break;
                        }
                        case 2: {
                            SlotRangeSelection slotRangeSelection = (SlotRangeSelection)((Object)screenName);
                            slot = slotRangeSelection.calculatedSlot;
                            break;
                        }
                    }
                    try {
                        class_1799 itemStack = screenHandler.method_7611(slot).method_7677();
                        if (!itemStack.method_7960()) {
                            boolean isAnyMatch;
                            class_2520 element = itemStack.method_57358((class_7225.class_7874)this.mc.field_1724.method_56673());
                            this.printInfo("Item data: " + element.method_10714());
                            boolean matchedAny = false;
                            boolean matchedAll = true;
                            for (class_3545 pair : (List)defaultSlotSelection.slotItemData.get()) {
                                try {
                                    String value = ((class_2520)class_2203.class_2209.method_58472((String)((String)pair.method_15442())).method_9366(element).getFirst()).method_10714();
                                    Pattern pattern = Pattern.compile((String)pair.method_15441());
                                    this.printInfo("Element: " + value);
                                    this.printInfo("Pattern: " + pattern.pattern());
                                    if (pattern.matcher(value).find()) {
                                        matchedAny = true;
                                        this.printInfo("Matched!");
                                        continue;
                                    }
                                    matchedAll = false;
                                    this.printWarning("Not matched!");
                                }
                                catch (Exception e) {
                                    this.printError(e.getMessage());
                                }
                            }
                            boolean bl = isAnyMatch = defaultSlotSelection.slotItemMatchMode.get() == DefaultSlotSelection.SlotItemMatchMode.Any;
                            if (!(isAnyMatch && matchedAny || !isAnyMatch && matchedAll)) {
                                continue;
                            }
                        } else {
                            this.printWarning("There is no item in the slot " + slot + "!");
                        }
                    }
                    catch (Exception e) {
                        this.printError(e.getMessage());
                    }
                }
                if (this.mc.field_1761 == null || screenHandler == null) continue;
                try {
                    DefaultSlotSelection slot;
                    Objects.requireNonNull(defaultSlotSelection);
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SingleSlotSelection.class, SwapSlotSelection.class, SlotRangeSelection.class}, (Object)slot, n)) {
                        case 0: {
                            SingleSlotSelection singleSlotSelection = (SingleSlotSelection)slot;
                            this.mc.field_1761.method_2906(screenHandler.field_7763, ((Integer)singleSlotSelection.slot.get()).intValue(), ((Integer)singleSlotSelection.button.get()).intValue(), (class_1713)singleSlotSelection.action.get(), (class_1657)this.mc.field_1724);
                            break;
                        }
                        case 1: {
                            SwapSlotSelection swapSlotSelection = (SwapSlotSelection)slot;
                            this.mc.field_1761.method_2906(screenHandler.field_7763, ((Integer)swapSlotSelection.fromSlot.get()).intValue(), 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
                            this.mc.field_1761.method_2906(screenHandler.field_7763, ((Integer)swapSlotSelection.toSlot.get()).intValue(), 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
                            break;
                        }
                        case 2: {
                            SlotRangeSelection slotRangeSelection = (SlotRangeSelection)slot;
                            this.mc.field_1761.method_2906(screenHandler.field_7763, slotRangeSelection.calculatedSlot, ((Integer)slotRangeSelection.button.get()).intValue(), (class_1713)slotRangeSelection.action.get(), (class_1657)this.mc.field_1724);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    this.printError(e.getMessage());
                }
            }
        }
        if (this.startTick + tick <= currentTick) {
            if (((Boolean)this.disableAfterIteration.get()).booleanValue()) {
                this.toggle();
            } else {
                this.startTick = -1;
            }
        }
    }

    private void printInfo(String message) {
        if (((Boolean)this.printDebugInfo.get()).booleanValue()) {
            this.info(message, new Object[0]);
        }
    }

    private void printWarning(String message) {
        if (((Boolean)this.printDebugInfo.get()).booleanValue()) {
            this.warning(message, new Object[0]);
        }
    }

    private void printError(String message) {
        if (((Boolean)this.printDebugInfo.get()).booleanValue()) {
            this.error(message, new Object[0]);
        }
    }
}

