/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import meteordevelopment.meteorclient.gui.DefaultSettingsWidgetFactory;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WTable;
import meteordevelopment.meteorclient.gui.widgets.input.WTextBox;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.gui.widgets.pressable.WMinus;
import meteordevelopment.meteorclient.gui.widgets.pressable.WPlus;
import meteordevelopment.meteorclient.settings.IVisible;
import meteordevelopment.meteorclient.settings.Setting;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3545;
import zgoly.meteorist.Meteorist;

public class StringPairSetting
extends Setting<List<class_3545<String, String>>> {
    private final class_3545<String, String> placeholder;

    public StringPairSetting(String name, String description, List<class_3545<String, String>> defaultValue, class_3545<String, String> placeholder, Consumer<List<class_3545<String, String>>> onChanged, Consumer<Setting<List<class_3545<String, String>>>> onModuleActivated, IVisible visible) {
        super(name, description, defaultValue, onChanged, onModuleActivated, visible);
        this.placeholder = placeholder;
    }

    public static void register() {
        DefaultSettingsWidgetFactory.registerCustomFactory(StringPairSetting.class, theme -> (table, setting) -> {
            WTable wtable = (WTable)table.add((WWidget)theme.table()).expandX().widget();
            StringPairSetting.fillTable(theme, wtable, (StringPairSetting)setting);
        });
    }

    public static void fillTable(GuiTheme theme, WTable table, StringPairSetting setting) {
        table.clear();
        List pairs = (List)setting.get();
        class_3545<String, String> placeholder = setting.placeholder;
        for (class_3545 pair : pairs) {
            WTextBox textBoxK = (WTextBox)table.add((WWidget)theme.textBox((String)pair.method_15442(), (String)placeholder.method_15442())).minWidth(150.0).expandX().widget();
            textBoxK.actionOnUnfocused = () -> pair.method_34964((Object)textBoxK.get());
            WTextBox textBoxV = (WTextBox)table.add((WWidget)theme.textBox((String)pair.method_15441(), (String)placeholder.method_15441())).minWidth(150.0).expandX().widget();
            textBoxV.actionOnUnfocused = () -> pair.method_34965((Object)textBoxV.get());
            WButton copy = (WButton)table.add((WWidget)theme.button(Meteorist.COPY)).widget();
            copy.action = () -> {
                pairs.add(pairs.indexOf(pair), new class_3545((Object)((String)pair.method_15442()), (Object)((String)pair.method_15441())));
                StringPairSetting.fillTable(theme, table, setting);
            };
            WMinus delete = (WMinus)table.add((WWidget)theme.minus()).widget();
            delete.action = () -> {
                pairs.remove(pair);
                StringPairSetting.fillTable(theme, table, setting);
            };
            table.row();
        }
        if (!pairs.isEmpty()) {
            table.add((WWidget)theme.horizontalSeparator()).expandX();
            table.row();
        }
        WButton reset = (WButton)table.add((WWidget)theme.button(GuiRenderer.RESET)).widget();
        reset.action = () -> {
            setting.reset();
            StringPairSetting.fillTable(theme, table, setting);
        };
        WPlus add = (WPlus)table.add((WWidget)theme.plus()).widget();
        add.action = () -> {
            pairs.add(new class_3545((Object)"", (Object)""));
            StringPairSetting.fillTable(theme, table, setting);
        };
        table.row();
    }

    protected List<class_3545<String, String>> parseImpl(String str) {
        String[] values = str.split(",");
        ArrayList<class_3545<String, String>> pairs = new ArrayList<class_3545<String, String>>(values.length / 2);
        try {
            for (int i = 0; i < values.length; i += 2) {
                pairs.add((class_3545<String, String>)new class_3545((Object)values[i], (Object)values[i + 1]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pairs;
    }

    protected boolean isValueValid(List<class_3545<String, String>> value) {
        return true;
    }

    protected void resetImpl() {
        this.value = new ArrayList((Collection)this.defaultValue);
    }

    protected class_2487 save(class_2487 tag) {
        class_2499 valueTag = new class_2499();
        for (class_3545 pair : (List)this.get()) {
            class_2487 pairTag = new class_2487();
            pairTag.method_10582("left", (String)pair.method_15442());
            pairTag.method_10582("right", (String)pair.method_15441());
            valueTag.add((Object)pairTag);
        }
        tag.method_10566("pairs", (class_2520)valueTag);
        return tag;
    }

    protected List<class_3545<String, String>> load(class_2487 tag) {
        ((List)this.get()).clear();
        class_2499 valueTag = tag.method_10554("pairs", 10);
        for (int i = 0; i < valueTag.size(); ++i) {
            class_2487 pairTag = valueTag.method_10602(i);
            ((List)this.get()).add(new class_3545((Object)pairTag.method_10558("left"), (Object)pairTag.method_10558("right")));
        }
        return (List)this.get();
    }

    public static class Builder
    extends Setting.SettingBuilder<Builder, List<class_3545<String, String>>, StringPairSetting> {
        private class_3545<String, String> placeholder;

        public Builder() {
            super(new ArrayList(0));
        }

        public Builder defaultValue(List<class_3545<String, String>> pairs) {
            this.defaultValue = pairs;
            return this;
        }

        public Builder placeholder(class_3545<String, String> pair) {
            this.placeholder = pair;
            return this;
        }

        public StringPairSetting build() {
            return new StringPairSetting(this.name, this.description, (List)this.defaultValue, this.placeholder, this.onChanged, this.onModuleActivated, this.visible);
        }
    }
}

