/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import meteordevelopment.meteorclient.utils.misc.MeteorStarscript;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.starscript.Script;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import zgoly.meteorist.modules.instructions.InstructionFactory;
import zgoly.meteorist.modules.instructions.instructions.BaseInstruction;
import zgoly.meteorist.modules.instructions.instructions.CommandInstruction;
import zgoly.meteorist.modules.instructions.instructions.DelayInstruction;

public class InstructionUtils {
    public static List<BaseInstruction> readInstructionsFromTag(class_2487 tag, InstructionFactory factory) {
        ArrayList<BaseInstruction> instructions = new ArrayList<BaseInstruction>();
        class_2499 list = tag.method_10554("instructions", 10);
        for (class_2520 tagII : list) {
            class_2487 tagI = (class_2487)tagII;
            String type = tagI.method_10558("type");
            BaseInstruction instruction = factory.createInstruction(type);
            if (instruction == null) continue;
            class_2487 instructionTag = tagI.method_10562("instruction");
            if (instructionTag != null) {
                instruction.fromTag(instructionTag);
            }
            instructions.add(instruction);
        }
        return instructions;
    }

    public static int processInstructions(List<BaseInstruction> instructions, Map<Integer, List<String>> map) {
        return InstructionUtils.processInstructions(instructions, map, 0);
    }

    public static int processInstructions(List<BaseInstruction> instructions, Map<Integer, List<String>> map, int tick) {
        for (BaseInstruction instruction : instructions) {
            if (instruction instanceof DelayInstruction) {
                DelayInstruction delayInstruction = (DelayInstruction)instruction;
                tick += ((Integer)delayInstruction.delay.get()).intValue();
                continue;
            }
            if (!(instruction instanceof CommandInstruction)) continue;
            CommandInstruction commandInstruction = (CommandInstruction)instruction;
            for (int i = 0; i < (Integer)commandInstruction.runCount.get(); ++i) {
                map.computeIfAbsent(tick, ArrayList::new).add((String)commandInstruction.command.get());
                if (i >= (Integer)commandInstruction.runCount.get() - 1) continue;
                tick += ((Integer)commandInstruction.delayBetweenRuns.get()).intValue();
            }
        }
        return tick;
    }

    public static void executeCommands(Map<Integer, List<String>> map, int currentTick) {
        InstructionUtils.executeCommands(map, currentTick, 0);
    }

    public static void executeCommands(Map<Integer, List<String>> map, int currentTick, int startTick) {
        for (Map.Entry<Integer, List<String>> entry : map.entrySet()) {
            if (startTick + entry.getKey() != currentTick) continue;
            for (String command : entry.getValue()) {
                Script script = MeteorStarscript.compile((String)command);
                if (script == null) continue;
                ChatUtils.sendPlayerMsg((String)MeteorStarscript.run((Script)script));
            }
        }
    }
}

