/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.utils.baritone;

import baritone.api.BaritoneAPI;
import baritone.api.IBaritone;
import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.goals.GoalComposite;
import baritone.api.pathing.goals.GoalNear;
import java.util.List;
import meteordevelopment.meteorclient.pathing.BaritoneUtils;
import net.minecraft.class_1297;
import net.minecraft.class_2338;

public class MeteoristBaritoneUtils {
    BaritoneOperations baritoneOperations = BaritoneUtils.IS_AVAILABLE ? new BasedBaritoneOperations() : new NoBaritoneOperations();

    public void cancelEverything() {
        this.baritoneOperations.cancelEverything();
    }

    public boolean isPathing() {
        return this.baritoneOperations.isPathing();
    }

    public void setGoalNear(class_2338 blockPos, int range) {
        this.baritoneOperations.setGoalNear(blockPos, range);
    }

    public void setGoalNear(List<class_1297> entities, int range) {
        this.baritoneOperations.setGoalNear(entities, range);
    }

    public static class BasedBaritoneOperations
    implements BaritoneOperations {
        private final IBaritone baritone = BaritoneAPI.getProvider().getPrimaryBaritone();

        @Override
        public void cancelEverything() {
            this.baritone.getPathingBehavior().cancelEverything();
        }

        @Override
        public boolean isPathing() {
            return this.baritone.getPathingBehavior().isPathing();
        }

        @Override
        public void setGoalNear(class_2338 blockPos, int range) {
            this.baritone.getCustomGoalProcess().setGoalAndPath((Goal)new GoalNear(blockPos, range));
        }

        @Override
        public void setGoalNear(List<class_1297> entities, int range) {
            this.baritone.getCustomGoalProcess().setGoalAndPath((Goal)new GoalComposite((Goal[])entities.stream().map(entity -> new GoalNear(entity.method_24515(), range)).toArray(Goal[]::new)));
        }
    }

    public static interface BaritoneOperations {
        public void cancelEverything();

        public boolean isPathing();

        public void setGoalNear(class_2338 var1, int var2);

        public void setGoalNear(List<class_1297> var1, int var2);
    }

    public static class NoBaritoneOperations
    implements BaritoneOperations {
        @Override
        public void cancelEverything() {
        }

        @Override
        public boolean isPathing() {
            return false;
        }

        @Override
        public void setGoalNear(class_2338 blockPos, int range) {
        }

        @Override
        public void setGoalNear(List<class_1297> entities, int range) {
        }
    }
}

