/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.utils.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.WidgetScreen;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WHorizontalList;
import meteordevelopment.meteorclient.gui.widgets.containers.WSection;
import meteordevelopment.meteorclient.gui.widgets.containers.WTable;
import meteordevelopment.meteorclient.gui.widgets.containers.WVerticalList;
import meteordevelopment.meteorclient.gui.widgets.input.WTextBox;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.gui.widgets.pressable.WMinus;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.misc.Keybind;
import meteordevelopment.meteorclient.utils.render.prompts.YesNoPrompt;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_437;
import zgoly.meteorist.Meteorist;
import zgoly.meteorist.utils.MeteoristUtils;

public class MeteoristConfigManager {
    public static void reload(boolean fromPrompt) {
        class_437 class_4372 = MeteorClient.mc.field_1755;
        if (class_4372 instanceof WidgetScreen) {
            WidgetScreen screen = (WidgetScreen)class_4372;
            if (fromPrompt) {
                class_437 class_4373 = screen.parent;
                if (class_4373 instanceof WidgetScreen) {
                    WidgetScreen screen1 = (WidgetScreen)class_4373;
                    screen1.reload();
                }
            } else {
                screen.reload();
            }
        }
    }

    public static File getFolderPath(Module module) {
        return new File(Paths.get(FabricLoader.getInstance().getGameDir().toString(), Meteorist.MOD_ID, MeteoristUtils.removeInvalidChars(module.name)).toString());
    }

    public static void configManager(GuiTheme theme, WVerticalList list, Module module) {
        File folderPath = MeteoristConfigManager.getFolderPath(module);
        WSection configSection = (WSection)list.add((WWidget)theme.section("Config Manager")).expandX().widget();
        WTable control = (WTable)configSection.add((WWidget)theme.table()).expandX().widget();
        WTable configTable = (WTable)control.add((WWidget)theme.table()).expandX().widget();
        MeteoristConfigManager.fillConfigTable(theme, module, folderPath, configTable);
        control.row();
        WHorizontalList buttons = (WHorizontalList)control.add((WWidget)theme.horizontalList()).expandX().widget();
        WButton reloadButton = (WButton)buttons.add((WWidget)theme.button("Reload")).expandX().widget();
        reloadButton.action = () -> {
            configTable.clear();
            MeteoristConfigManager.fillConfigTable(theme, module, folderPath, configTable);
        };
        WButton openFolder = (WButton)buttons.add((WWidget)theme.button("Open Folder")).expandX().widget();
        openFolder.action = () -> {
            if (!folderPath.exists()) {
                folderPath.mkdirs();
            }
            class_156.method_668().method_672(folderPath);
        };
        control.row();
        control.add((WWidget)theme.horizontalSeparator()).expandX().widget();
        control.row();
        WTextBox textBox = (WTextBox)control.add((WWidget)theme.textBox("", "Config Name")).expandX().widget();
        WButton save = (WButton)control.add((WWidget)theme.button("Save")).widget();
        save.action = () -> {
            if (!folderPath.exists()) {
                folderPath.mkdirs();
            }
            File file = new File(folderPath, textBox.get() + ".nbt");
            MeteoristConfigManager.save(module, file);
        };
    }

    public static class_2487 toTag(Module module) {
        class_2487 nbtCompound = module.toTag();
        nbtCompound.method_10551("name");
        nbtCompound.method_10551("keybind");
        nbtCompound.method_10551("toggleOnKeyRelease");
        nbtCompound.method_10551("chatFeedback");
        nbtCompound.method_10551("favorite");
        nbtCompound.method_10551("active");
        return nbtCompound;
    }

    public static void fromTag(Module module, class_2487 nbtCompound) {
        Keybind keybind = module.keybind.copy();
        boolean toggleOnBindRelease = module.toggleOnBindRelease;
        boolean chatFeedback = module.chatFeedback;
        boolean favorite = module.favorite;
        boolean isActive = module.isActive();
        module.fromTag(nbtCompound);
        if (module.keybind != keybind) {
            module.keybind.set(keybind);
        }
        if (module.toggleOnBindRelease != toggleOnBindRelease) {
            module.toggleOnBindRelease = toggleOnBindRelease;
        }
        if (module.chatFeedback != chatFeedback) {
            module.chatFeedback = chatFeedback;
        }
        if (module.favorite != favorite) {
            module.favorite = favorite;
        }
        if (module.isActive() != isActive) {
            module.toggle();
        }
    }

    private static void fillConfigTable(GuiTheme theme, Module module, File folderPath, WTable configTable) {
        if (folderPath.exists()) {
            Arrays.stream(folderPath.listFiles()).filter(file -> file.getName().endsWith(".nbt")).forEach(file -> {
                configTable.add((WWidget)theme.label(file.getName().replace(".nbt", ""))).expandX().widget();
                WButton save = (WButton)configTable.add((WWidget)theme.button("Save")).widget();
                save.action = () -> MeteoristConfigManager.save(module, file);
                WButton load = (WButton)configTable.add((WWidget)theme.button("Load")).widget();
                load.action = () -> {
                    try (FileInputStream inputStream = new FileInputStream((File)file);){
                        class_2487 nbtCompound = class_2507.method_10629((InputStream)inputStream, (class_2505)class_2505.method_53898());
                        MeteoristConfigManager.fromTag(module, nbtCompound);
                        MeteorClient.mc.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, class_2561.method_30163((String)"Config successfully loaded"), class_2561.method_30163((String)("Loaded as \"" + file.getName() + "\" with " + nbtCompound.method_10546() + " entries."))));
                    }
                    catch (FileNotFoundException e) {
                        MeteorClient.mc.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, class_2561.method_30163((String)"Failed to load config"), class_2561.method_30163((String)"File not found. Did you delete/rename it?")));
                    }
                    catch (Exception e) {
                        MeteorClient.mc.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, class_2561.method_30163((String)"Failed to load config"), class_2561.method_30163((String)e.getMessage())));
                    }
                    MeteoristConfigManager.reload(false);
                };
                WMinus delete = (WMinus)configTable.add((WWidget)theme.minus()).widget();
                delete.action = () -> ((YesNoPrompt)((YesNoPrompt)((YesNoPrompt)YesNoPrompt.create().title("Delete Config")).message("Are you sure you want to delete \"" + file.getName() + "\"? This cannot be undone.")).onYes(() -> {
                    file.delete();
                    MeteoristConfigManager.reload(true);
                }).dontShowAgainCheckboxVisible(false)).show();
                configTable.row();
            });
        }
    }

    private static void save(Module module, File file) {
        MeteoristConfigManager.save(module, file, false);
    }

    private static void save(Module module, File file, boolean overwrite) {
        if (!file.exists() || overwrite) {
            try {
                class_2487 nbtCompound = MeteoristConfigManager.toTag(module);
                FileOutputStream outputStream = new FileOutputStream(file);
                class_2507.method_10634((class_2487)nbtCompound, (OutputStream)outputStream);
                outputStream.close();
                MeteorClient.mc.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, class_2561.method_30163((String)"Config successfully saved"), class_2561.method_30163((String)("Saved as \"" + file.getName() + "\" with " + nbtCompound.method_10546() + " entries."))));
            }
            catch (Exception e) {
                MeteorClient.mc.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, class_2561.method_30163((String)"Failed to save config"), class_2561.method_30163((String)e.getMessage())));
            }
            MeteoristConfigManager.reload(false);
        } else {
            ((YesNoPrompt)((YesNoPrompt)((YesNoPrompt)YesNoPrompt.create().title("Overwrite Config")).message("Are you sure you want to overwrite \"" + file.getName() + "\"? This cannot be undone.")).onYes(() -> MeteoristConfigManager.save(module, file, true)).dontShowAgainCheckboxVisible(false)).show();
        }
    }
}

