/*
 * Decompiled with CFR 0.152.
 */
package zgoly.meteorist.utils.misc;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.orbit.EventHandler;
import zgoly.meteorist.events.TweenEndEvent;

public class TweenHandler {
    private static double currentTime;
    private final List<Tween> tweens = new ArrayList<Tween>();

    @EventHandler
    public void onRender3D(Render3DEvent event) {
        currentTime += event.frameTime;
        Iterator<Tween> iterator = this.tweens.iterator();
        while (iterator.hasNext()) {
            Tween tween = iterator.next();
            tween.update();
            if (!tween.completed) continue;
            iterator.remove();
        }
    }

    public void play(boolean instant, AtomicDouble reference, double endValue, double duration, EasingStyle easingStyle, EasingDirection easingDirection) {
        if (instant) {
            this.stopPreviousTween(reference);
            reference.set(endValue);
        } else {
            this.play(reference, endValue, duration, easingStyle, easingDirection);
        }
    }

    public void play(AtomicDouble reference, double endValue, double duration, EasingStyle easingStyle, EasingDirection easingDirection) {
        this.stopPreviousTween(reference);
        Tween tween = new Tween(reference, endValue, duration, easingStyle, easingDirection);
        this.tweens.add(tween);
    }

    private void stopPreviousTween(AtomicDouble reference) {
        this.tweens.removeIf(tween -> Objects.equals(tween.reference, reference));
    }

    public static class Tween {
        private final AtomicDouble reference;
        private final double startValue;
        private final double endValue;
        private final double duration;
        private final EasingStyle easingStyle;
        private final EasingDirection easingDirection;
        private final double startTime;
        private boolean completed = false;

        public Tween(AtomicDouble reference, double endValue, double duration, EasingStyle easingStyle, EasingDirection easingDirection) {
            this.reference = reference;
            this.startValue = reference.get();
            this.endValue = endValue;
            this.duration = duration;
            this.easingStyle = easingStyle;
            this.easingDirection = easingDirection;
            this.startTime = currentTime;
        }

        public void update() {
            double elapsedTime = currentTime - this.startTime;
            if (elapsedTime < this.duration) {
                double t = elapsedTime / this.duration;
                double easedValue = EasingFunctions.ease(this.easingStyle, this.easingDirection, t);
                this.reference.set(this.startValue + (this.endValue - this.startValue) * easedValue);
            } else {
                this.reference.set(this.endValue);
                MeteorClient.EVENT_BUS.post((Object)new TweenEndEvent());
                this.completed = true;
            }
        }
    }

    public static enum EasingStyle {
        Linear,
        Sine,
        Quad,
        Cubic,
        Quart,
        Quint,
        Expo,
        Circ,
        Back,
        Elastic,
        Bounce;

    }

    public static enum EasingDirection {
        In,
        Out,
        InOut,
        OutIn;

    }

    public static class EasingFunctions {
        public static double ease(EasingStyle easingStyle, EasingDirection easingDirection, double x) {
            return switch (easingDirection.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> EasingFunctions.easeIn(easingStyle, x);
                case 1 -> 1.0 - EasingFunctions.easeIn(easingStyle, 1.0 - x);
                case 2 -> {
                    if (x < 0.5) {
                        yield EasingFunctions.easeIn(easingStyle, 2.0 * x) / 2.0;
                    }
                    yield 1.0 - EasingFunctions.easeIn(easingStyle, 2.0 * (1.0 - x)) / 2.0;
                }
                case 3 -> x < 0.5 ? (1.0 - EasingFunctions.easeIn(easingStyle, 1.0 - 2.0 * x)) / 2.0 : EasingFunctions.easeIn(easingStyle, 2.0 * x - 1.0) / 2.0 + 0.5;
            };
        }

        private static double easeIn(EasingStyle easingStyle, double x) {
            switch (easingStyle.ordinal()) {
                case 1: {
                    return 1.0 - Math.cos(x * Math.PI / 2.0);
                }
                case 2: {
                    return x * x;
                }
                case 3: {
                    return x * x * x;
                }
                case 4: {
                    return x * x * x * x;
                }
                case 5: {
                    return x * x * x * x * x;
                }
                case 6: {
                    return x == 0.0 ? 0.0 : Math.pow(2.0, 10.0 * x - 10.0);
                }
                case 7: {
                    return 1.0 - Math.sqrt(1.0 - Math.pow(x, 2.0));
                }
                case 8: {
                    double c1 = 1.70158;
                    double c3 = c1 + 1.0;
                    return c3 * x * x * x - c1 * x * x;
                }
                case 9: {
                    double c4 = 2.0943951023931953;
                    return x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : -Math.pow(2.0, 10.0 * x - 10.0) * Math.sin((x * 10.0 - 10.75) * c4));
                }
                case 10: {
                    double n1 = 7.5625;
                    double d1 = 2.75;
                    if (x < 1.0 / d1) {
                        return n1 * x * x;
                    }
                    if (x < 2.0 / d1) {
                        return n1 * (x -= 1.5 / d1) * x + 0.75;
                    }
                    if (x < 2.5 / d1) {
                        return n1 * (x -= 2.25 / d1) * x + 0.9375;
                    }
                    return n1 * (x -= 2.625 / d1) * x + 0.984375;
                }
            }
            return x;
        }
    }
}

