/*
 * Decompiled with CFR 0.152.
 */
package de.qwqu.qma.hud;

import de.qwqu.qma.Addon;
import java.util.Objects;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.hud.HudElement;
import meteordevelopment.meteorclient.systems.hud.HudElementInfo;
import meteordevelopment.meteorclient.systems.hud.HudRenderer;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;

public class StickTarget
extends HudElement {
    private final SettingGroup sgGeneral;
    private final Setting<SettingColor> primaryColor;
    private final Setting<SettingColor> secondaryColor;
    private final Setting<Boolean> alwaysRender;
    public static final HudElementInfo<StickTarget> INFO = new HudElementInfo(Addon.HUD_GROUP, "stick-target", "Displays the stick target.", StickTarget::new);

    public StickTarget() {
        super(INFO);
        this.sgGeneral = this.settings.getDefaultGroup();
        this.primaryColor = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("primary-color")).description("Primary Color.")).defaultValue(new SettingColor()).build());
        this.secondaryColor = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("secondary-color")).description("Secondary Color.")).defaultValue(new SettingColor(175, 175, 175)).build());
        this.alwaysRender = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("always-render")).description("Always render the element even when there is no target.")).defaultValue((Object)false)).build());
    }

    public void render(HudRenderer renderer) {
        if (this.isInEditor()) {
            double x = renderer.text("Target: ", (double)this.x, (double)this.y, (Color)this.primaryColor.get(), true);
            renderer.text("qwertyquarty", x, (double)this.y, (Color)this.secondaryColor.get(), true);
            this.setSize(renderer.textWidth("Target: qwertyquarty", true), renderer.textHeight(true));
            return;
        }
        if (Objects.equals(Addon.stick_targetName, "") && !((Boolean)this.alwaysRender.get()).booleanValue()) {
            return;
        }
        String displayText = "Target: " + Addon.stick_targetName;
        this.setSize(renderer.textWidth(displayText, true), renderer.textHeight(true));
        double x = renderer.text("Target: ", (double)this.x, (double)this.y, (Color)this.primaryColor.get(), true);
        renderer.text(Addon.stick_targetName, x, (double)this.y, (Color)this.secondaryColor.get(), true);
    }
}

