/*
 * Decompiled with CFR 0.152.
 */
package de.qwqu.qma.modules;

import de.qwqu.qma.Addon;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.BlockUpdateEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2338;

public class BreakRenderer
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Boolean> removeOnPlace;
    private final Setting<Boolean> fadeShapes;
    private final Setting<Integer> renderTime;
    private final Setting<ShapeMode> shapeMode;
    private final Setting<SettingColor> sideColor;
    private final Setting<SettingColor> lineColor;
    private final List<BreakTime> breakTimes;

    public BreakRenderer() {
        super(Addon.CATEGORY, "break-renderer", "Renders block breaks.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.removeOnPlace = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("remove-on-place")).description("Removes the box once a block is placed at that position.")).defaultValue((Object)true)).build());
        this.fadeShapes = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("fade-shapes")).description("Fade the shape alpha values or not.")).defaultValue((Object)true)).build());
        this.renderTime = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("render-time")).description("For how long the shapes are rendered.")).defaultValue((Object)500)).min(1).sliderRange(0, 5000).build());
        this.shapeMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("How the shapes are rendered.")).defaultValue((Object)ShapeMode.Both)).build());
        this.sideColor = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("side-color")).description("The side color of the rendering.")).defaultValue(new SettingColor(225, 0, 0, 75)).build());
        this.lineColor = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("line-color")).description("The line color of the rendering.")).defaultValue(new SettingColor(225, 0, 0, 255)).build());
        this.breakTimes = new LinkedList<BreakTime>();
    }

    @EventHandler
    private void onBlockUpdate(BlockUpdateEvent event) {
        if (event.newState.method_26215()) {
            if (!event.oldState.method_26227().method_15769()) {
                return;
            }
            this.breakTimes.add(new BreakTime(System.currentTimeMillis(), event.pos));
        } else if (((Boolean)this.removeOnPlace.get()).booleanValue()) {
            this.breakTimes.removeIf(pair -> pair.pos.equals((Object)event.pos));
        }
    }

    @EventHandler
    private void onRender3D(Render3DEvent event) {
        long currTime = System.currentTimeMillis();
        Iterator<BreakTime> iterator = this.breakTimes.iterator();
        while (iterator.hasNext()) {
            BreakTime pair = iterator.next();
            if (pair.time + (long)((Integer)this.renderTime.get()).intValue() < currTime) {
                iterator.remove();
                continue;
            }
            Color sColor = new Color((Color)this.sideColor.get());
            Color lColor = new Color((Color)this.lineColor.get());
            if (((Boolean)this.fadeShapes.get()).booleanValue()) {
                long elapsed = currTime - pair.time;
                float fadeFactor = 1.0f - (float)elapsed / (float)((Integer)this.renderTime.get()).intValue();
                sColor.a = (int)((float)sColor.a * fadeFactor);
                lColor.a = (int)((float)lColor.a * fadeFactor);
            }
            event.renderer.box(pair.pos, sColor, lColor, (ShapeMode)this.shapeMode.get(), 0);
        }
    }

    private record BreakTime(long time, class_2338 pos) {
    }
}

