/*
 * Decompiled with CFR 0.152.
 */
package de.qwqu.qma.modules;

import de.qwqu.qma.Addon;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.Rotations;
import meteordevelopment.orbit.EventHandler;

public class FidgetSpinner
extends Module {
    private final SettingGroup sgGeneral;
    private float spinYaw;
    private float spinPitch;
    private final Setting<RotationMode> yawMode;
    private final Setting<Integer> constYaw;
    private final Setting<RotationMode> pitchMode;
    private final Setting<Integer> constPitch;
    private final Setting<Integer> spinSpeed;

    public FidgetSpinner() {
        super(Addon.CATEGORY, "fidget-spinner", "Spins for you.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.yawMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("yaw-mode")).description("The way of spinning on the yaw angle.")).defaultValue((Object)RotationMode.Spin)).build());
        this.constYaw = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("yaw-constant")).description("The yaw constant.")).range(0, 360).sliderRange(0, 360).visible(() -> this.yawMode.get() == RotationMode.Constant)).build());
        this.pitchMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("pitch-mode")).description("The way of spinning on the pitch angle.")).defaultValue((Object)RotationMode.Constant)).build());
        this.constPitch = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("pitch-constant")).description("The pitch constant.")).range(-180, 180).sliderRange(-180, 180).visible(() -> this.pitchMode.get() == RotationMode.Constant)).build());
        this.spinSpeed = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("rotation-speed")).description("The speed of spinning.")).defaultValue((Object)20)).sliderRange(0, 100).visible(() -> this.pitchMode.get() == RotationMode.Spin || this.yawMode.get() == RotationMode.Spin)).build());
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        float newYaw = 0.0f;
        float newPitch = 0.0f;
        switch (((RotationMode)((Object)this.yawMode.get())).ordinal()) {
            case 0: {
                this.spinYaw += (float)((Integer)this.spinSpeed.get()).intValue();
                newYaw = this.spinYaw;
                break;
            }
            case 1: {
                newYaw = (float)Math.random() * 360.0f;
                break;
            }
            case 2: {
                newYaw = ((Integer)this.constYaw.get()).intValue();
                break;
            }
            case 3: {
                newYaw = this.mc.field_1724.method_36454();
            }
        }
        switch (((RotationMode)((Object)this.pitchMode.get())).ordinal()) {
            case 0: {
                this.spinPitch += (float)((Integer)this.spinSpeed.get()).intValue();
                newPitch = this.spinPitch;
                break;
            }
            case 1: {
                newPitch = (float)Math.random() * 360.0f - 180.0f;
                break;
            }
            case 2: {
                newPitch = ((Integer)this.constPitch.get()).intValue();
                break;
            }
            case 3: {
                newPitch = this.mc.field_1724.method_36455();
            }
        }
        Rotations.rotate((double)newYaw, (double)newPitch);
    }

    public static enum RotationMode {
        Spin,
        Random,
        Constant,
        Unchanged;

    }
}

