/*
 * Decompiled with CFR 0.152.
 */
package de.qwqu.qma.modules;

import de.qwqu.qma.Addon;
import meteordevelopment.meteorclient.events.game.GameLeftEvent;
import meteordevelopment.meteorclient.events.game.ReceiveMessageEvent;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_243;
import net.minecraft.class_2672;

public class MPServerSwitcher
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Boolean> autoSetTarget;
    private final Setting<Boolean> preservePosition;
    private final Setting<String> targetServer;
    private static final String BRAND = "Mineplay-Lobby (Velocity)";
    private boolean msgSent;
    public boolean inLobby;
    private boolean teleported;
    private class_243 lastPos;
    private float lastYaw;
    private float lastPitch;

    public MPServerSwitcher() {
        super(Addon.CATEGORY, "MPServerSwitcher", "Automatically switches the server. (for mc.mineplay.nl)");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.autoSetTarget = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("auto-set-target")).description("Automatically sets the target server.")).defaultValue((Object)true)).build());
        this.preservePosition = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("preserve-position")).description("Preserves your position when joining.")).defaultValue((Object)true)).build());
        this.targetServer = this.sgGeneral.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("target-server")).description("The server to teleport to when when spawning in.")).defaultValue((Object)"lobby")).build());
        this.msgSent = false;
        this.inLobby = false;
        this.teleported = false;
        this.lastPos = new class_243(0.0, 0.0, 0.0);
        this.lastYaw = 0.0f;
        this.lastPitch = 0.0f;
    }

    public String getInfoString() {
        return (String)this.targetServer.get();
    }

    private void onDisable() {
        this.msgSent = false;
    }

    @EventHandler
    private void onGameLeft(GameLeftEvent event) {
        this.msgSent = false;
    }

    @EventHandler
    private void onPacket(PacketEvent.Receive event) {
        if (this.msgSent) {
            return;
        }
        if (!(event.packet instanceof class_2672)) {
            return;
        }
        if (!this.inLobby) {
            return;
        }
        ChatUtils.sendPlayerMsg((String)("/server mineplay-" + (String)this.targetServer.get()));
        this.msgSent = true;
        this.inLobby = false;
        this.teleported = false;
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        this.inLobby = this.mc.method_1562().method_52790().equals(BRAND);
        if (this.inLobby) {
            return;
        }
        if (!((Boolean)this.preservePosition.get()).booleanValue()) {
            return;
        }
        if (!this.mc.field_1724.method_19538().equals((Object)this.lastPos) && !this.teleported) {
            this.mc.field_1724.method_18800(0.0, 0.0, 0.0);
            this.mc.field_1724.method_33574(this.lastPos);
            this.mc.field_1724.method_36456(this.lastYaw);
            this.mc.field_1724.method_36457(this.lastPitch);
            return;
        }
        this.teleported = true;
        this.lastPos = this.mc.field_1724.method_19538();
        this.lastYaw = this.mc.field_1724.method_36454();
        this.lastPitch = this.mc.field_1724.method_36455();
    }

    @EventHandler
    private void onMessageReceive(ReceiveMessageEvent event) {
        if (!((Boolean)this.autoSetTarget.get()).booleanValue()) {
            return;
        }
        String message = event.getMessage().getString();
        if (message.startsWith("[")) {
            return;
        }
        if (!message.contains("to mineplay-")) {
            return;
        }
        String server = message.split("mineplay-")[1];
        server = server.replaceAll("[^0-9]", "");
        this.targetServer.set((Object)server);
    }
}

