/*
 * Decompiled with CFR 0.152.
 */
package de.qwqu.qma.modules;

import de.qwqu.qma.Addon;
import java.util.List;
import meteordevelopment.meteorclient.events.world.CollisionShapeEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BlockListSetting;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2248;
import net.minecraft.class_238;
import net.minecraft.class_259;

public class NoCollision
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Boolean> useBoundingBox;
    private final Setting<List<class_2248>> blocks;
    private final Setting<ListMode> blockFilter;
    private final Setting<Boolean> borderCollision;

    public NoCollision() {
        super(Addon.CATEGORY, "no-collision", "Removes block and world border collision client-side.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.useBoundingBox = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("use-bounding-box")).description("Enables using bounding box collision instead of full block collision.")).defaultValue((Object)false)).build());
        this.blocks = this.sgGeneral.add((Setting)((BlockListSetting.Builder)((BlockListSetting.Builder)((BlockListSetting.Builder)((BlockListSetting.Builder)new BlockListSetting.Builder().name("blocks")).description("The blocks to fill the holes with.")).defaultValue(List.of())).visible(() -> (Boolean)this.useBoundingBox.get() == false)).build());
        this.blockFilter = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("block-filter")).description("How to use the block list setting")).defaultValue((Object)ListMode.Whitelist)).visible(() -> (Boolean)this.useBoundingBox.get() == false)).build());
        this.borderCollision = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("no-world-border-collision")).description("Cancels the collision with the world border to allow you to walk through it.")).defaultValue((Object)true)).visible(() -> (Boolean)this.useBoundingBox.get() == false)).build());
    }

    @EventHandler(priority=-175)
    private void onCollisionShape(CollisionShapeEvent event) {
        if (this.validBlock(event.state.method_26204()) && !((Boolean)this.useBoundingBox.get()).booleanValue()) {
            event.shape = class_259.method_1073();
        }
    }

    private boolean validBlock(class_2248 block) {
        if (this.blockFilter.get() == ListMode.Blacklist && ((List)this.blocks.get()).contains(block)) {
            return false;
        }
        return this.blockFilter.get() != ListMode.Whitelist || ((List)this.blocks.get()).contains(block);
    }

    public boolean shouldCancelBorderCollision() {
        return (Boolean)this.borderCollision.get();
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (((Boolean)this.useBoundingBox.get()).booleanValue()) {
            this.mc.field_1724.method_5857(new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        }
    }

    public static enum ListMode {
        Whitelist,
        Blacklist;

    }
}

