/*
 * Decompiled with CFR 0.152.
 */
package de.qwqu.qma.modules;

import de.qwqu.qma.Addon;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;

public class Orbit
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Double> sineSpeed;
    private final Setting<Double> sineOffset;
    private final Setting<Boolean> toggleX;
    private final Setting<Boolean> toggleY;
    private final Setting<Boolean> toggleZ;
    private double time;

    public Orbit() {
        super(Addon.CATEGORY, "orbit", "Orbits the player around a point.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sineSpeed = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("orbit-speed")).description("Speed of orbit.")).defaultValue(1.0).min(0.0).sliderMax(10.0).build());
        this.sineOffset = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("orbit-size")).description("Size of orbit.")).defaultValue(1.0).min(0.0).sliderMax(10.0).build());
        this.toggleX = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("orbit-x")).description("Toggle orbit around X axis.")).defaultValue((Object)true)).build());
        this.toggleY = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("lock-y")).description("Locks the Y axis.")).defaultValue((Object)true)).build());
        this.toggleZ = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("orbit-z")).description("Toggle orbit around Z axis.")).defaultValue((Object)true)).build());
        this.time = 0.0;
    }

    @EventHandler
    public void onTick(TickEvent.Post event) {
        this.time += 0.05;
        double sineWave = Math.sin(this.time * (Double)this.sineSpeed.get());
        double cosWave = Math.cos(this.time * (Double)this.sineSpeed.get());
        double x = sineWave * (Double)this.sineOffset.get();
        double z = cosWave * (Double)this.sineOffset.get();
        double newX = Addon.orbit_x + ((Boolean)this.toggleX.get() != false ? x : 0.0);
        double newY = (Boolean)this.toggleY.get() != false ? Addon.orbit_y.doubleValue() : this.mc.field_1724.method_23318();
        double newZ = Addon.orbit_z + ((Boolean)this.toggleZ.get() != false ? z : 0.0);
        this.mc.field_1724.method_5814(newX, newY, newZ);
    }
}

