/*
 * Decompiled with CFR 0.152.
 */
package de.qwqu.qma.modules;

import de.qwqu.qma.Addon;
import de.qwqu.qma.Util;
import java.util.ArrayList;
import java.util.List;
import meteordevelopment.meteorclient.events.meteor.MouseButtonEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.Vector3dSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.entity.SortPriority;
import meteordevelopment.meteorclient.utils.entity.TargetUtils;
import meteordevelopment.meteorclient.utils.misc.input.KeyAction;
import meteordevelopment.meteorclient.utils.player.PlayerUtils;
import meteordevelopment.meteorclient.utils.player.Rotations;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import org.joml.Vector3d;

public class Stick
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Follow> followMode;
    private final Setting<Double> viewAngleMultiplier;
    private final Setting<Boolean> rotate;
    private final Setting<Double> minY;
    private final Setting<Double> range;
    private final Setting<Vector3d> offset;
    private final Setting<Boolean> enableSine;
    private final Setting<Double> sineSpeed;
    private final Setting<Double> sineOffset;
    private final Setting<Boolean> stopFlying;
    private final Setting<Boolean> syncSticker;
    private final List<class_1297> targets;
    private double time;

    public Stick() {
        super(Addon.CATEGORY, "stick+", "Stick to a player.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.followMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("follow")).description("Which parts rotation to follow.")).defaultValue((Object)Follow.Head)).build());
        this.viewAngleMultiplier = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("view-angle-multiplier")).description("Multiplier for view angle mode.")).defaultValue(2.0).sliderRange(0.0, 10.0).visible(() -> this.followMode.get() == Follow.ViewAngle)).build());
        this.rotate = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("rotate")).description("Sets the rotation to the target's rotation.")).defaultValue((Object)true)).build());
        this.minY = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("minimum-y")).description("Minimum Y to use, so you don't go under the map. To disable, use something low.")).defaultValue(0.0).sliderRange(-64.0, 0.0).build());
        this.range = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("range")).description("The maximum range to set target.")).defaultValue(6.0).min(0.0).sliderMax(6.0).build());
        this.offset = this.sgGeneral.add((Setting)((Vector3dSetting.Builder)((Vector3dSetting.Builder)new Vector3dSetting.Builder().name("offset")).description("Offset from target.")).defaultValue(0.0, 0.0, 0.0).sliderRange(-3.0, 3.0).decimalPlaces(1).build());
        this.enableSine = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("enable-sine-wave")).description("Enable sine wave movement.")).defaultValue((Object)false)).build());
        this.sineSpeed = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("sine-speed")).description("Speed of sine wave movement.")).defaultValue(1.0).min(0.0).sliderMax(10.0).visible(() -> this.enableSine.get())).build());
        this.sineOffset = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("sine-offset")).description("Offset of sine wave movement.")).defaultValue(1.0).min(0.0).sliderMax(10.0).visible(() -> this.enableSine.get())).build());
        this.stopFlying = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("stop-flying")).description("Stops flying when no target is set.")).defaultValue((Object)false)).build());
        this.syncSticker = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("sync-with-sticker")).description("Synchronizes the target with the Sticker module.")).defaultValue((Object)false)).build());
        this.targets = new ArrayList<class_1297>();
        this.time = 0.0;
    }

    private boolean entityCheck(class_1297 entity) {
        if (entity.equals((Object)this.mc.field_1724) || entity.equals((Object)this.mc.field_1719)) {
            return false;
        }
        if (entity instanceof class_1309 && ((class_1309)entity).method_29504() || !entity.method_5805()) {
            return false;
        }
        if (!PlayerUtils.isWithin((class_1297)entity, (double)((Double)this.range.get()))) {
            return false;
        }
        return PlayerUtils.canSeeEntity((class_1297)entity) || PlayerUtils.isWithin((class_1297)entity, (double)((Double)this.range.get()));
    }

    @EventHandler
    private void onMouseButton(MouseButtonEvent event) {
        if (event.action == KeyAction.Press && event.button == 2 && this.mc.field_1755 == null) {
            class_1297 class_12972 = this.mc.field_1692;
            if (class_12972 instanceof class_1657) {
                class_1657 player = (class_1657)class_12972;
                Addon.stick_targetName = player.method_5477().getString();
                Addon.stick_targetEntity = null;
                Util.addStickerTarget(Addon.stick_targetName);
            } else if (this.mc.field_1692 != null) {
                Addon.stick_targetEntity = this.mc.field_1692;
                Addon.stick_targetName = "";
            } else {
                Addon.stick_targetName = "";
                Addon.stick_targetEntity = null;
                if (((Boolean)this.stopFlying.get()).booleanValue()) {
                    this.mc.field_1724.method_31549().field_7479 = false;
                }
            }
        }
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        class_1297 target;
        if (Addon.stick_targetEntity != null && Addon.stick_targetEntity.method_31747() || Addon.stick_targetName != "") {
            Addon.stick_targetEntity = Util.getTargetFromName(Addon.stick_targetName);
        }
        if ((target = Addon.stick_targetEntity) == null) {
            return;
        }
        this.mc.field_1724.method_31549().field_7479 = true;
        this.time += 0.05;
        double sineWave = 0.0;
        double cosWave = 0.0;
        if (((Boolean)this.enableSine.get()).booleanValue()) {
            sineWave = Math.sin(this.time * (Double)this.sineSpeed.get()) * (Double)this.sineOffset.get();
            cosWave = Math.cos(this.time * (Double)this.sineSpeed.get()) * (Double)this.sineOffset.get();
        }
        if (((Boolean)this.rotate.get()).booleanValue()) {
            Rotations.rotate((double)target.method_43078(), (double)0.0);
        }
        switch (((Follow)((Object)this.followMode.get())).ordinal()) {
            case 0: {
                class_243 head = target.method_5745(-1.0 + ((Vector3d)this.offset.get()).z, 0.05f, false).method_17784();
                this.mc.field_1724.method_5814(head.method_10216() + ((Vector3d)this.offset.get()).x + sineWave, Math.max((Double)this.minY.get(), head.method_10214() + ((Vector3d)this.offset.get()).y), head.method_10215() + cosWave);
                break;
            }
            case 1: {
                this.mc.field_1724.method_5814(target.method_23317() + ((Vector3d)this.offset.get()).x + sineWave, Math.max((Double)this.minY.get(), target.method_23318() + ((Vector3d)this.offset.get()).y), target.method_23321() + ((Vector3d)this.offset.get()).z + cosWave);
                break;
            }
            case 2: {
                class_243 vec = target.method_5828(1.0f);
                vec = vec.method_1021(((Double)this.viewAngleMultiplier.get()).doubleValue());
                this.mc.field_1724.method_5814(target.method_23317() + ((Vector3d)this.offset.get()).x + vec.field_1352, Math.max((Double)this.minY.get(), target.method_23318() + ((Vector3d)this.offset.get()).y + vec.field_1351), target.method_23321() + ((Vector3d)this.offset.get()).z + vec.field_1350);
            }
        }
    }

    public void onDeactivate() {
        if (((Boolean)this.stopFlying.get()).booleanValue()) {
            this.mc.field_1724.method_31549().field_7479 = false;
        }
    }

    public void setTarget() {
        TargetUtils.getList(this.targets, this::entityCheck, (SortPriority)SortPriority.LowestDistance, (int)1);
        if (!this.targets.isEmpty()) {
            class_1297 closest = this.targets.get(0);
            if (closest instanceof class_1657) {
                Addon.stick_targetName = closest.method_5477().getString();
                Addon.stick_targetEntity = null;
            } else {
                Addon.stick_targetEntity = closest;
                Addon.stick_targetName = "";
            }
        }
    }

    public static enum Follow {
        Head,
        Body,
        ViewAngle;

    }
}

