# Purpose: Use Spyder interface to update Excel file with new appointment.
Process = 'New Appointment Entry'

# Standard setup.
from favorite_modules import dt, pd, np, op, os, shutil, sys, win32com
import Ducks
Ducks.print_header(Process + ': Starting.')
Ducks.standard_display_options()

# Set Today date.
Today_obj, Today_str = Ducks.set_date('Business Date for Filename')

# Load source file tabs to dataframes.
dfClients, dfApps, dfArchive = Ducks.custom_vet_import(Today_obj)

# Define dictionaries.
dict_Last    = {'Label' : 'Last Name', 'Prompt' : ' ------->'}
dict_First   = {'Label' : 'First Name', 'Prompt' : ' ------>'}
dict_Area    = {'Label' : 'Residence Area', 'Prompt' : ' -->'}
dict_Email   = {'Label' : 'Email', 'Prompt' : ' ----------->'}
dict_Pet     = {'Label' : 'Pet Name', 'Prompt' : ' -------->'}
dict_Type    = {'Label' : 'Animal Type', 'Prompt' : ' ----->'}

dict_Purpose = {'Label' : 'Purpose', 'Prompt' : ' --------->'}
dict_Date    = {'Label' : 'Date MM/DD/YYYY', 'Prompt' : ' ->'}

dict_Time    = {'Label' : 'Time HH:MM:SS', 'Prompt' : ' --->'}

dict_list = [dict_Last, dict_First, dict_Area, dict_Email, dict_Pet, dict_Type,
             dict_Purpose, dict_Date, dict_Time]

# Enter new appointment data.
for dict in dict_list:
    dict['Value'] = input('Please enter ' + dict['Label'] + dict['Prompt'] )
print('')

# Quality Check: Time of day (TOD) entry.
TOD_Status = 'Pending'
while TOD_Status == 'Pending':
    try:
        Time_of_Day_obj = pd.to_timedelta(dict_Time['Value'])
        TOD_Status = 'Valid data entry.'
    except:
        dict_Time['Value'] = input('Warning - Incorrect format: ' + 
                                   dict_Time['Value'] + '. Enter as HH:MM:SS>')
        print('')
    
# Quality Check: All fields.
print('Quality Check: Please review data entered above.')

Answer = 'tbd'
while Answer != '':
    Answer = input('  - Hit Enter to Accept All or type Field to update>')
    if Answer != '':
        for dict in dict_list:
            if Answer == dict['Label']:
                dict['Value'] = input('Please enter ' + dict['Label'] + '>')

# Convert inputs into dataframe-compatable variables.
Client   = dict_Last['Value'] + '.' + dict_First['Value']
Date_obj = pd.to_datetime(dict_Date['Value']) + Time_of_Day_obj

# Create new appointment record.
dfApps_New = pd.DataFrame({'Appointment Date'   : [Date_obj],
                           'Client'             : [Client],
                           'Pet'                : [dict_Pet['Value']],
                           'Type'               : [dict_Type['Value']],
                           'Appointment Notes'  : [dict_Purpose['Value']]})

# Prep dfApps_New and add to dfApps.
dfApps_New[['Latest Weight (lb)', 'Latest Weight (kg)', 'Inv Amt']] = 0
dfApps_New['Inv Status'] = 'Pending'
dfApps = pd.concat([dfApps, dfApps_New])
dfApps = dfApps.sort_values(['Appointment Date', 'Client', 'Pet'])
dfApps.reset_index(drop = True, inplace= True)

# Update dfClients
dfClients_New = pd.DataFrame({'Last Updated'    : [Date_obj],
                              'Client'          : [Client],
                              'Pet'             : [dict_Pet['Value']],
                              'Type'            : [dict_Type['Value']],
                              'Medical History' : [dict_Purpose['Value']],
                              'Area'            : [dict_Area['Value']],
                              'Email'           : [dict_Email['Value']]})
dfClients_New[['Latest Weight (lb)', 'Latest Weight (kg)']] = 0

dfClients = pd.concat([dfClients, dfClients_New])
dfClients = dfClients.sort_values(['Client', 'Pet'])
dfClients.reset_index(drop = True, inplace = True)

# Export to and format in Excel file.
Ducks.custom_vet_export(Today_obj, dfClients, dfApps, dfArchive)

# Status message.
print(Process + ': Completed.\n')
