# Purpose: Analyze trends in client base.
Process = '\nCompare Future and Past Appointments by Area'

# Standard setup.
from favorite_modules import dt, pd, np, op, os, shutil, sys, win32com
import Ducks
Ducks.print_header(Process + ': Starting.')
Ducks.standard_display_options()

# Set Today date.
Today_obj, Today_str = Ducks.set_date('Business Date for Filename')

# Load source file tabs to dataframes.
dfClients, dfApps, dfArchive = Ducks.custom_vet_import(Today_obj)

# Define dictionaries.
dict_Past = {'View': 'Past',    'df' : dfArchive, 
             'count head' : 'Past Count',   '% head' : 'Past %'}
dict_Fut  = {'View' : 'Future', 'df' : dfApps,    
             'count head' : 'Future Count', '% head' : 'Future %'}
dict_list = [ dict_Past, dict_Fut]

# Create pivot table analysis for both Past and Future appoinment data.
for dict in dict_list:
    
    df = dict['df']
    df['View'] = dict['count head']
    
    # Add Area field from dfClients to appointment dataframe.
    dfClients_Select = dfClients[['Client', 'Area']]
    dict['df'] = pd.merge(left  = dict['df'],
                          right = dfClients,
                          how   = 'left')
    
    # Generate raw pivot table.
    dict['dfArea'] = pd.pivot_table(data    = dict['df'],
                                    values  = 'Type',
                                    index   = 'Area',
                                    columns = 'View',
                                    aggfunc      = 'count',
                                    margins      = True,
                                    margins_name = 'zTotal')
    
    # CLean up pivot table.
    dict['dfArea'] = dict['dfArea'].drop(columns = 'zTotal')
    Count = dict['dfArea'].loc['zTotal', dict['count head']]
    dict['dfArea'][dict['% head']] = dict['dfArea'][dict['count head']] / Count

# Create composite table for trend analysis.    
dfPivot_Area = pd.concat([dict_Past['dfArea'], dict_Fut['dfArea']], axis = 1)
dfPivot_Area = dfPivot_Area.fillna(0)
dfPivot_Area = dfPivot_Area.sort_index()
Ducks.print_header('Trend Analysis by Area')
print(dfPivot_Area)

# Status message.
print(Process + ': Completed.\n')
