# Purpose of Script: Create daily file for business date ("Today") using "Yesterday" file. 
Process = 'Daily File Rollover'

# Standard setup.
from favorite_modules import dt, pd, np, op, os, shutil, sys, win32com
import Ducks
Ducks.print_header(Process + ': Starting.')
Ducks.standard_display_options()

# Set Today and Yesterday date.
Biz_Date_obj, Biz_Date_str  = Ducks.set_date('Business Date for New File')
Yesterday_obj = Biz_Date_obj - pd.DateOffset(days = 1)

# Define Yesterday file Pathname.
File_Yesterday = Yesterday_obj.strftime('%Y %m%d') + ' - Vet.xlsx'
Folder         = 'C:/Customers/'
Path_Yesterday = Folder + File_Yesterday
 
# Define Today file Path.
File       = Biz_Date_obj.strftime('%Y %m%d') + ' - Vet.xlsx'
Folder     = 'C:/Customers/'
Path_Today = Folder + File

# Copy Yesterday to Create Today file.
shutil.copy(Path_Yesterday, Path_Today)

# Move Yesterday file to archive folder.
Folder_Yesterday       = 'C:/Customers/Archive/'
Path_Yesterday_Archive = Folder_Yesterday + File_Yesterday

os.rename(Path_Yesterday, Path_Yesterday_Archive)

# Status messages.
print('Yesterday file: ' + File_Yesterday + '; archived to: ' + Folder_Yesterday)
print('Today file    : ' + File + '; saved to   : ' + Folder)

# Status message.
print('\n' + Process + ': Completed.\n')
