# Purpose: Review and manage Today's appointments.
Process = 'Today\'s Appointments'

# Standard setup.
from favorite_modules import dt, pd, np, op, os, shutil, sys, win32com
import Ducks
Ducks.print_header(Process + ': Starting.')
Ducks.standard_display_options()

# Set Today date.
Today_obj, Today_str = Ducks.set_date('Today')

# Load source file tabs to dataframes.
dfClients, dfApps, dfArchive = Ducks.custom_vet_import(Today_obj)

# Subset and display today's appointments.
dfApps['Just Date Temp'] = dfApps['Appointment Date'].dt.floor('d')
dfApps_Today = dfApps[dfApps['Just Date Temp'] == Today_obj].copy()
dfApps_Today = dfApps_Today.sort_values('Appointment Date')
dfApps_Today.reset_index(drop = True, inplace = True)
dfApps_Today = dfApps_Today[['Appointment Date', 'Client', 
                             'Pet', 'Appointment Notes']]

# Display today appointments.
Ducks.print_header('Today Appointments: ' + Today_str)
print(dfApps_Today)
print('')
Ducks.pause()

# Email today appointment table.
Emails = 'vet@example.com'
Answer = input('Enter y to add email to distribution>')
if Answer == 'y':
    Add_Email = input('Enter email address>')
    Emails    = Emails + ';' + Add_Email 

Subject     = 'Today\'s Appointments: ' + Today_str
Body_Text   = 'Today\'s Appointments: ' + Today_str 
HTML_Object =  dfApps_Today.to_html()
Ducks.auto_email(Subject, Body_Text, HTML_Object, Emails)

# Status message.
print('\n' + Process + ': Completed.\n')
