# Purpose: Update Excel file with notes from today's appointments.
Process = 'Update File with Appointment Notes.'

# Standard setup.
from favorite_modules import dt, pd, np, op, os, shutil, sys, win32com
import Ducks
Ducks.print_header(Process + ': Starting.')
Ducks.standard_display_options()

# Set Today.
Today_obj, Today_str = Ducks.set_date('Business Date for Filename')

# Load source file tabs to dataframes.
dfClients, dfApps, dfArchive = Ducks.custom_vet_import(Today_obj)

# Subset dfApps for today appointment and print select columns.
dfApps['Just Date Temp'] = dfApps['Appointment Date'].dt.floor('d')
dfToday = dfApps[dfApps['Just Date Temp'] == Today_obj].copy()
Ducks.print_header('Today Appointments')
Select_Column_List = ['Appointment Date', 'Client', 'Pet']
print(dfToday[Select_Column_List], '\n')
dfApps = dfApps.drop(columns = ['Just Date Temp'])

# Select appointment record to be updated.
Index_ID = int(input('Enter index for appointment to update>'))
print('')

# Ask user to key in hand-written notes.
Today_Weight                            = float(input('Enter weight (lbs) ->'))
Today_Notes                             =       input('Today notes -------->') 
Today_Inv_Amt                           = int(  input('Enter Inv Amt ------>'))
Today_Inv_Status                        =       input('Enter Inv Status --->')
print('')

# Overwrite Appointments dataframe with in handwritten notes.
dfApps.at[Index_ID, 'Inv Amt']            = Today_Inv_Amt
dfApps.at[Index_ID, 'Inv Status']         = Today_Inv_Status
dfApps.at[Index_ID, 'Latest Weight (lb)'] = Today_Weight
dfApps.at[Index_ID, 'Latest Weight (kg)'] = Today_Weight * 0.45
dfApps.at[Index_ID, 'Appointment Notes' ] = Today_Notes

# Update select fields in dfClients
Pet = dfApps.loc[Index_ID, 'Pet']
Medical_History = dfClients.loc[dfClients['Pet'] == Pet, 'Medical History'].iloc[0]
Medical_History_New = Medical_History + ' * ' + Today_str + ' ' + Today_Notes
dfClients.loc[dfClients['Pet'] == Pet, 'Medical History']    = Medical_History_New
dfClients.loc[dfClients['Pet'] == Pet, 'Latest Weight (lb)'] = Today_Weight 
dfClients.loc[dfClients['Pet'] == Pet, 'Latest Weight (kg)'] = Today_Weight * 0.45

# Archive appointment.
dfArchive_App = dfApps.loc[[Index_ID]]
dfArchive_App = dfArchive_App.rename(columns = 
                                     {'Latest Weight (lb)' : 'Weight (lb)',
                                      'Latest Weight (kg)' : 'Weight (kg)'})
dfArchive = pd.concat([dfArchive, dfArchive_App])
dfArchive = dfArchive.sort_values(['Client', 'Pet', 'Appointment Date'])

# Drop appointment from Appointments dataframe.
dfApps = dfApps.drop(Index_ID)

# Export to and format in Excel file.
Ducks.custom_vet_export(Today_obj, dfClients, dfApps, dfArchive)

# Status message.
print(Process + ': Completed.\n')


