# Purpose: To identify overdue invoices and email reminders.
Process = 'Overdue Invoice Tracking'

# Standard setup.
from favorite_modules import dt, pd, np, op, os, shutil, sys, win32com
import Ducks
Ducks.print_header(Process + ': Starting.')
Ducks.standard_display_options()

# Set Today date.
Today_obj, Today_str  = Ducks.set_date('Today Date')

# Load source file tabs to dataframes.
dfClients, dfApps, dfArchive = Ducks.custom_vet_import(Today_obj)

# Subset for unpaid invoices.
dfUn = dfArchive[dfArchive['Inv Status'] == 'Unpaid'].copy()
dfUn = dfUn[['Client', 'Appointment Date', 'Inv Amt', 'Inv Status']]
dfUn = dfUn.merge(dfClients[['Client', 'Email']])

# Create dataframe with unpaid invoices in excess of 30 days.
Overdue_Reference_obj = Today_obj - pd.DateOffset(days = 30)
dfOver = dfUn[dfUn['Appointment Date'] < Overdue_Reference_obj].copy()
Ducks.print_header('Overdue Invoice List')
print(dfOver[['Client', 'Appointment Date', 'Inv Amt', 'Email']], '\n')

# Option to overwrite Me.Me client data with workable email.
Answer = input('Want to customize the Me.Me email address? Enter y or n>')
print('')
if Answer == 'y':
    New_Email_Address = input('Enter custom email address>')
    dfOver.loc[dfOver['Client'] == 'Me.Me', 'Email'] = New_Email_Address
    
# Create unique list of overdue clients.
Overdue_List= np.unique(dfOver['Client'].to_list())

# Send email for each overdue invoice.
for Client in Overdue_List:
    dfInv = dfOver[dfOver['Client'] == Client].copy()
    Date       = dfInv['Appointment Date'].iloc[0]
    Amount_Due = dfInv['Inv Amt'].iloc[0]
    
    # Define email UDF inputs
    Subject     = 'Invoice Reminder from ' + Date.strftime('%m/%d/%Y')
    Body_Text   = ('This is a reminder that an invoice ' 
                  + ' for $' + str(Amount_Due) 
                  + ' is over 30 days overdue.')
    HTML_Object = ''
    Emails      = dfInv['Email'].iloc[0]
        
    # Confirm and send email.
    Answer = input('Enter y to email ' + Client + '>')
    if Answer == 'y':
        Ducks.auto_email(Subject, Body_Text, HTML_Object, Emails) 

# Status message.
print(Process + ': Completed.\n')
