/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.beans.util;

import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MethodInvoker;

public abstract class AbstractEventInvoker<EventType> {
    private Object eventProducer;
    private Object target;
    private String methodName;
    private Object[] arguments;
    private String listenerAddMethodName;
    private String listenerRemoveMethodName;
    private EventType event;
    private boolean invokeSynchronously;

    public AbstractEventInvoker(Object eventProducer, Object target, String methodName) {
        this(eventProducer, target, methodName, null);
    }

    public AbstractEventInvoker(Object eventProducer, Object target, String methodName, Object ... arguments) {
        this.setTarget(target);
        this.setMethodName(methodName);
        this.setEventProducer(eventProducer);
        this.setArguments(arguments);
        this.setInvokeSynchronously(false);
    }

    public Object getEventProducer() {
        return this.eventProducer;
    }

    public void setEventProducer(Object eventProducer) {
        if (this.eventProducer != null) {
            this.removeAsListener(this.eventProducer);
        }
        this.eventProducer = eventProducer;
        if (eventProducer == null) {
            return;
        }
        this.addAsListener(this.eventProducer);
    }

    private void addAsListener(Object eventProducer) {
        if (this.listenerAddMethodName == null) {
            return;
        }
        new MethodInvoker(eventProducer, this.listenerAddMethodName, this).invoke();
    }

    private void removeAsListener(Object eventProducer) {
        if (this.listenerRemoveMethodName == null) {
            return;
        }
        new MethodInvoker(eventProducer, this.listenerRemoveMethodName, this).invoke();
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object ... arguments) {
        this.arguments = arguments;
    }

    protected void setListenerAddRemoveMethodNames(String listenerAddMethodName, String listenerRemoveMethodName) {
        this.setListenerAddMethodName(listenerAddMethodName);
        this.setListenerRemoveMethodName(listenerRemoveMethodName);
        if (this.eventProducer != null) {
            this.removeAsListener(this.eventProducer);
        }
        this.addAsListener(this.eventProducer);
    }

    protected String getListenerAddMethodName() {
        return this.listenerAddMethodName;
    }

    private void setListenerAddMethodName(String listenerAddMethodName) {
        this.listenerAddMethodName = listenerAddMethodName;
    }

    protected String getListenerRemoveMethodName() {
        return this.listenerRemoveMethodName;
    }

    private void setListenerRemoveMethodName(String listenerRemoveMethodName) {
        this.listenerRemoveMethodName = listenerRemoveMethodName;
    }

    public boolean isInvokeSynchronously() {
        return this.invokeSynchronously;
    }

    public void setInvokeSynchronously(boolean invokeSynchronously) {
        this.invokeSynchronously = invokeSynchronously;
    }

    protected void invoke() {
        if (this.invokeSynchronously) {
            if (this.arguments == null) {
                new MethodInvoker(this.target, this.methodName, new Object[0]).invoke();
            } else {
                new MethodInvoker(this.target, this.methodName, this.arguments).invoke();
            }
        } else if (this.arguments == null) {
            new AsynchMethodInvoker(this.target, this.methodName);
        } else {
            new AsynchMethodInvoker(this.target, this.methodName, this.arguments);
        }
    }

    public EventType getEvent() {
        return this.event;
    }

    public void setEvent(EventType event) {
        this.event = event;
    }
}

