/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.graphics;

import com.jmorgan.graphics.BitmapInfoHeader;
import com.jmorgan.swing.util.RGBQuad;
import java.awt.Color;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class BitmapInfo {
    private BitmapInfoHeader bitmapInfoHeader = new BitmapInfoHeader();
    private ArrayList<Color> colors = new ArrayList();

    public BitmapInfoHeader getBitmapInfoHeader() {
        return this.bitmapInfoHeader;
    }

    public Color[] getColors() {
        Color[] colorTable = new Color[this.colors.size()];
        int i = 0;
        while (i < colorTable.length) {
            colorTable[i] = this.colors.get(i);
            ++i;
        }
        return colorTable;
    }

    public String toString() {
        Object s = this.bitmapInfoHeader.toString();
        int i = 0;
        while (i < this.colors.size()) {
            s = (String)s + "\n" + this.colors.get(i).toString();
            ++i;
        }
        return s;
    }

    public void read(RandomAccessFile raf) throws IOException {
        int entryCount = 0;
        this.bitmapInfoHeader.read(raf);
        switch (this.bitmapInfoHeader.getBitsPerPixel()) {
            case 1: {
                entryCount = 2;
                break;
            }
            case 4: {
                entryCount = 16;
                break;
            }
            case 8: {
                entryCount = 256;
                break;
            }
            case 24: {
                entryCount = 0;
            }
        }
        if (entryCount > 0) {
            int i = 0;
            while (i < entryCount) {
                RGBQuad rgbSet = new RGBQuad();
                rgbSet.read(raf);
                this.colors.add(rgbSet.getColor());
                ++i;
            }
        }
    }
}

