/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.graphics.drawing;

import com.jmorgan.graphics.drawing.Drawer;
import com.jmorgan.graphics.drawing.DrawingSyntaxError;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.NumberUtility;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.Arrays;

public class DescriptiveDrawer
implements Drawer {
    private static final String[] COLORS = new String[]{"black", "blue", "cyan", "gray", "green", "red", "white", "yellow"};
    private static final Color[] COLOR_MAP = new Color[]{Color.black, Color.blue, Color.cyan, Color.gray, Color.green, Color.red, Color.white, Color.yellow};
    private static final String[] LINE_STYLES = new String[]{"solid", "dashed", "dotted"};
    private static final int[] LINE_STYLE_MAP;
    private static final String[] FONT_STYLES;
    private static final int[] FONT_STYLE_MAP;
    private Point penLocation;
    private Color lineColor;
    private Color fillColor;
    private Font font;
    private int fontStyle;
    private int fontSize;
    private int thickness;
    private int lineStyle;
    private boolean fillFlag;
    private String description;
    private Graphics2D graphics;

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        LINE_STYLE_MAP = nArray;
        FONT_STYLES = new String[]{"plain", "normal", "p", "n", "bold", "b", "italic", "i", "bolditalic", "bi"};
        int[] nArray2 = new int[10];
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArray2[6] = 2;
        nArray2[7] = 2;
        nArray2[8] = 3;
        nArray2[9] = 3;
        FONT_STYLE_MAP = nArray2;
    }

    public DescriptiveDrawer(String description) {
        this.reset();
        this.setDescription(description);
    }

    public void reset() {
        this.setPenLocation(new Point(0, 0));
        this.setLineColor(Color.BLACK);
        this.setFillColor(Color.BLACK);
        this.setFont(new Font("MS Sans Serif", 0, 12));
        this.setFontSize(12);
        this.setThickness(1);
        this.setLineStyle(0);
        this.setFillFlag(false);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description.toLowerCase();
    }

    private void setFillFlag(boolean fillFlag) {
        this.fillFlag = fillFlag;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        if (fillColor == null) {
            return;
        }
        this.fillColor = fillColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int fontStyle) {
        this.fontStyle = fontStyle;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(int lineStyle) {
        if (lineStyle < 0) {
            return;
        }
        this.lineStyle = lineStyle;
    }

    public Point getPenLocation() {
        return this.penLocation;
    }

    public void setPenLocation(Point penLocation) {
        if (penLocation == null) {
            return;
        }
        this.penLocation = penLocation;
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int thickness) {
        this.thickness = thickness;
    }

    @Override
    public void draw(Graphics graphics) {
        String[] commands;
        this.graphics = (Graphics2D)graphics;
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        String[] stringArray = commands = this.description.split(";");
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            String command = stringArray[n2];
            if ((command = command.trim()).equals("reset")) {
                this.reset();
            } else {
                if (command.startsWith("fill")) {
                    this.setFillFlag(true);
                    command = command.substring(5);
                }
                String commandName = this.getCommandName(command);
                String[] args = this.getCommandArgs(command);
                new MethodInvoker((Object)this, commandName, new Object[]{args}).invoke();
            }
            ++n2;
        }
    }

    private String getCommandName(String command) {
        int openParen = command.indexOf(40);
        if (openParen == -1) {
            throw new DrawingSyntaxError(this.description);
        }
        return command.substring(0, openParen);
    }

    private String[] getCommandArgs(String command) {
        int openParen = command.indexOf(40);
        int closeParen = command.indexOf(41);
        if (openParen == -1 || closeParen == -1) {
            throw new DrawingSyntaxError(this.description);
        }
        String args = command.substring(openParen + 1, closeParen);
        return args.split(",");
    }

    public void arc(String[] args) {
        if (args.length != 4 && args.length != 6) {
            throw new DrawingSyntaxError("arc(" + Arrays.toString(args) + ")");
        }
        int[] numbers = DescriptiveDrawer.convertToNumbers(args);
        if (numbers == null) {
            throw new DrawingSyntaxError("Bad Number in: arc(" + Arrays.toString(args) + ")");
        }
        int widthIndex = 0;
        if (args.length == 6) {
            this.setLocation(numbers[0], numbers[1]);
            widthIndex = 2;
        }
        int width = numbers[widthIndex];
        int height = numbers[widthIndex + 1];
        int startAngle = numbers[widthIndex + 2];
        int arcAngle = numbers[widthIndex + 3];
        if (this.fillFlag) {
            this.graphics.setColor(this.getFillColor());
            this.graphics.fillArc(this.penLocation.x, this.penLocation.y, width, height, startAngle, arcAngle);
            this.setFillFlag(false);
        }
        this.graphics.setStroke(this.getStroke());
        this.graphics.setColor(this.getLineColor());
        this.graphics.drawArc(this.penLocation.x, this.penLocation.y, width, height, startAngle, arcAngle);
    }

    public void circle(String[] args) {
        if (args.length != 1 && args.length != 3) {
            throw new DrawingSyntaxError("circle(" + Arrays.toString(args) + ")");
        }
        int[] numbers = DescriptiveDrawer.convertToNumbers(args);
        if (numbers == null) {
            throw new DrawingSyntaxError("Bad Number in: circle(" + Arrays.toString(args) + ")");
        }
        int radiusArg = 0;
        if (args.length == 3) {
            this.setLocation(numbers[0], numbers[1]);
            radiusArg = 2;
        }
        int radius = numbers[radiusArg];
        if (this.fillFlag) {
            this.graphics.setColor(this.getFillColor());
            this.graphics.fillOval(this.penLocation.x, this.penLocation.y, radius, radius);
            this.setFillFlag(false);
        }
        this.graphics.setStroke(this.getStroke());
        this.graphics.setColor(this.getLineColor());
        this.graphics.drawOval(this.penLocation.x, this.penLocation.y, radius, radius);
    }

    public void color(String[] args) {
        int colorIndex;
        if (args.length != 1 && args.length != 3) {
            throw new DrawingSyntaxError("color(" + Arrays.toString(args) + ")");
        }
        Color c = null;
        if (args.length == 1 && (colorIndex = ArrayUtility.indexOf(args[0], COLORS)) >= 0) {
            c = COLOR_MAP[colorIndex];
        }
        if (args.length == 3) {
            int[] numbers = DescriptiveDrawer.convertToNumbers(args);
            if (numbers == null) {
                throw new DrawingSyntaxError("Bad Number in: color(" + Arrays.toString(args) + ")");
            }
            c = new Color(numbers[0], numbers[1], numbers[2]);
        }
        if (c == null) {
            throw new DrawingSyntaxError("Color not identified in: color(" + Arrays.toString(args) + ")");
        }
        if (this.fillFlag) {
            this.setFillColor(c);
            this.setFillFlag(false);
        } else {
            this.setLineColor(c);
        }
    }

    public void ellipse(String[] args) {
        if (args.length != 2 && args.length != 4) {
            throw new DrawingSyntaxError("ellipse(" + Arrays.toString(args) + ")");
        }
        int[] numbers = DescriptiveDrawer.convertToNumbers(args);
        if (numbers == null) {
            throw new DrawingSyntaxError("Bad Number in: ellipse(" + Arrays.toString(args) + ")");
        }
        int radiusArg = 0;
        if (args.length == 4) {
            this.setLocation(numbers[0], numbers[1]);
            radiusArg = 2;
        }
        int w = numbers[radiusArg];
        int h = numbers[radiusArg + 1];
        if (this.fillFlag) {
            this.graphics.setColor(this.getFillColor());
            this.graphics.fillOval(this.penLocation.x, this.penLocation.y, w, h);
            this.setFillFlag(false);
        }
        this.graphics.setStroke(this.getStroke());
        this.graphics.setColor(this.getLineColor());
        this.graphics.drawOval(this.penLocation.x, this.penLocation.y, w, h);
    }

    public void font(String[] args) {
        if (args.length < 1 || args.length > 3) {
            throw new DrawingSyntaxError("font(" + Arrays.toString(args) + ")");
        }
        int sizeIndex = -1;
        int styleIndex = -1;
        int i = 1;
        while (i < args.length) {
            if (NumberUtility.isInteger(args[i])) {
                sizeIndex = i;
            } else {
                styleIndex = i;
            }
            ++i;
        }
        if (sizeIndex > -1) {
            this.setFontSize(Integer.parseInt(args[sizeIndex].trim()));
        }
        if (styleIndex > -1) {
            this.setFontStyle(FONT_STYLE_MAP[ArrayUtility.indexOf(args[styleIndex].trim(), FONT_STYLES)]);
        }
        this.setFont(new Font(args[0].trim(), this.getFontStyle(), this.getFontSize()));
        this.setFillFlag(false);
    }

    public void line(String[] args) {
        if (args.length != 2 && args.length != 4) {
            throw new DrawingSyntaxError("line(" + Arrays.toString(args) + ")");
        }
        int[] numbers = DescriptiveDrawer.convertToNumbers(args);
        if (numbers == null) {
            throw new DrawingSyntaxError("Bad Number in: line(" + Arrays.toString(args) + ")");
        }
        Point endPoint = null;
        if (args.length == 4) {
            this.setLocation(numbers[0], numbers[1]);
            endPoint = new Point(numbers[2], numbers[3]);
        } else {
            endPoint = new Point(numbers[0], numbers[1]);
        }
        this.graphics.setStroke(this.getStroke());
        this.graphics.setColor(this.getLineColor());
        this.graphics.drawLine(this.penLocation.x, this.penLocation.y, endPoint.x, endPoint.y);
        this.setLocation(endPoint.x, endPoint.y);
        this.setFillFlag(false);
    }

    public void linestyle(String[] args) {
        if (args.length != 1) {
            throw new DrawingSyntaxError("linestyle(" + Arrays.toString(args) + ")");
        }
        if (!Comparison.isIn(args[0].trim(), LINE_STYLES)) {
            throw new DrawingSyntaxError("Line Style not valid: linestyle(" + Arrays.toString(args) + ")");
        }
        this.setLineStyle(LINE_STYLE_MAP[ArrayUtility.indexOf(args[0].trim(), LINE_STYLES)]);
    }

    public void move(String[] args) {
        if (args.length != 2) {
            throw new DrawingSyntaxError("move(" + Arrays.toString(args) + ")");
        }
        int[] numbers = DescriptiveDrawer.convertToNumbers(args);
        if (numbers == null) {
            throw new DrawingSyntaxError("Bad Number in: move(" + Arrays.toString(args) + ")");
        }
        this.setLocation(numbers[0], numbers[1]);
        this.setFillFlag(false);
    }

    public void polygon(String[] args) {
        int[] numbers = DescriptiveDrawer.convertToNumbers(args);
        if (numbers == null) {
            throw new DrawingSyntaxError("Bad Number in: polygon(" + Arrays.toString(args) + ")");
        }
        if (numbers.length % 2 != 0) {
            throw new DrawingSyntaxError("Uneven point pairs: polygon(" + Arrays.toString(args) + ")");
        }
        int[] xPoints = new int[numbers.length / 2];
        int[] yPoints = new int[numbers.length / 2];
        int i = 0;
        int j = 0;
        while (i < numbers.length - 1) {
            xPoints[j] = numbers[i];
            yPoints[j] = numbers[i + 1];
            i += 2;
            ++j;
        }
        if (this.fillFlag) {
            this.graphics.setColor(this.getFillColor());
            this.graphics.fillPolygon(xPoints, yPoints, xPoints.length);
            this.setFillFlag(false);
        }
        this.graphics.setColor(this.getLineColor());
        this.graphics.setStroke(this.getStroke());
        this.graphics.drawPolygon(xPoints, yPoints, xPoints.length);
        this.setLocation(numbers[numbers.length - 2], numbers[numbers.length - 1]);
    }

    public void rect(String[] args) {
        if (args.length != 2 && args.length != 4) {
            throw new DrawingSyntaxError("rect(" + Arrays.toString(args) + ")");
        }
        int[] numbers = DescriptiveDrawer.convertToNumbers(args);
        if (numbers == null) {
            throw new DrawingSyntaxError("Bad Number in: rect(" + Arrays.toString(args) + ")");
        }
        int whIndex = 0;
        if (args.length == 4) {
            this.setLocation(numbers[0], numbers[1]);
            whIndex = 2;
        }
        this.drawRect(numbers[whIndex], numbers[whIndex + 1]);
    }

    public void square(String[] args) {
        if (args.length != 1 && args.length != 3) {
            throw new DrawingSyntaxError("square(" + Arrays.toString(args) + ")");
        }
        int[] numbers = DescriptiveDrawer.convertToNumbers(args);
        if (numbers == null) {
            throw new DrawingSyntaxError("Bad Number in: square(" + Arrays.toString(args) + ")");
        }
        int sizeIndex = 0;
        if (args.length == 3) {
            this.setLocation(numbers[0], numbers[1]);
            sizeIndex = 2;
        }
        this.drawRect(numbers[sizeIndex], numbers[sizeIndex]);
    }

    private void drawRect(int width, int height) {
        if (this.fillFlag) {
            this.graphics.setColor(this.getFillColor());
            this.graphics.fillRect(this.penLocation.x, this.penLocation.y, width, height);
            this.setFillFlag(false);
        }
        this.graphics.setStroke(this.getStroke());
        this.graphics.setColor(this.getLineColor());
        this.graphics.drawRect(this.penLocation.x, this.penLocation.y, width, height);
    }

    public void text(String[] args) {
        if (args.length != 1 && args.length != 3) {
            throw new DrawingSyntaxError("text(" + Arrays.toString(args) + ")");
        }
        int textIndex = 0;
        if (args.length == 3) {
            this.setLocation(Integer.parseInt(args[0]), Integer.parseInt(args[1]));
            textIndex = 2;
        }
        String text = args[textIndex];
        this.graphics.setColor(this.getLineColor());
        this.graphics.setFont(this.getFont());
        this.graphics.drawString(text, this.penLocation.x, this.penLocation.y);
        this.setFillFlag(false);
    }

    public void thickness(String[] args) {
        if (args.length != 1) {
            throw new DrawingSyntaxError("thickness(" + Arrays.toString(args) + ")");
        }
        int[] numbers = DescriptiveDrawer.convertToNumbers(args);
        if (numbers == null) {
            throw new DrawingSyntaxError("Bad Number in: thickness(" + Arrays.toString(args) + ")");
        }
        this.setThickness(numbers[0]);
    }

    private static int[] convertToNumbers(String[] args) {
        int[] numbers = new int[args.length];
        int i = 0;
        while (i < args.length) {
            if (!NumberUtility.isInteger(args[i])) {
                return null;
            }
            numbers[i] = Integer.parseInt(args[i].trim());
            ++i;
        }
        return numbers;
    }

    private Stroke getStroke() {
        float[] dashPattern = null;
        switch (this.getLineStyle()) {
            case 0: {
                dashPattern = new float[]{1.0f, 1.0f};
                break;
            }
            case 1: {
                dashPattern = new float[]{6.0f, 6.0f};
                break;
            }
            case 2: {
                dashPattern = new float[]{1.0f, 3.0f};
            }
        }
        return new BasicStroke(this.getThickness(), 1, 1, 1.0f, dashPattern, 3.0f);
    }

    @Override
    public Point getLocation() {
        return this.penLocation;
    }

    @Override
    public Dimension getSize() {
        return null;
    }

    public void setLocation(int x, int y) {
        this.penLocation.x = x;
        this.penLocation.y = y;
    }

    @Override
    public void setLocation(Point location) {
        this.penLocation = location;
    }

    @Override
    public void setSize(Dimension size) {
    }
}

