/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public abstract class AbstractStreamHelper<StreamType> {
    protected ArrayList<StreamType> streamStack = new ArrayList();
    protected int bufferSize;
    protected IOException exception;
    protected boolean isOpen;

    AbstractStreamHelper() {
        this(16384);
    }

    AbstractStreamHelper(int bufferedSize) {
        this.setBufferSize(bufferedSize);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public StreamType getStream() {
        int stackSize = this.streamStack.size();
        if (stackSize == 0) {
            throw new IllegalStateException(String.format("%s.getStream():  open() has not been called.", this.getClass().getSimpleName()));
        }
        return this.streamStack.get(stackSize - 1);
    }

    public void stackStream(StreamType stream) {
        this.streamStack.add(stream);
    }

    public abstract StreamType open();

    public boolean close() {
        this.exception = null;
        this.isOpen = false;
        try {
            int stackSize = this.streamStack.size();
            int i = stackSize - 1;
            while (i >= 0) {
                StreamType stream = this.streamStack.get(i);
                if (stream instanceof InputStream) {
                    InputStream inputStream = (InputStream)stream;
                    inputStream.close();
                } else if (stream instanceof OutputStream) {
                    OutputStream outputStream = (OutputStream)stream;
                    outputStream.close();
                }
                --i;
            }
            return true;
        }
        catch (IOException e) {
            this.exception = e;
            return false;
        }
    }

    public IOException getException() {
        return this.exception;
    }
}

