/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import com.jmorgan.io.RetrievalArgument;
import java.util.ArrayList;

public class LogicalGroup {
    private ArrayList<LogicalGroup> groups = new ArrayList();
    private boolean not;
    private OPERATORS operator;
    private ArrayList<RetrievalArgument> groupArguments;
    private int evaluationOrder;

    public static final LogicalGroup createANDGroup() {
        return new LogicalGroup(OPERATORS.AND);
    }

    public static final LogicalGroup createORGroup() {
        return new LogicalGroup(OPERATORS.OR);
    }

    private LogicalGroup(OPERATORS operator) {
        this.setOperator(operator);
    }

    public void addGroup(LogicalGroup group) {
        if (group == null) {
            return;
        }
        this.groups.add(group);
    }

    public void removeGroup(LogicalGroup group) {
        if (group == null || this.groups.size() == 0) {
            return;
        }
        this.groups.remove(group);
    }

    public void addRetrievalArgument(RetrievalArgument argument) {
        if (argument == null) {
            return;
        }
        if (this.groupArguments == null) {
            this.groupArguments = new ArrayList();
        }
        this.groupArguments.add(argument);
    }

    public void removeRetrievalArgument(RetrievalArgument argument) {
        if (argument == null || this.groupArguments == null) {
            return;
        }
        this.groupArguments.remove(argument);
    }

    public ArrayList<LogicalGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(ArrayList<LogicalGroup> groups) {
        this.groups = groups;
    }

    public boolean isNot() {
        return this.not;
    }

    public void setNot(boolean not) {
        this.not = not;
    }

    public OPERATORS getOperator() {
        return this.operator;
    }

    public void setOperator(OPERATORS operator) {
        this.operator = operator;
    }

    public ArrayList<RetrievalArgument> getGroupArguments() {
        return this.groupArguments;
    }

    public void setGroupArguments(ArrayList<RetrievalArgument> groupArguments) {
        this.groupArguments = groupArguments;
    }

    public int getEvaluationOrder() {
        return this.evaluationOrder;
    }

    public void setEvaluationOrder(int evaluationOrder) {
        this.evaluationOrder = evaluationOrder;
    }

    private static enum OPERATORS {
        AND,
        OR;

    }
}

