/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.lang;

import com.jmorgan.lang.InvocationEvent;
import com.jmorgan.lang.InvocationListener;
import com.jmorgan.lang.MethodInvocationInstance;
import com.jmorgan.lang.Types;
import com.jmorgan.util.DateTime;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AllPermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public abstract class AbstractMethodInvoker<RT> {
    private static HashMap<String, MethodInvocationInstance> invocationCache = new HashMap();
    private static boolean debug;
    private Object object;
    private Method method;
    private Object[] arguments;
    private ArrayList<InvocationListener> invocationListeners;
    private long creationTime;
    private long cancelledTime;
    private long invocationTime;
    private long invocationCompletedTime;
    private boolean shouldInvoke;
    protected boolean cancel;
    protected boolean hasCompleted;
    protected RT returnValue;

    public static final void setDebug(boolean state) {
        debug = state;
    }

    public static final boolean getDebug() {
        return debug;
    }

    public AbstractMethodInvoker(Class<?> type, Method method, Object ... arguments) {
        this.setCreationTime(System.currentTimeMillis());
        this.method = method;
        this.arguments = arguments;
        this.addMethodToCache(type, method, this.getArgClasses(arguments));
    }

    public AbstractMethodInvoker(Object object, Method method, Object ... arguments) {
        this.setCreationTime(System.currentTimeMillis());
        this.object = object;
        this.method = method;
        this.arguments = arguments;
        this.addMethodToCache(this.object.getClass(), method, this.getArgClasses(arguments));
    }

    public AbstractMethodInvoker(Class<?> type, String methodName, Object ... arguments) {
        this.setCreationTime(System.currentTimeMillis());
        this.resolveMethod(type, methodName, arguments);
    }

    public AbstractMethodInvoker(Object object, String methodName, Object ... arguments) {
        this.setCreationTime(System.currentTimeMillis());
        this.object = object;
        this.resolveMethod(object.getClass(), methodName, arguments);
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public long getCancelledTime() {
        return this.cancelledTime;
    }

    public void setCancelledTime(long cancelledTime) {
        this.cancelledTime = cancelledTime;
    }

    public long getInvocationTime() {
        return this.invocationTime;
    }

    public void setInvocationTime(long invocationTime) {
        this.invocationTime = invocationTime;
    }

    public long getInvocationCompletedTime() {
        return this.invocationCompletedTime;
    }

    public void setInvocationCompletedTime(long invocationCompletedTime) {
        this.invocationCompletedTime = invocationCompletedTime;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object ... arguments) {
        this.arguments = arguments;
        this.resolveMethod(this.object.getClass(), this.method.getName(), arguments);
    }

    private void resolveMethod(Class<?> type, String methodName, Object ... arguments) {
        Class<?>[] argClasses;
        block10: {
            block9: {
                this.arguments = arguments;
                argClasses = this.getArgClasses(arguments);
                MethodInvocationInstance mii = this.getMethodFromCache(type, methodName, argClasses);
                if (mii != null) {
                    this.method = mii.getMethod();
                    if (this.method != null) {
                        return;
                    }
                    throw new RuntimeException("Method was not found in prior search");
                }
                try {
                    this.method = this.getMethod(type, methodName, argClasses);
                }
                catch (SecurityException e) {
                    System.err.println("AbstractMethodInvoker.AbstractMethodInvoker(object, \"" + methodName + "\", arguments): Cannot access the method " + methodName + " within " + type.getName());
                    e.printStackTrace();
                    throw e;
                }
                catch (NoSuchMethodException e) {
                    this.method = this.findMethod(type, methodName, argClasses);
                    if (this.method != null) break block9;
                    throw new RuntimeException(String.format("The method '%s' does not exist within '%s'", methodName, type.getName()), e);
                }
            }
            try {
                this.method.setAccessible(true);
            }
            catch (SecurityException e) {
                SecurityManager sm = System.getSecurityManager();
                if (sm == null) break block10;
                try {
                    AllPermission allPermission = new AllPermission();
                    sm.checkPermission(allPermission);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        this.addMethodToCache(type, this.method, argClasses);
    }

    private Class<?>[] getArgClasses(Object ... arguments) {
        Class[] argClasses = new Class[arguments.length];
        int i = 0;
        while (i < arguments.length) {
            if (arguments[i] instanceof AbstractMethodInvoker) {
                AbstractMethodInvoker argProxy = (AbstractMethodInvoker)arguments[i];
                argClasses[i] = argProxy.getMethod().getReturnType();
            } else {
                argClasses[i] = arguments[i] == null ? null : arguments[i].getClass();
            }
            ++i;
        }
        return argClasses;
    }

    private void addMethodToCache(Class<?> targetType, Method method, Class<?>[] argClasses) {
        String key = this.getKey(targetType, method.getName(), argClasses);
        invocationCache.put(key, new MethodInvocationInstance(targetType, method, argClasses));
    }

    private MethodInvocationInstance getMethodFromCache(Class<?> targetType, String methodName, Class<?>[] argClasses) {
        String key = this.getKey(targetType, methodName, argClasses);
        MethodInvocationInstance mii = invocationCache.get(key);
        return mii;
    }

    private String getKey(Class<?> targetType, String methodName, Class<?>[] argClasses) {
        StringBuilder sb = new StringBuilder(targetType.getName());
        sb.append(methodName);
        Class<?>[] classArray = argClasses;
        int n = argClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> argClass = classArray[n2];
            if (argClass == null) {
                sb.append("null");
            } else {
                sb.append(argClass.getName());
            }
            ++n2;
        }
        return sb.toString();
    }

    public Object getObject() {
        return this.object;
    }

    public boolean hasMethod() {
        return this.method != null;
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public Method getMethod() {
        return this.method;
    }

    /*
     * Unable to fully structure code
     */
    private Method getMethod(Class<?> targetType, String methodName, Class<?>[] parmTypes) throws SecurityException, NoSuchMethodException {
        try {
            method = targetType.getDeclaredMethod(methodName, parmTypes);
            return method;
        }
        catch (SecurityException e) {
            method = targetType.getMethod(methodName, parmTypes);
            return method;
        }
        catch (NoSuchMethodException e) {
            sClass = targetType.getSuperclass();
            if (sClass != null) {
                method = this.getMethod(sClass, methodName, parmTypes);
                return method;
            }
            sb = new StringBuilder("The method ");
            sb.append(methodName);
            sb.append('(');
            i = 0;
            ** while (i < parmTypes.length)
        }
lbl-1000:
        // 1 sources

        {
            if (parmTypes[i] == null) {
                sb.append("null");
            } else {
                sb.append(parmTypes[i].getName());
            }
            if (i < parmTypes.length - 1) {
                sb.append(", ");
            }
            ++i;
            continue;
        }
lbl33:
        // 1 sources

        sb.append(") does not exist within ");
        sb.append(targetType.getName());
        throw new NoSuchMethodException(sb.toString());
    }

    private Method findMethod(Class<?> type, String methodName, Class<?>[] argTypes) {
        Method method = null;
        int maxWeight = 0;
        Method[] methods = this.getMethods(type, methodName, null);
        int i = 0;
        while (i < methods.length) {
            block17: {
                Class<?>[] parmTypes;
                if (methodName.equalsIgnoreCase(methods[i].getName()) && (parmTypes = methods[i].getParameterTypes()).length == argTypes.length) {
                    int weight = 0;
                    int j = 0;
                    while (j < argTypes.length) {
                        if (argTypes[j] == null) {
                            weight += 10;
                        } else if (parmTypes[j].equals(argTypes[j])) {
                            weight += 10;
                        } else if (parmTypes[j].isAssignableFrom(argTypes[j])) {
                            weight += 5;
                        } else if (parmTypes[j].isPrimitive() && Types.isPrimitiveWrapper(argTypes[j])) {
                            int w = Types.getPrimitiveMatchWeight(parmTypes[j], argTypes[j]);
                            if (w == 0) break block17;
                            weight += w;
                        } else if (argTypes[j].isInterface() && this.isInterfaceCompatible(parmTypes[j], argTypes[j])) {
                            weight += 10;
                        } else if (parmTypes[j].isInterface() && this.isInterfaceCompatible(argTypes[j], parmTypes[j])) {
                            weight += 10;
                        } else {
                            if (parmTypes[j] != String.class) break block17;
                            weight += 15;
                        }
                        ++j;
                    }
                    if (weight > maxWeight) {
                        maxWeight = weight;
                        method = methods[i];
                    }
                }
            }
            ++i;
        }
        return method;
    }

    private Method[] getMethods(Class<?> aClass, String methodName, ArrayList<Method> list) {
        if (list == null) {
            list = new ArrayList();
        }
        Method[] methods = null;
        try {
            methods = aClass.getDeclaredMethods();
        }
        catch (SecurityException se) {
            methods = aClass.getMethods();
        }
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(methodName)) {
                list.add(method);
            }
            ++n2;
        }
        Class<?> sClass = aClass.getSuperclass();
        if (sClass != null) {
            this.getMethods(sClass, methodName, list);
        }
        return list.toArray(new Method[0]);
    }

    private boolean isInterfaceCompatible(Class<?> theClass, Class<?> theInterface) {
        Class<?>[] classInterfaces = theClass.getInterfaces();
        if (classInterfaces.length == 0) {
            if (theClass.equals(Object.class)) {
                return false;
            }
            Class<?> ancestor = theClass.getSuperclass();
            return this.isInterfaceCompatible(ancestor, theInterface);
        }
        int i = 0;
        while (i < classInterfaces.length) {
            if (theInterface.equals(classInterfaces[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public RT getReturnValue() {
        return this.returnValue;
    }

    public void cancel() {
        this.setCancelledTime(System.currentTimeMillis());
        this.cancel = true;
        this.fireInvocationEvent(this.hasCompleted(), true, this.getMethod().getReturnType(), this.getReturnValue());
    }

    public boolean wasCanceled() {
        return this.cancel;
    }

    public boolean hasCompleted() {
        return this.hasCompleted;
    }

    public RT invoke() {
        Object[] methodArgs;
        block12: {
            methodArgs = new Object[this.arguments.length];
            int i = 0;
            while (i < this.arguments.length) {
                if (this.arguments[i] instanceof AbstractMethodInvoker) {
                    AbstractMethodInvoker invoker = (AbstractMethodInvoker)this.arguments[i];
                    methodArgs[i] = invoker.invoke();
                } else {
                    methodArgs[i] = this.arguments[i];
                }
                ++i;
            }
            Class<?>[] parmTypes = this.method.getParameterTypes();
            int i2 = 0;
            while (i2 < parmTypes.length) {
                if (parmTypes[i2].isPrimitive() && methodArgs[i2] == null) {
                    methodArgs[i2] = Types.getDefaultPrimitiveValue(parmTypes[i2]);
                }
                if (parmTypes[i2] == String.class && methodArgs[i2] != null && methodArgs[i2].getClass() != String.class) {
                    methodArgs[i2] = methodArgs[i2].toString();
                }
                ++i2;
            }
            this.shouldInvoke = true;
            this.fireInvocationEvent(false, false, this.method.getReturnType(), null);
            if (this.shouldInvoke) break block12;
            this.cancel();
            return null;
        }
        try {
            this.setInvocationTime(System.currentTimeMillis());
            this.returnValue = methodArgs.length == 0 ? this.method.invoke(this.object, new Object[0]) : this.method.invoke(this.object, methodArgs);
            this.fireInvocationEvent(true, false, this.method.getReturnType(), this.returnValue);
            return this.returnValue;
        }
        catch (ClassCastException e) {
            System.err.println("AbstractMethodInvoker.invoke():  Class Cast Exception invoking " + this.method.getName() + " within " + this.object.getClass().getName());
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            System.err.println("AbstractMethodInvoker.invoke():  Bad argument(s) [" + Arrays.toString(methodArgs) + "] delivered to " + this.method.getName() + " within " + this.object.getClass().getName());
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.err.println("AbstractMethodInvoker.invoke():  Cannot access " + this.method.getName() + " within " + this.object.getClass().getName());
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void addInvocationListener(InvocationListener invocationListener) {
        if (this.invocationListeners == null) {
            this.invocationListeners = new ArrayList();
        }
        this.invocationListeners.add(invocationListener);
    }

    public void removeInvocationListener(InvocationListener invocationListener) {
        if (this.invocationListeners == null) {
            return;
        }
        this.invocationListeners.remove(invocationListener);
    }

    protected void fireInvocationEvent(boolean invoked, boolean cancelled, Class<?> returnType, Object returnValue) {
        if (invoked) {
            this.setInvocationCompletedTime(System.currentTimeMillis());
        }
        if (this.invocationListeners == null || this.invocationListeners.size() == 0) {
            return;
        }
        InvocationEvent invocationEvent = new InvocationEvent(this.object, this.method, this.arguments, returnType, returnValue);
        invocationEvent.setCancelled(cancelled);
        invocationEvent.setCreationTime(new DateTime(this.creationTime));
        if (cancelled) {
            invocationEvent.setCancelledTime(new DateTime(this.cancelledTime));
        }
        if (invoked && !cancelled) {
            invocationEvent.setInvocationTime(new DateTime(this.invocationTime));
        }
        if (invoked) {
            invocationEvent.setInvocationCompletedTIme(new DateTime(this.invocationCompletedTime));
        }
        ArrayList<InvocationListener> looper = new ArrayList<InvocationListener>(this.invocationListeners);
        for (InvocationListener listener : looper) {
            if (!invoked && !cancelled) {
                boolean shouldInvoke = listener.methodInvocationNotice(invocationEvent);
                if (this.shouldInvoke && !shouldInvoke) {
                    this.shouldInvoke = false;
                }
            }
            if (!invoked && cancelled) {
                listener.methodInvocationCancelled(invocationEvent);
            }
            if (!invoked || cancelled) continue;
            listener.methodInvoked(invocationEvent);
        }
    }
}

